/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.odt.List;
import com.xmlmind.fo.converter.odt.Paragraph;
import com.xmlmind.fo.converter.odt.Table;
import com.xmlmind.fo.converter.odt.TableAndCaption;
import com.xmlmind.fo.converter.odt.Text;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public final class Footnote {
    private Paragraph label;
    private Vector body = new Vector();

    public Footnote() {
    }

    public Footnote(Paragraph paragraph) {
        this.setLabel(paragraph);
    }

    public void setLabel(Paragraph paragraph) {
        this.label = paragraph;
    }

    private void add(int n, Object object) {
        this.body.addElement(new Element(n, object));
    }

    public void add(Paragraph paragraph) {
        this.add(0, paragraph);
    }

    public void add(Table table) {
        this.add(1, table);
    }

    public void add(TableAndCaption tableAndCaption) {
        this.add(2, tableAndCaption);
    }

    public void add(List list) {
        this.add(3, list);
    }

    public void print(PrintWriter printWriter, Encoder encoder) {
        if (this.label != null) {
            Text text = this.label.text();
            text.print(printWriter, encoder);
        }
        printWriter.println("<text:note text:note-class=\"footnote\">");
        printWriter.print("<text:note-citation text:label=\"&#8203;\">");
        printWriter.print(" ");
        printWriter.println("</text:note-citation>");
        printWriter.println("<text:note-body>");
        int n = this.body.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.body.elementAt(i);
            switch (element.type) {
                case 0: {
                    Paragraph paragraph = (Paragraph)element.object;
                    paragraph.print(printWriter, encoder);
                    continue block6;
                }
                case 1: {
                    Table table = (Table)element.object;
                    table.print(printWriter, encoder);
                    continue block6;
                }
                case 2: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    tableAndCaption.print(printWriter, encoder);
                    continue block6;
                }
                case 3: {
                    List list = (List)element.object;
                    list.print(printWriter, encoder);
                }
            }
        }
        printWriter.println("</text:note-body>");
        printWriter.println("</text:note");
        printWriter.print(">");
    }

    private String citation() {
        if (this.label != null) {
            Text text = this.label.text();
            return text.content;
        }
        return "";
    }

    private class Element {
        static final int TYPE_PARAGRAPH = 0;
        static final int TYPE_TABLE = 1;
        static final int TYPE_TABLE_AND_CAPTION = 2;
        static final int TYPE_LIST = 3;
        int type;
        Object object;

        Element(int n, Object object) {
            this.type = n;
            this.object = object;
        }
    }
}

