/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.odt.Borders;
import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.objects.Region;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public final class HeaderFooterProperties {
    public static final int COLOR_TRANSPARENT = -1;
    public double height = 28.346456692913385;
    public boolean minHeight = true;
    public double marginTop;
    public double marginBottom;
    public double marginLeft;
    public double marginRight;
    public double paddingTop;
    public double paddingBottom;
    public double paddingLeft;
    public double paddingRight;
    public int background = -1;
    public Borders borders;

    public HeaderFooterProperties() {
    }

    public HeaderFooterProperties(Region region) {
        this();
        this.initialize(region);
    }

    public void initialize(Region region) {
        this.height = HeaderFooterProperties.length(region.properties[99]);
        this.paddingTop = HeaderFooterProperties.length(region.paddingTop);
        this.paddingBottom = HeaderFooterProperties.length(region.paddingBottom);
        this.paddingLeft = HeaderFooterProperties.length(region.paddingLeft);
        this.paddingRight = HeaderFooterProperties.length(region.paddingRight);
        Value value = region.properties[8];
        if (value.type == 24) {
            this.background = Odt.rgb(value.color());
        }
        this.borders = new Borders(region.properties);
    }

    private static double length(Value value) {
        double d = 0.0;
        if (value.type == 4) {
            d = value.length();
        }
        return d;
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("<style:header-footer-properties");
        if (this.minHeight) {
            printWriter.println(" fo:min-height=\"" + Odt.length(this.height, 1) + "\"");
        } else {
            printWriter.println(" svg:height=\"" + Odt.length(this.height, 1) + "\"");
        }
        if (this.marginTop != 0.0) {
            printWriter.println(" fo:margin-top=\"" + Odt.length(this.marginTop, 1) + "\"");
        }
        if (this.marginBottom != 0.0) {
            printWriter.println(" fo:margin-bottom=\"" + Odt.length(this.marginBottom, 1) + "\"");
        }
        if (this.marginLeft != 0.0) {
            printWriter.println(" fo:margin-left=\"" + Odt.length(this.marginLeft, 1) + "\"");
        }
        if (this.marginRight != 0.0) {
            printWriter.println(" fo:margin-right=\"" + Odt.length(this.marginRight, 1) + "\"");
        }
        if (this.paddingTop != 0.0) {
            printWriter.println(" fo:padding-top=\"" + Odt.length(this.paddingTop, 1) + "\"");
        }
        if (this.paddingBottom != 0.0) {
            printWriter.println(" fo:padding-bottom=\"" + Odt.length(this.paddingBottom, 1) + "\"");
        }
        if (this.paddingLeft != 0.0) {
            printWriter.println(" fo:padding-left=\"" + Odt.length(this.paddingLeft, 1) + "\"");
        }
        if (this.paddingRight != 0.0) {
            printWriter.println(" fo:padding-right=\"" + Odt.length(this.paddingRight, 1) + "\"");
        }
        if (this.background != -1) {
            printWriter.println(" fo:background-color=\"" + Odt.color(this.background) + "\"");
        }
        if (this.borders != null) {
            this.borders.print(printWriter);
        }
        printWriter.println("/>");
    }
}

