/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.GraphicLayout;
import com.xmlmind.fo.converter.odt.Borders;
import com.xmlmind.fo.converter.odt.GraphicStyle;
import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.converter.odt.OdtEntry;
import com.xmlmind.fo.converter.odt.OdtGraphicEnv;
import com.xmlmind.fo.graphic.Graphic;
import com.xmlmind.fo.graphic.GraphicEnv;
import com.xmlmind.fo.graphic.GraphicFactories;
import com.xmlmind.fo.graphic.GraphicUtil;
import com.xmlmind.fo.objects.ExternalGraphic;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import com.xmlmind.fo.util.URLUtil;
import java.io.PrintWriter;

public final class Image {
    private int id;
    private Graphic graphic;
    private OdtGraphicEnv graphicEnv;
    private boolean prescaled;
    private int imageResolution;
    private int imageRendererResolution;
    private String[] graphicFormats;
    private Encoder encoder;
    private GraphicStyle style;
    private double xScale = 1.0;
    private double yScale = 1.0;
    private Graphic image;
    private String imageName;
    private GraphicLayout layout;
    private static final String[] graphicFormats1 = new String[]{"image/x-wmf", "image/x-emf", "image/jpeg", "image/png"};
    private static final String[] graphicFormats2 = new String[]{"image/x-wmf", "image/x-emf", "image/png"};

    public Image(int n, Graphic graphic, OdtGraphicEnv odtGraphicEnv, Context context, boolean bl, int n2, int n3, boolean bl2, Encoder encoder) {
        this.id = n;
        this.graphic = graphic;
        this.graphicEnv = odtGraphicEnv;
        this.prescaled = bl;
        this.imageResolution = n2;
        this.imageRendererResolution = n3;
        this.graphicFormats = bl2 ? graphicFormats2 : graphicFormats1;
        this.encoder = encoder;
        this.style = Image.style(context);
    }

    private static GraphicStyle style(Context context) {
        GraphicStyle graphicStyle = new GraphicStyle();
        Value[] valueArray = context.properties.values;
        graphicStyle.anchorType = 4;
        switch (valueArray[3].keyword()) {
            case 121: {
                graphicStyle.verticalPosition = 1;
                graphicStyle.verticalRelation = 9;
                break;
            }
            case 17: 
            case 199: {
                graphicStyle.verticalPosition = 0;
                graphicStyle.verticalRelation = 9;
                break;
            }
            case 5: 
            case 198: {
                graphicStyle.verticalPosition = 2;
                graphicStyle.verticalRelation = 9;
                break;
            }
            default: {
                graphicStyle.verticalPosition = 0;
                graphicStyle.verticalRelation = 8;
            }
        }
        graphicStyle.borders = new Borders(valueArray);
        graphicStyle.paddingTop = Image.length(valueArray[208]);
        graphicStyle.paddingBottom = Image.length(valueArray[199]);
        graphicStyle.paddingLeft = Image.length(valueArray[203]);
        graphicStyle.paddingRight = Image.length(valueArray[204]);
        if (context.background != null) {
            graphicStyle.background = Odt.rgb(context.background);
        }
        return graphicStyle;
    }

    private static double length(Value value) {
        double d = 0.0;
        if (value.type == 4) {
            d = value.length();
        }
        return d;
    }

    public double width() {
        double d = GraphicLayout.width(this.graphic, this.imageResolution);
        if (d == 0.0) {
            d = GraphicLayout.intrinsicWidth(this.graphic, this.imageResolution);
        }
        d += this.style.borders.left.width + this.style.paddingLeft;
        return d += this.style.borders.right.width + this.style.paddingRight;
    }

    public void layout(double d) throws Exception {
        if (this.image != null) {
            return;
        }
        d -= this.style.borders.left.width + this.style.paddingLeft;
        this.layout = new GraphicLayout(this.graphic, this.imageResolution, d -= this.style.borders.right.width + this.style.paddingRight);
        double d2 = GraphicLayout.intrinsicWidth(this.graphic, this.imageRendererResolution);
        double d3 = GraphicLayout.intrinsicHeight(this.graphic, this.imageRendererResolution);
        if (this.layout.contentWidth != d2) {
            this.xScale = this.layout.contentWidth / d2;
        }
        if (this.layout.contentHeight != d3) {
            this.yScale = this.layout.contentHeight / d3;
        }
        switch (this.graphic.getType()) {
            case 2: {
                this.prescaled = true;
                break;
            }
            case 0: {
                this.prescaled = false;
                break;
            }
            default: {
                if (this.xScale < 1.0 && this.yScale < 1.0) break;
                this.prescaled = false;
            }
        }
        try {
            this.image = this.prescaled ? GraphicFactories.convertGraphic(this.graphic, this.graphicFormats, this.xScale, this.yScale, null, (GraphicEnv)this.graphicEnv) : GraphicFactories.convertGraphic(this.graphic, this.graphicFormats, 1.0, 1.0, null, (GraphicEnv)this.graphicEnv);
        }
        catch (Exception exception) {
            this.graphicEnv.reportWarning("failed to convert image \"" + this.graphic.getLocation() + "\": " + exception.getMessage());
            return;
        }
        this.imageName = Odt.imageName(this.id, GraphicUtil.formatToSuffix(this.image.getFormat()));
        OdtEntry odtEntry = new OdtEntry(this.imageName, this.image.getFormat(), URLUtil.locationToFilename(this.image.getLocation()));
        this.graphicEnv.fileEntries.addElement(odtEntry);
        if (this.layout.contentWidth != this.layout.viewportWidth || this.layout.contentHeight != this.layout.viewportHeight) {
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            if (this.layout.contentWidth < this.layout.viewportWidth) {
                d4 = -this.layout.contentX;
                double d8 = this.layout.contentX + this.layout.contentWidth;
                d6 = -(this.layout.viewportWidth - d8);
            } else if (this.layout.contentWidth > this.layout.viewportWidth) {
                d4 = this.layout.cropX;
                double d9 = this.layout.cropX + this.layout.viewportWidth;
                d6 = this.layout.contentWidth - d9;
            }
            if (this.layout.contentHeight < this.layout.viewportHeight) {
                d5 = -this.layout.contentY;
                double d10 = this.layout.contentY + this.layout.contentHeight;
                d7 = -(this.layout.viewportHeight - d10);
            } else if (this.layout.contentHeight > this.layout.viewportHeight) {
                d5 = this.layout.cropY;
                double d11 = this.layout.cropY + this.layout.viewportHeight;
                d7 = this.layout.contentHeight - d11;
            }
            if (!this.prescaled) {
                d4 /= this.xScale;
                d6 /= this.xScale;
                d5 /= this.yScale;
                d7 /= this.yScale;
            }
            this.style.clipTop = d5;
            this.style.clipBottom = d7;
            this.style.clipLeft = d4;
            this.style.clipRight = d6;
        }
        this.style = this.graphicEnv.styleTable.add(this.style);
    }

    public void print(PrintWriter printWriter) {
        if (this.image == null) {
            return;
        }
        double d = this.layout.viewportWidth;
        double d2 = this.layout.viewportHeight;
        printWriter.print("<draw:frame");
        printWriter.println(" draw:name=\"image" + this.id + "\"");
        printWriter.println(" draw:style-name=\"" + this.style.name + "\"");
        printWriter.println(" svg:width=\"" + Odt.length(d += this.style.paddingLeft + this.style.paddingRight, 1) + "\"");
        printWriter.println(" svg:height=\"" + Odt.length(d2 += this.style.paddingTop + this.style.paddingBottom, 1) + "\"");
        printWriter.print(">");
        printWriter.println("<draw:image");
        printWriter.println(" xlink:href=\"" + this.imageName + "\"");
        printWriter.print("/>");
        String string = null;
        ExternalGraphic externalGraphic = GraphicLayout.properties(this.graphic);
        if (externalGraphic != null) {
            string = externalGraphic.role;
        }
        if (string != null && string.length() > 0) {
            printWriter.print("<svg:title>");
            printWriter.print(Odt.escape(string, this.encoder));
            printWriter.print("</svg:title>");
        }
        printWriter.println("</draw:frame");
        printWriter.print(">");
    }
}

