/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.properties.PropertyValues;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;

public final class Link {
    private static final int TYPE_NONE = 0;
    private static final int TYPE_INTERNAL = 1;
    private static final int TYPE_EXTERNAL = 2;
    private int type;
    private String target;

    public Link(Context context) {
        PropertyValues propertyValues = context.properties;
        if (propertyValues.isSpecified(132)) {
            this.type = 1;
            Value value = propertyValues.values[132];
            this.target = value.idref();
        } else if (propertyValues.isSpecified(100)) {
            this.type = 2;
            Value value = propertyValues.values[100];
            this.target = value.uriSpecification();
        }
    }

    public void start(PrintWriter printWriter, Encoder encoder) {
        if (this.target != null && this.target.length() > 0) {
            String string = this.type == 1 ? "#" + Odt.escape(this.target, encoder) : Odt.escape(this.target, encoder);
            printWriter.print("<text:a");
            printWriter.println(" xlink:href=\"" + string + "\"");
            printWriter.print(">");
        }
    }

    public void end(PrintWriter printWriter) {
        if (this.target != null && this.target.length() > 0) {
            printWriter.println("</text:a");
            printWriter.print(">");
        }
    }
}

