/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.odt.List;
import com.xmlmind.fo.converter.odt.ListStyle;
import com.xmlmind.fo.converter.odt.Paragraph;
import com.xmlmind.fo.converter.odt.ParagraphStyle;
import com.xmlmind.fo.converter.odt.StyleTable;
import com.xmlmind.fo.converter.odt.Table;
import com.xmlmind.fo.converter.odt.TableAndCaption;
import com.xmlmind.fo.converter.odt.Text;
import com.xmlmind.fo.properties.LabelFormat;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public final class ListItem {
    public int breakBefore;
    public boolean keepTogether;
    public boolean keepWithNext;
    public double marginTop;
    public double marginBottom;
    public double labelStart;
    public double labelWidth;
    public double labelSeparation;
    public double bodyStart;
    public boolean containsTable;
    public boolean containsList;
    private Paragraph label;
    private Vector body = new Vector();
    private double referenceWidth;
    private int listType;

    public ListItem(Context context) {
        this.initialize(context);
    }

    private void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        switch (context.breakBefore) {
            case 1: {
                this.breakBefore = 1;
                break;
            }
            case 2: {
                this.breakBefore = 2;
            }
        }
        this.keepTogether = ListItem.keep(valueArray[137]);
        this.keepWithNext = ListItem.keep(valueArray[141]);
        this.marginTop = context.spaceBefore();
        Context context2 = context.ancestor(19);
        valueArray = context2.properties.values;
        this.labelSeparation = valueArray[224].length();
    }

    private static boolean keep(Value value) {
        boolean bl = false;
        switch (value.type) {
            case 1: {
                if (value.keyword() != 8) break;
                bl = true;
                break;
            }
            case 2: {
                if (value.integer() <= 0) break;
                bl = true;
            }
        }
        return bl;
    }

    public void setLabel(Paragraph paragraph) {
        if (this.label == null) {
            this.label = paragraph;
        }
    }

    private void add(int n, Object object) {
        this.body.addElement(new Element(n, object));
    }

    public void add(Paragraph paragraph) {
        this.add(0, paragraph);
    }

    public void add(Table table) {
        this.add(1, table);
        this.containsTable = true;
    }

    public void add(TableAndCaption tableAndCaption) {
        this.add(2, tableAndCaption);
        this.containsTable = true;
    }

    public void add(List list) {
        this.add(3, list);
        this.containsList = true;
    }

    public void layout(double d, StyleTable styleTable) throws Exception {
        Object object;
        Object object2;
        Object object3;
        if (this.body.size() == 0) {
            return;
        }
        if (this.containsTable || this.containsList) {
            int n = this.body.size();
            block11: for (int i = 0; i < n; ++i) {
                object3 = (Element)this.body.elementAt(i);
                switch (((Element)object3).type) {
                    case 1: {
                        object2 = (Table)((Element)object3).object;
                        ((Table)object2).layout(d, styleTable);
                        continue block11;
                    }
                    case 2: {
                        object = (TableAndCaption)((Element)object3).object;
                        ((TableAndCaption)object).layout(d, styleTable);
                        continue block11;
                    }
                    case 3: {
                        List list = (List)((Element)object3).object;
                        list.layout(d, styleTable);
                    }
                }
            }
        }
        Element element = (Element)this.body.firstElement();
        switch (element.type) {
            case 0: {
                Paragraph paragraph = (Paragraph)element.object;
                this.bodyStart = paragraph.style.marginLeft;
                break;
            }
            case 1: {
                object3 = (Table)element.object;
                this.bodyStart = ((Table)object3).marginLeft();
                break;
            }
            case 2: {
                object2 = (TableAndCaption)element.object;
                this.bodyStart = ((TableAndCaption)object2).table.marginLeft();
                break;
            }
            case 3: {
                object = (List)element.object;
                this.bodyStart = ((List)object).marginLeft();
            }
        }
        if (this.label != null) {
            double d2;
            this.labelStart = this.label.style.marginLeft;
            if (this.label.style.marginRight > 0.0) {
                d2 = d - this.label.style.marginRight;
                this.labelSeparation = this.bodyStart - d2;
            } else {
                d2 = this.bodyStart - this.labelSeparation;
            }
            this.labelWidth = d2 - this.labelStart;
        } else {
            this.labelSeparation = this.bodyStart;
        }
        this.referenceWidth = d;
    }

    public void setup(int n, ListStyle listStyle, StyleTable styleTable) throws Exception {
        int n2;
        int n3;
        Element element;
        Paragraph paragraph;
        if (this.body.size() == 0) {
            return;
        }
        Element element2 = (Element)this.body.firstElement();
        if (element2.type != 0) {
            paragraph = new Paragraph(new ParagraphStyle());
            paragraph.style.marginLeft = this.bodyStart;
            element = new Element(0, paragraph);
            this.body.insertElementAt(element, 0);
        } else {
            paragraph = (Paragraph)element2.object;
        }
        paragraph.style.marginTop = this.marginTop;
        switch (n) {
            case 0: {
                paragraph.style.marginLeft = this.labelStart;
                paragraph.style.listStyleName = listStyle.name;
                paragraph.listStyle = listStyle;
                n3 = this.body.size();
                block9: for (n2 = 1; n2 < n3; ++n2) {
                    element = (Element)this.body.elementAt(n2);
                    switch (element.type) {
                        case 1: 
                        case 2: {
                            n2 = n3;
                            continue block9;
                        }
                        case 3: {
                            List list = (List)element.object;
                            if (list.type() != 1) continue block9;
                            n2 = n3;
                            continue block9;
                        }
                        case 0: {
                            double d;
                            paragraph = (Paragraph)element.object;
                            paragraph.style.marginLeft = d = this.labelStart + (paragraph.style.marginLeft - this.bodyStart);
                            paragraph.style.listStyleName = listStyle.name;
                            paragraph.listStyle = listStyle;
                        }
                    }
                }
                break;
            }
            case 1: {
                if (this.label == null) break;
                if (this.label.requiresLayout()) {
                    this.label.layout(this.referenceWidth);
                }
                paragraph.prepend(this.label);
            }
        }
        n3 = this.body.size();
        for (n2 = 0; n2 < n3; ++n2) {
            element = (Element)this.body.elementAt(n2);
            if (element.type != 0) continue;
            paragraph = (Paragraph)element.object;
            if (paragraph.requiresLayout()) {
                paragraph.layout(this.referenceWidth);
            }
            paragraph.style = styleTable.add(paragraph.style);
        }
        this.listType = n;
    }

    public boolean print(PrintWriter printWriter, Encoder encoder) {
        boolean bl = false;
        if (this.listType == 0) {
            printWriter.println("<text:list-item>");
        }
        int n = this.body.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.body.elementAt(i);
            switch (element.type) {
                case 0: {
                    Paragraph paragraph = (Paragraph)element.object;
                    paragraph.print(printWriter, encoder);
                    continue block6;
                }
                case 1: {
                    if (this.listType == 0 && !bl) {
                        printWriter.println("</text:list-item>");
                        printWriter.println("</text:list>");
                        bl = true;
                    }
                    Table table = (Table)element.object;
                    table.print(printWriter, encoder);
                    continue block6;
                }
                case 2: {
                    if (this.listType == 0 && !bl) {
                        printWriter.println("</text:list-item>");
                        printWriter.println("</text:list>");
                        bl = true;
                    }
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    tableAndCaption.print(printWriter, encoder);
                    continue block6;
                }
                case 3: {
                    List list = (List)element.object;
                    if (list.type() == 1 && this.listType == 0 && !bl) {
                        printWriter.println("</text:list-item>");
                        printWriter.println("</text:list>");
                        bl = true;
                    }
                    list.print(printWriter, encoder);
                }
            }
        }
        if (this.listType == 0 && !bl) {
            printWriter.println("</text:list-item>");
        }
        return bl;
    }

    public ListStyle listStyle(LabelFormat labelFormat) {
        if (this.label == null || this.label.elementCount() != 1) {
            return null;
        }
        Object object = this.label.firstElement();
        Text text = null;
        if (object instanceof Text) {
            text = (Text)object;
        }
        if (text == null) {
            return null;
        }
        ListStyle listStyle = null;
        if (labelFormat != null) {
            if (labelFormat.type == 0) {
                return null;
            }
            switch (labelFormat.type) {
                case 2: {
                    listStyle = new ListStyle(0, labelFormat.start);
                    break;
                }
                case 3: {
                    listStyle = new ListStyle(1, labelFormat.start);
                    break;
                }
                case 4: {
                    listStyle = new ListStyle(2, labelFormat.start);
                    break;
                }
                case 5: {
                    listStyle = new ListStyle(3, labelFormat.start);
                    break;
                }
                case 6: {
                    listStyle = new ListStyle(4, labelFormat.start);
                    break;
                }
                default: {
                    listStyle = new ListStyle(labelFormat.suffix.charAt(0));
                }
            }
            if (labelFormat.type != 1) {
                if (labelFormat.prefix != null) {
                    listStyle.numberPrefix = labelFormat.prefix;
                }
                if (labelFormat.suffix != null) {
                    listStyle.numberSuffix = labelFormat.suffix;
                }
            }
        } else {
            String string = text.content.trim();
            switch (string.length()) {
                case 1: {
                    char c = string.charAt(0);
                    listStyle = ListItem.listStyle(c);
                    break;
                }
                case 2: {
                    char c;
                    char c2 = string.charAt(1);
                    if (c2 != '.' && c2 != ')' || (listStyle = ListItem.listStyle(c = string.charAt(0))) == null) break;
                    if (listStyle.labelType == 0) {
                        listStyle.numberSuffix = ListItem.toString(c2);
                        break;
                    }
                    listStyle = null;
                    break;
                }
                case 3: {
                    char c;
                    char c3 = string.charAt(0);
                    char c4 = string.charAt(2);
                    if (!(c3 == '(' && c4 == ')' || c3 == '<' && c4 == '>') && (c3 != '[' || c4 != ']') || (listStyle = ListItem.listStyle(c = string.charAt(1))) == null) break;
                    if (listStyle.labelType == 0) {
                        listStyle.numberPrefix = ListItem.toString(c3);
                        listStyle.numberSuffix = ListItem.toString(c4);
                        break;
                    }
                    listStyle = null;
                }
            }
        }
        if (listStyle != null) {
            listStyle.textStyle = text.style;
            listStyle.labelAlignment = this.label.style.textAlign == 5 ? this.label.style.textAlignLast : this.label.style.textAlign;
            listStyle.labelWidth = this.labelWidth + this.labelSeparation;
            listStyle.labelDistance = this.labelSeparation;
        }
        return listStyle;
    }

    private static ListStyle listStyle(char c) {
        int n;
        int n2 = 1;
        switch (c) {
            case '*': 
            case '+': 
            case '-': 
            case '\u2013': 
            case '\u2022': {
                return new ListStyle(c);
            }
            case '0': {
                n = 0;
                n2 = 0;
                break;
            }
            case '1': {
                n = 0;
                break;
            }
            case 'a': {
                n = 1;
                break;
            }
            case 'A': {
                n = 2;
                break;
            }
            case 'i': {
                n = 3;
                break;
            }
            case 'I': {
                n = 4;
                break;
            }
            default: {
                return null;
            }
        }
        return new ListStyle(n, n2);
    }

    private static String toString(char c) {
        return new String(new char[]{c});
    }

    public double minWidth() {
        double d = 0.0;
        int n = this.body.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.body.elementAt(i);
            switch (element.type) {
                case 0: {
                    Paragraph paragraph = (Paragraph)element.object;
                    double d2 = paragraph.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 1: {
                    Table table = (Table)element.object;
                    double d2 = table.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 2: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    double d2 = tableAndCaption.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 3: {
                    List list = (List)element.object;
                    double d2 = list.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                }
            }
        }
        return d;
    }

    public double maxWidth() {
        double d = 0.0;
        int n = this.body.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.body.elementAt(i);
            switch (element.type) {
                case 0: {
                    Paragraph paragraph = (Paragraph)element.object;
                    double d2 = paragraph.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 1: {
                    Table table = (Table)element.object;
                    double d2 = table.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 2: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    double d2 = tableAndCaption.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 3: {
                    List list = (List)element.object;
                    double d2 = list.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                }
            }
        }
        return d;
    }

    private class Element {
        static final int TYPE_PARAGRAPH = 0;
        static final int TYPE_TABLE = 1;
        static final int TYPE_TABLE_AND_CAPTION = 2;
        static final int TYPE_LIST = 3;
        int type;
        Object object;

        Element(int n, Object object) {
            this.type = n;
            this.object = object;
        }
    }
}

