/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.util.Encoder;
import java.text.NumberFormat;
import java.util.Locale;

public final class Odt {
    public static final String VERSION = "1.0";
    public static final String OFFICE_NAMESPACE_URI = "urn:oasis:names:tc:opendocument:xmlns:office:1.0";
    public static final String STYLE_NAMESPACE_URI = "urn:oasis:names:tc:opendocument:xmlns:style:1.0";
    public static final String FO_NAMESPACE_URI = "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0";
    public static final String SVG_NAMESPACE_URI = "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0";
    public static final String TEXT_NAMESPACE_URI = "urn:oasis:names:tc:opendocument:xmlns:text:1.0";
    public static final String DRAW_NAMESPACE_URI = "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0";
    public static final String TABLE_NAMESPACE_URI = "urn:oasis:names:tc:opendocument:xmlns:table:1.0";
    public static final String XLINK_NAMESPACE_URI = "http://www.w3.org/1999/xlink";
    public static final String MANIFEST_NAMESPACE_URI = "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0";
    private static NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);

    public static synchronized String format(double d, int n) {
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumFractionDigits(n);
        return numberFormat.format(d);
    }

    public static synchronized String format(long l, int n) {
        numberFormat.setMinimumIntegerDigits(n);
        return numberFormat.format(l);
    }

    public static String length(double d, int n) {
        return Odt.format(d, n) + "pt";
    }

    public static String relativeLength(double d, int n) {
        return Odt.format(d, n) + "*";
    }

    public static String percent(double d, int n) {
        return Odt.format(d, n) + "%";
    }

    public static int rgb(Color color) {
        if (color == null) {
            return -1;
        }
        return (color.red << 16) + (color.green << 8) + color.blue;
    }

    public static String color(int n) {
        if (n == -1) {
            return "#000000";
        }
        return "#" + Integer.toHexString(n + 0x1000000).substring(1);
    }

    public static String imageName(int n, String string) {
        return "Pictures/" + Odt.format(n, 4) + string;
    }

    public static String escape(String string, Encoder encoder) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        if (encoder != null) {
            block12: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block12;
                    }
                    case '>': {
                        if (i > 1 && string.charAt(i - 1) == ']' && string.charAt(i - 2) == ']') {
                            stringBuffer.append("&gt;");
                            continue block12;
                        }
                        stringBuffer.append(c);
                        continue block12;
                    }
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block12;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        continue block12;
                    }
                    default: {
                        if (!encoder.canEncode(c)) {
                            stringBuffer.append("&#" + Integer.toString(c) + ";");
                            continue block12;
                        }
                        stringBuffer.append(c);
                    }
                }
            }
        } else {
            block13: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block13;
                    }
                    case '>': {
                        if (i > 1 && string.charAt(i - 1) == ']' && string.charAt(i - 2) == ']') {
                            stringBuffer.append("&gt;");
                            continue block13;
                        }
                        stringBuffer.append(c);
                        continue block13;
                    }
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block13;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        continue block13;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    static {
        numberFormat.setGroupingUsed(false);
    }
}

