/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.Translator;
import com.xmlmind.fo.converter.odt.Bookmark;
import com.xmlmind.fo.converter.odt.BookmarkReference;
import com.xmlmind.fo.converter.odt.Caption;
import com.xmlmind.fo.converter.odt.FontFace;
import com.xmlmind.fo.converter.odt.FontTable;
import com.xmlmind.fo.converter.odt.Footer;
import com.xmlmind.fo.converter.odt.Footnote;
import com.xmlmind.fo.converter.odt.Header;
import com.xmlmind.fo.converter.odt.Image;
import com.xmlmind.fo.converter.odt.Leader;
import com.xmlmind.fo.converter.odt.Link;
import com.xmlmind.fo.converter.odt.List;
import com.xmlmind.fo.converter.odt.ListItem;
import com.xmlmind.fo.converter.odt.Manifest;
import com.xmlmind.fo.converter.odt.MasterPage;
import com.xmlmind.fo.converter.odt.OdtEntry;
import com.xmlmind.fo.converter.odt.OdtFile;
import com.xmlmind.fo.converter.odt.OdtGraphicEnv;
import com.xmlmind.fo.converter.odt.PageLayout;
import com.xmlmind.fo.converter.odt.Paragraph;
import com.xmlmind.fo.converter.odt.ParagraphStyle;
import com.xmlmind.fo.converter.odt.State;
import com.xmlmind.fo.converter.odt.StaticContent;
import com.xmlmind.fo.converter.odt.StyleTable;
import com.xmlmind.fo.converter.odt.Table;
import com.xmlmind.fo.converter.odt.TableAndCaption;
import com.xmlmind.fo.converter.odt.TableColumn;
import com.xmlmind.fo.converter.odt.Text;
import com.xmlmind.fo.converter.odt.TextStyle;
import com.xmlmind.fo.font.GenericFamilies;
import com.xmlmind.fo.graphic.Graphic;
import com.xmlmind.fo.graphic.GraphicEnv;
import com.xmlmind.fo.objects.Flow;
import com.xmlmind.fo.objects.PageMasterReference;
import com.xmlmind.fo.objects.PageSequence;
import com.xmlmind.fo.objects.PageSequenceMaster;
import com.xmlmind.fo.objects.SimplePageMaster;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import com.xmlmind.fo.util.EncoderFactory;
import com.xmlmind.fo.util.Encoding;
import com.xmlmind.fo.util.TempFile;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class OdtTranslator
extends Translator {
    private static final String DEFAULT_ENCODING = "UTF8";
    private FontTable fontTable;
    private StyleTable styleTable;
    private OdtEntry manifestFile;
    private OdtEntry stylesFile;
    private OdtEntry contentFile;
    private Vector fileEntries;
    private Vector tmpFiles;
    private boolean prescaleImages;
    private int imageResolution;
    private int imageRendererResolution;
    private boolean alwaysSaveAsPNG;
    private int imageId;
    private String encoding;
    private Encoder encoder;
    private PrintWriter contentFileWriter;
    private SimplePageMaster oddPageMaster;
    private SimplePageMaster evenPageMaster;
    private SimplePageMaster firstPageMaster;
    private PageLayout oddPageLayout;
    private PageLayout evenPageLayout;
    private PageLayout firstPageLayout;
    private MasterPage oddMasterPage;
    private MasterPage evenMasterPage;
    private MasterPage firstMasterPage;
    private String masterPageName;
    private boolean flowStart;
    private State state;
    private Paragraph paragraph;
    private Vector bookmarks;
    private StaticContent staticContent;

    public static String[] listEncodings() {
        int n;
        String[] stringArray = Encoding.list();
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            String string = Encoding.officialName(stringArray[n]);
            if (string == null || string.equals("ISO-2022-CN") || string.equals("x-JISAutoDetect")) continue;
            vector.addElement(string);
        }
        stringArray = new String[vector.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    public void abort() {
        try {
            this.clean();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String systemFont(int n) {
        return "10pt serif";
    }

    public double fontSize(int n, double d) {
        double d2 = 10.0;
        switch (n) {
            case 236: {
                d2 = 6.0;
                break;
            }
            case 243: {
                d2 = 8.0;
                break;
            }
            case 182: {
                d2 = 10.0;
                break;
            }
            case 118: {
                d2 = 12.0;
                break;
            }
            case 95: {
                d2 = 14.0;
                break;
            }
            case 239: {
                d2 = 16.0;
                break;
            }
            case 235: {
                d2 = 18.0;
                break;
            }
            case 96: {
                d2 = 2.0 * (double)Math.round(d / 2.0 + 1.0);
                break;
            }
            case 183: {
                d2 = 2.0 * (double)Math.round(d / 2.0 - 1.0);
                if (!(d2 < 2.0)) break;
                d2 = 2.0;
                break;
            }
        }
        return d2;
    }

    public double referenceWidth() {
        if (this.state != null) {
            return this.state.referenceWidth;
        }
        return 0.0;
    }

    public String unaliasFontFamily(String string) {
        return this.fontTable.unaliasFontFamily(string);
    }

    private void clean() throws Exception {
        if (this.contentFileWriter != null) {
            this.contentFileWriter.close();
            this.contentFileWriter = null;
        }
        this.deleteTmpFiles();
    }

    private void deleteTmpFiles() {
        if (this.tmpFiles != null) {
            int n = this.tmpFiles.size();
            for (int i = 0; i < n; ++i) {
                File file = (File)this.tmpFiles.elementAt(i);
                file.delete();
            }
            this.tmpFiles = null;
        }
    }

    protected void finalize() throws Throwable {
        this.clean();
    }

    public void startDocument() throws Exception {
        this.fontTable = new FontTable();
        GenericFamilies genericFamilies = this.genericFontFamilies("DejaVu Serif", "DejaVu Sans", "DejaVu Sans Mono");
        this.fontTable.add(new FontFace(genericFamilies.serif, "roman"));
        this.fontTable.aliasFontFamily("serif", genericFamilies.serif);
        this.fontTable.add(new FontFace(genericFamilies.sansSerif, "swiss"));
        this.fontTable.aliasFontFamily("sans-serif", genericFamilies.sansSerif);
        this.fontTable.add(new FontFace(genericFamilies.monospace, "modern"));
        this.fontTable.aliasFontFamily("monospace", genericFamilies.monospace);
        if (genericFamilies.fantasy != null) {
            this.fontTable.add(new FontFace(genericFamilies.fantasy, "decorative"));
            this.fontTable.aliasFontFamily("fantasy", genericFamilies.fantasy);
        }
        if (genericFamilies.cursive != null) {
            this.fontTable.add(new FontFace(genericFamilies.cursive, "script"));
            this.fontTable.aliasFontFamily("cursive", genericFamilies.cursive);
        }
        this.styleTable = new StyleTable(this.fontTable);
        this.manifestFile = new OdtEntry("META-INF/manifest.xml", "text/xml");
        this.stylesFile = new OdtEntry("styles.xml", "text/xml");
        this.contentFile = new OdtEntry("content.xml", "text/xml", new String[2]);
        this.fileEntries = new Vector();
        this.fileEntries.addElement(this.manifestFile);
        this.fileEntries.addElement(this.stylesFile);
        this.fileEntries.addElement(this.contentFile);
        this.fileEntries.addElement(new OdtEntry("Pictures/", ""));
        this.tmpFiles = new Vector();
        this.prescaleImages = this.prescaleImages();
        this.imageResolution = this.imageResolution();
        this.imageRendererResolution = this.imageRendererResolution();
        this.alwaysSaveAsPNG = this.alwaysSaveAsPNG();
        this.imageId = 1;
        this.encoding = this.properties.getProperty("outputEncoding");
        if (this.encoding == null) {
            this.encoding = DEFAULT_ENCODING;
        }
        if (Encoding.internalName(this.encoding) == null) {
            throw new Exception("unsupported encoding \"" + this.encoding + "\"");
        }
        this.encoding = Encoding.internalName(this.encoding);
        String string = Encoding.officialName(this.encoding);
        this.encoder = !string.startsWith("UTF") ? EncoderFactory.newEncoder(string) : null;
        File file = TempFile.create("xfc", null);
        this.tmpFiles.addElement(file);
        this.contentFile.paths[1] = file.getPath();
        FileOutputStream fileOutputStream = new FileOutputStream(this.contentFile.paths[1]);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fileOutputStream), this.encoding);
        this.contentFileWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
        this.contentFileWriter.println("<office:body>");
        this.contentFileWriter.println("<office:text>");
    }

    public void endDocument() throws Exception {
        this.contentFileWriter.println("</office:text>");
        this.contentFileWriter.println("</office:body>");
        this.contentFileWriter.println("</office:document-content>");
        this.contentFileWriter.flush();
        this.contentFileWriter.close();
        this.contentFileWriter = null;
        File file = TempFile.create("xfc", null);
        this.tmpFiles.addElement(file);
        this.contentFile.paths[0] = file.getPath();
        OutputStream outputStream = new FileOutputStream(this.contentFile.paths[0]);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), this.encoding);
        this.contentFileWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
        this.contentFileWriter.println("<?xml version=\"1.0\" encoding=\"" + Encoding.officialName(this.encoding) + "\"?>");
        this.contentFileWriter.print("<office:document-content");
        this.contentFileWriter.print(" xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\"");
        this.contentFileWriter.print(" xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\"");
        this.contentFileWriter.print(" xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\"");
        this.contentFileWriter.print(" xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\"");
        this.contentFileWriter.print(" xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\"");
        this.contentFileWriter.print(" xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\"");
        this.contentFileWriter.print(" xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\"");
        this.contentFileWriter.print(" xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
        this.contentFileWriter.print(" office:version=\"1.0\"");
        this.contentFileWriter.println(">");
        this.styleTable.print(this.contentFileWriter);
        this.contentFileWriter.flush();
        this.contentFileWriter.close();
        this.contentFileWriter = null;
        file = TempFile.create("xfc", null);
        this.tmpFiles.addElement(file);
        String string = file.getPath();
        this.stylesFile.setPath(string);
        this.styleTable.write(string, this.encoding);
        Manifest manifest = new Manifest();
        int n = this.fileEntries.size();
        for (int i = 1; i < n; ++i) {
            OdtEntry odtEntry = (OdtEntry)this.fileEntries.elementAt(i);
            manifest.add(odtEntry.name, odtEntry.type);
        }
        file = TempFile.create("xfc", null);
        this.tmpFiles.addElement(file);
        string = file.getPath();
        this.manifestFile.setPath(string);
        manifest.write(string, this.encoding);
        OdtFile odtFile = new OdtFile();
        int n2 = this.fileEntries.size();
        for (n = 0; n < n2; ++n) {
            OdtEntry odtEntry = (OdtEntry)this.fileEntries.elementAt(n);
            odtFile.add(odtEntry);
        }
        if (this.output != null) {
            outputStream = this.output.getByteStream();
            n = 0;
            if (outputStream == null) {
                String string2 = this.output.getFileName();
                if (string2 != null) {
                    outputStream = new FileOutputStream(string2);
                    n = 1;
                } else {
                    outputStream = System.out;
                }
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            odtFile.write(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
            if (n != 0) {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
        this.deleteTmpFiles();
    }

    public void characters(String string, Context context) throws Exception {
        if (this.state.skipContent) {
            return;
        }
        if (this.state.textStyle == null) {
            this.state.textStyle = this.styleTable.add(new TextStyle(context));
        }
        boolean bl = false;
        if (context.whiteSpaceTreatment() == 152) {
            bl = true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        if (this.paragraph == null) {
            this.startParagraph(context);
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("\n")) {
                this.paragraph.addBreak(this.state.textStyle);
                continue;
            }
            Text text = new Text(string2, this.state.textStyle, bl);
            this.paragraph.add(text);
        }
    }

    private void startParagraph(Context context) {
        this.paragraph = new Paragraph(new ParagraphStyle(context));
        if (this.bookmarks != null && this.state.context != 2) {
            this.paragraph.bookmarks = this.bookmarks;
            this.bookmarks = null;
        }
    }

    private void endParagraph() throws Exception {
        int n = this.state.context;
        double d = this.state.referenceWidth;
        if (this.paragraph.isEmpty()) {
            this.paragraph = null;
            return;
        }
        if (this.flowStart) {
            this.paragraph.style.masterPageName = this.masterPageName;
            this.flowStart = false;
        }
        switch (n) {
            case 4: {
                if (!this.paragraph.requiresLayout()) {
                    this.paragraph.style = this.styleTable.add(this.paragraph.style);
                }
                this.state.table.add(this.paragraph);
                break;
            }
            case 5: {
                if (this.paragraph.requiresLayout()) {
                    this.paragraph.layout(d);
                }
                this.paragraph.style = this.styleTable.add(this.paragraph.style);
                this.state.tableAndCaption.caption.add(this.paragraph);
                break;
            }
            case 2: {
                this.state.listItem.setLabel(this.paragraph);
                break;
            }
            case 3: {
                this.state.listItem.add(this.paragraph);
                break;
            }
            case 7: {
                if (this.paragraph.requiresLayout()) {
                    this.paragraph.layout(d);
                }
                this.paragraph.style = this.styleTable.add(this.paragraph.style);
                this.state.footnote.add(this.paragraph);
                break;
            }
            case 8: {
                if (this.paragraph.requiresLayout()) {
                    this.paragraph.layout(d);
                }
                this.paragraph.style = this.styleTable.add(this.paragraph.style);
                this.staticContent.add(this.paragraph);
                break;
            }
            default: {
                if (this.paragraph.requiresLayout()) {
                    this.paragraph.layout(d);
                }
                this.paragraph.style = this.styleTable.add(this.paragraph.style);
                this.paragraph.print(this.contentFileWriter, this.encoder);
            }
        }
        this.paragraph = null;
    }

    public void startRoot(Value[] valueArray, Context context) throws Exception {
    }

    public void endRoot(Context context) throws Exception {
    }

    public void startDeclarations(Value[] valueArray, Context context) throws Exception {
    }

    public void endDeclarations(Context context) throws Exception {
    }

    public void startColorProfile(Value[] valueArray, Context context) throws Exception {
    }

    public void endColorProfile(Context context) throws Exception {
    }

    public void startPageSequence(PageSequence pageSequence, Value[] valueArray, Context context) throws Exception {
        MasterPage masterPage;
        this.selectPageMasters(pageSequence);
        this.oddPageLayout = new PageLayout(this.oddPageMaster);
        this.styleTable.add(this.oddPageLayout);
        this.oddMasterPage = new MasterPage(this.oddPageLayout.name);
        this.styleTable.add(this.oddMasterPage);
        this.evenPageLayout = null;
        this.firstPageLayout = null;
        this.evenMasterPage = null;
        this.firstMasterPage = null;
        if (this.evenPageMaster != null) {
            this.evenPageLayout = new PageLayout(this.evenPageMaster);
            this.styleTable.add(this.evenPageLayout);
            this.evenMasterPage = new MasterPage(this.evenPageLayout.name);
            this.styleTable.add(this.evenMasterPage);
        }
        if (this.firstPageMaster != null) {
            this.firstPageLayout = new PageLayout(this.firstPageMaster);
            this.styleTable.add(this.firstPageLayout);
            this.firstMasterPage = new MasterPage(this.firstPageLayout.name);
            this.styleTable.add(this.firstMasterPage);
        }
        if (this.firstPageLayout != null) {
            this.firstPageLayout.setPageNumbering(pageSequence);
            this.oddPageLayout.firstPageNumber = 0;
            this.oddPageLayout.numberFormat = this.firstPageLayout.numberFormat;
        } else {
            this.oddPageLayout.setPageNumbering(pageSequence);
        }
        if (this.evenPageLayout != null) {
            this.evenPageLayout.firstPageNumber = 0;
            this.evenPageLayout.numberFormat = this.oddPageLayout.numberFormat;
        }
        if (this.firstMasterPage != null) {
            masterPage = this.evenMasterPage != null ? this.evenMasterPage : this.oddMasterPage;
            this.firstMasterPage.nextMasterPage = masterPage.name;
        }
        if (this.evenMasterPage != null) {
            this.oddMasterPage.nextMasterPage = this.evenMasterPage.name;
            this.evenMasterPage.nextMasterPage = this.oddMasterPage.name;
        }
        masterPage = this.firstMasterPage != null ? this.firstMasterPage : this.oddMasterPage;
        this.masterPageName = masterPage.name;
        this.flowStart = false;
        this.state = new State(31);
        this.state.referenceWidth = this.oddPageLayout.contentWidth();
        this.paragraph = null;
        this.bookmarks = null;
        if (valueArray[125] != null) {
            this.bookmarks = new Vector();
            this.bookmarks.addElement(new Bookmark(valueArray[125].id()));
        }
    }

    private void selectPageMasters(PageSequence pageSequence) {
        int n;
        this.oddPageMaster = null;
        this.evenPageMaster = null;
        this.firstPageMaster = null;
        if (pageSequence.pageMaster != null) {
            this.oddPageMaster = pageSequence.pageMaster;
            return;
        }
        PageSequenceMaster pageSequenceMaster = pageSequence.pageSequenceMaster;
        PageMasterReference pageMasterReference = pageSequenceMaster.subSequence(0);
        switch (pageMasterReference.type) {
            case 1: {
                this.firstPageMaster = pageMasterReference.pageMaster;
                break;
            }
            case 2: {
                if (pageMasterReference.maximumRepeats != 1) break;
                this.firstPageMaster = pageMasterReference.pageMaster;
                break;
            }
        }
        PageMasterReference pageMasterReference2 = null;
        int n2 = pageSequenceMaster.subSequences.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            pageMasterReference = pageSequenceMaster.subSequence(n);
            if (pageMasterReference.maximumRepeats < 0) {
                pageMasterReference2 = pageMasterReference;
                break;
            }
            if (pageMasterReference.maximumRepeats <= n3) continue;
            n3 = pageMasterReference.maximumRepeats;
            pageMasterReference2 = pageMasterReference;
        }
        if (pageMasterReference2.type == 3) {
            n2 = pageMasterReference2.alternatives.size();
            block12: for (n = 0; n < n2; ++n) {
                PageMasterReference pageMasterReference3 = pageMasterReference2.alternative(n);
                if (pageMasterReference3.blankOrNotBlank == 21) continue;
                switch (pageMasterReference3.pagePosition) {
                    case 97: {
                        continue block12;
                    }
                    case 66: {
                        if (this.firstPageMaster != null) continue block12;
                        this.firstPageMaster = pageMasterReference3.pageMaster;
                        continue block12;
                    }
                    default: {
                        switch (pageMasterReference3.oddOrEven) {
                            case 56: {
                                this.evenPageMaster = pageMasterReference3.pageMaster;
                                continue block12;
                            }
                        }
                        this.oddPageMaster = pageMasterReference3.pageMaster;
                    }
                }
            }
            if (this.oddPageMaster == null) {
                this.oddPageMaster = pageMasterReference2.alternative((int)0).pageMaster;
            }
        } else {
            this.oddPageMaster = pageMasterReference2.pageMaster;
        }
        if (this.firstPageMaster == this.oddPageMaster) {
            this.firstPageMaster = null;
        }
    }

    public void endPageSequence(Context context) throws Exception {
        this.state = null;
    }

    public void startLayoutMasterSet(Value[] valueArray, Context context) throws Exception {
    }

    public void endLayoutMasterSet(Context context) throws Exception {
    }

    public void startPageSequenceMaster(Value[] valueArray, Context context) throws Exception {
    }

    public void endPageSequenceMaster(Context context) throws Exception {
    }

    public void startSinglePageMasterReference(Value[] valueArray, Context context) throws Exception {
    }

    public void endSinglePageMasterReference(Context context) throws Exception {
    }

    public void startRepeatablePageMasterReference(Value[] valueArray, Context context) throws Exception {
    }

    public void endRepeatablePageMasterReference(Context context) throws Exception {
    }

    public void startRepeatablePageMasterAlternatives(Value[] valueArray, Context context) throws Exception {
    }

    public void endRepeatablePageMasterAlternatives(Context context) throws Exception {
    }

    public void startConditionalPageMasterReference(Value[] valueArray, Context context) throws Exception {
    }

    public void endConditionalPageMasterReference(Context context) throws Exception {
    }

    public void startSimplePageMaster(Value[] valueArray, Context context) throws Exception {
    }

    public void endSimplePageMaster(Context context) throws Exception {
    }

    public void startRegionBody(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionBody(Context context) throws Exception {
    }

    public void startRegionBefore(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionBefore(Context context) throws Exception {
    }

    public void startRegionAfter(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionAfter(Context context) throws Exception {
    }

    public void startRegionStart(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionStart(Context context) throws Exception {
    }

    public void startRegionEnd(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionEnd(Context context) throws Exception {
    }

    public void startFlow(Flow flow, Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(10);
        if (flow.region(this.oddPageMaster) != 0) {
            this.state.skipContent = true;
            return;
        }
        this.flowStart = true;
        if (valueArray[125] != null) {
            if (this.bookmarks == null) {
                this.bookmarks = new Vector();
            }
            this.bookmarks.addElement(new Bookmark(valueArray[125].id()));
        }
    }

    public void endFlow(Context context) throws Exception {
        if (!this.state.skipContent && this.bookmarks != null) {
            this.paragraph = new Paragraph();
            this.paragraph.bookmarks = this.bookmarks;
            this.paragraph.print(this.contentFileWriter, this.encoder);
            this.paragraph = null;
            this.bookmarks = null;
        }
        this.state = this.state.restore();
    }

    public void startStaticContent(Flow flow, Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(44);
        this.styleTable.select(1);
        this.staticContent = null;
        switch (flow.region(this.oddPageMaster)) {
            case 1: {
                this.staticContent = new StaticContent();
                this.oddMasterPage.header = new Header(this.staticContent);
                break;
            }
            case 2: {
                this.staticContent = new StaticContent();
                this.oddMasterPage.footer = new Footer(this.staticContent);
            }
        }
        if (this.evenPageMaster != null) {
            switch (flow.region(this.evenPageMaster)) {
                case 1: {
                    if (this.staticContent == null) {
                        this.staticContent = new StaticContent();
                    }
                    this.evenMasterPage.header = new Header(this.staticContent);
                    break;
                }
                case 2: {
                    if (this.staticContent == null) {
                        this.staticContent = new StaticContent();
                    }
                    this.evenMasterPage.footer = new Footer(this.staticContent);
                }
            }
        }
        if (this.firstPageMaster != null) {
            switch (flow.region(this.firstPageMaster)) {
                case 1: {
                    if (this.staticContent == null) {
                        this.staticContent = new StaticContent();
                    }
                    this.firstMasterPage.header = new Header(this.staticContent);
                    break;
                }
                case 2: {
                    if (this.staticContent == null) {
                        this.staticContent = new StaticContent();
                    }
                    this.firstMasterPage.footer = new Footer(this.staticContent);
                }
            }
        }
        if (this.staticContent == null) {
            this.state.skipContent = true;
        }
    }

    public void endStaticContent(Context context) throws Exception {
        this.styleTable.select(0);
        this.state = this.state.restore();
    }

    public void startTitle(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(54);
    }

    public void endTitle(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startBlock(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(2);
        if (!this.state.skipContent) {
            if (this.paragraph != null) {
                this.endParagraph();
            }
            if (valueArray[125] != null) {
                String string = valueArray[125].id();
                if (this.bookmarks == null) {
                    this.bookmarks = new Vector();
                }
                this.bookmarks.addElement(new Bookmark(string));
            }
        }
    }

    public void endBlock(Context context) throws Exception {
        if (!this.state.skipContent && this.paragraph != null) {
            this.endParagraph();
        }
        this.state = this.state.restore();
    }

    public void startBlockContainer(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(3);
    }

    public void endBlockContainer(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startBidiOverride(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(1);
    }

    public void endBidiOverride(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startCharacter(Value[] valueArray, Context context) throws Exception {
    }

    public void endCharacter(Context context) throws Exception {
    }

    public void startInitialPropertySet(Value[] valueArray, Context context) throws Exception {
    }

    public void endInitialPropertySet(Context context) throws Exception {
    }

    public void startExternalGraphic(Graphic graphic, GraphicEnv graphicEnv, Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(8);
        if (!this.state.skipContent) {
            if (valueArray[125] != null) {
                if (this.paragraph == null) {
                    this.startParagraph(context);
                }
                this.paragraph.add(new Bookmark(valueArray[125].id()));
            }
            OdtGraphicEnv odtGraphicEnv = new OdtGraphicEnv(graphicEnv, this.fileEntries, this.styleTable);
            Image image = new Image(this.imageId++, graphic, odtGraphicEnv, context, this.prescaleImages, this.imageResolution, this.imageRendererResolution, this.alwaysSaveAsPNG, this.encoder);
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(image);
        }
    }

    public void endExternalGraphic(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startInstreamForeignObject(Value[] valueArray, Context context) throws Exception {
    }

    public void endInstreamForeignObject(Graphic graphic, GraphicEnv graphicEnv, Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(16);
        if (!this.state.skipContent) {
            if (valueArray[125] != null) {
                if (this.paragraph == null) {
                    this.startParagraph(context);
                }
                this.paragraph.add(new Bookmark(valueArray[125].id()));
            }
            OdtGraphicEnv odtGraphicEnv = new OdtGraphicEnv(graphicEnv, this.fileEntries, this.styleTable);
            Image image = new Image(this.imageId++, graphic, odtGraphicEnv, context, this.prescaleImages, this.imageResolution, this.imageRendererResolution, this.alwaysSaveAsPNG, this.encoder);
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(image);
        }
        this.state = this.state.restore();
    }

    public void startInline(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(14);
        if (!this.state.skipContent && valueArray[125] != null) {
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(new Bookmark(valueArray[125].id()));
        }
    }

    public void endInline(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startInlineContainer(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(15);
    }

    public void endInlineContainer(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startLeader(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(18);
        if (!this.state.skipContent) {
            Leader leader = new Leader(context);
            leader.textStyle = this.styleTable.add(new TextStyle(context));
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(leader);
            this.state.skipContent = true;
        }
    }

    public void endLeader(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startPageNumber(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(29);
        if (!this.state.skipContent) {
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            TextStyle textStyle = this.styleTable.add(new TextStyle(context));
            this.paragraph.addPageNumber(textStyle);
        }
    }

    public void endPageNumber(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startPageNumberCitation(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(30);
        if (!this.state.skipContent && valueArray[226] != null) {
            String string = valueArray[226].idref();
            BookmarkReference bookmarkReference = BookmarkReference.page(string);
            bookmarkReference.style = this.styleTable.add(new TextStyle(context));
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(bookmarkReference);
        }
    }

    public void endPageNumberCitation(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startTableAndCaption(Value[] valueArray, Context context) throws Exception {
        if (this.paragraph != null) {
            this.endParagraph();
        }
        this.state = this.state.update(46);
        if (!this.state.skipContent) {
            this.state.tableAndCaption = new TableAndCaption(context);
            if (valueArray[125] != null) {
                String string = valueArray[125].id();
                if (this.bookmarks == null) {
                    this.bookmarks = new Vector();
                }
                this.bookmarks.addElement(new Bookmark(string));
            }
        } else {
            this.state.tableAndCaption = null;
        }
    }

    public void endTableAndCaption(Context context) throws Exception {
        TableAndCaption tableAndCaption = this.state.tableAndCaption;
        this.state = this.state.restore();
        if (tableAndCaption != null) {
            switch (this.state.context) {
                case 4: {
                    this.state.table.add(tableAndCaption);
                    break;
                }
                case 3: {
                    this.state.listItem.add(tableAndCaption);
                    break;
                }
                case 7: {
                    tableAndCaption.layout(this.state.referenceWidth, this.styleTable);
                    this.state.footnote.add(tableAndCaption);
                    break;
                }
                case 8: {
                    tableAndCaption.layout(this.state.referenceWidth, this.styleTable);
                    this.staticContent.add(tableAndCaption);
                    break;
                }
                default: {
                    tableAndCaption.layout(this.state.referenceWidth, this.styleTable);
                    tableAndCaption.print(this.contentFileWriter, this.encoder);
                }
            }
        }
    }

    public void startTable(Value[] valueArray, Context context) throws Exception {
        if (this.paragraph != null) {
            this.endParagraph();
        }
        this.state = this.state.update(45);
        if (!this.state.skipContent) {
            this.state.table = new Table(context);
            if (this.flowStart) {
                this.state.table.setMasterPageName(this.masterPageName);
                this.flowStart = false;
            }
            if (context.parent().fo == 46) {
                this.state.tableAndCaption.table = this.state.table;
            }
            if (valueArray[125] != null) {
                String string = valueArray[125].id();
                if (this.bookmarks == null) {
                    this.bookmarks = new Vector();
                }
                this.bookmarks.addElement(new Bookmark(string));
            }
        } else {
            this.state.table = null;
        }
    }

    public void endTable(Context context) throws Exception {
        Table table = null;
        if (context.parent().fo != 46) {
            table = this.state.table;
        }
        this.state = this.state.restore();
        if (table != null) {
            switch (this.state.context) {
                case 4: {
                    this.state.table.add(table);
                    break;
                }
                case 3: {
                    this.state.listItem.add(table);
                    break;
                }
                case 7: {
                    table.layout(this.state.referenceWidth, this.styleTable);
                    this.state.footnote.add(table);
                    break;
                }
                case 8: {
                    table.layout(this.state.referenceWidth, this.styleTable);
                    this.staticContent.add(table);
                    break;
                }
                default: {
                    table.layout(this.state.referenceWidth, this.styleTable);
                    table.print(this.contentFileWriter, this.encoder);
                }
            }
        }
    }

    public void startTableColumn(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(50);
        if (!this.state.skipContent) {
            this.state.table.add(new TableColumn(context));
        }
    }

    public void endTableColumn(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startTableCaption(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(48);
        if (!this.state.skipContent) {
            this.state.tableAndCaption.caption = new Caption(context);
            this.state.bookmarks = this.bookmarks;
            this.bookmarks = null;
        }
    }

    public void endTableCaption(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.bookmarks = this.state.bookmarks;
        }
        this.state = this.state.restore();
    }

    public void startTableHeader(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(52);
        if (!this.state.skipContent) {
            this.state.table.startHeader(context);
            if (valueArray[125] != null) {
                String string = valueArray[125].id();
                if (this.bookmarks == null) {
                    this.bookmarks = new Vector();
                }
                this.bookmarks.addElement(new Bookmark(string));
            }
        }
    }

    public void endTableHeader(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.state.table.endHeader();
        }
        this.state = this.state.restore();
    }

    public void startTableFooter(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(51);
        if (!this.state.skipContent) {
            this.state.table.startFooter(context);
            if (valueArray[125] != null) {
                String string = valueArray[125].id();
                if (this.bookmarks == null) {
                    this.bookmarks = new Vector();
                }
                this.bookmarks.addElement(new Bookmark(string));
            }
        }
    }

    public void endTableFooter(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.state.table.endFooter();
        }
        this.state = this.state.restore();
    }

    public void startTableBody(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(47);
        if (!this.state.skipContent) {
            this.state.table.startBody(context);
            if (valueArray[125] != null) {
                String string = valueArray[125].id();
                if (this.bookmarks == null) {
                    this.bookmarks = new Vector();
                }
                this.bookmarks.addElement(new Bookmark(string));
            }
        }
    }

    public void endTableBody(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.state.table.endBody();
        }
        this.state = this.state.restore();
    }

    public void startTableRow(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(53);
        if (!this.state.skipContent) {
            this.state.table.startRow(context);
            if (valueArray[125] != null) {
                String string = valueArray[125].id();
                if (this.bookmarks == null) {
                    this.bookmarks = new Vector();
                }
                this.bookmarks.addElement(new Bookmark(string));
            }
        }
    }

    public void endTableRow(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.state.table.endRow();
        }
        this.state = this.state.restore();
    }

    public void startTableCell(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(49);
        if (!this.state.skipContent) {
            this.state.referenceWidth = this.state.table.startCell(context);
            context.background = null;
            if (valueArray[125] != null) {
                String string = valueArray[125].id();
                if (this.bookmarks == null) {
                    this.bookmarks = new Vector();
                }
                this.bookmarks.addElement(new Bookmark(string));
            }
        }
    }

    public void endTableCell(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.state.table.endCell();
        }
        this.state = this.state.restore();
    }

    public void startListBlock(Value[] valueArray, Context context) throws Exception {
        if (this.paragraph != null) {
            this.endParagraph();
        }
        this.state = this.state.update(19);
        if (!this.state.skipContent) {
            this.state.list = new List(this.state.listLevel, context);
            if (valueArray[125] != null) {
                String string = valueArray[125].id();
                if (this.bookmarks == null) {
                    this.bookmarks = new Vector();
                }
                this.bookmarks.addElement(new Bookmark(string));
            }
        } else {
            this.state.list = null;
        }
    }

    public void endListBlock(Context context) throws Exception {
        List list = this.state.list;
        this.state = this.state.restore();
        if (list != null) {
            switch (this.state.context) {
                case 4: {
                    this.state.table.add(list);
                    break;
                }
                case 3: {
                    this.state.listItem.add(list);
                    break;
                }
                case 7: {
                    list.layout(1, this.state.referenceWidth, this.styleTable);
                    this.state.footnote.add(list);
                    break;
                }
                case 8: {
                    list.layout(this.state.referenceWidth, this.styleTable);
                    this.staticContent.add(list);
                    break;
                }
                default: {
                    list.layout(this.state.referenceWidth, this.styleTable);
                    list.print(this.contentFileWriter, this.encoder);
                }
            }
        }
    }

    public void startListItem(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(20);
        if (!this.state.skipContent) {
            this.state.listItem = new ListItem(context);
            if (valueArray[125] != null) {
                String string = valueArray[125].id();
                if (this.bookmarks == null) {
                    this.bookmarks = new Vector();
                }
                this.bookmarks.addElement(new Bookmark(string));
            }
        } else {
            this.state.listItem = null;
        }
    }

    public void endListItem(Context context) throws Exception {
        ListItem listItem = this.state.listItem;
        this.state = this.state.restore();
        if (listItem != null) {
            this.state.list.add(listItem);
        }
    }

    public void startListItemBody(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(21);
        if (!this.state.skipContent && valueArray[125] != null) {
            String string = valueArray[125].id();
            if (this.bookmarks == null) {
                this.bookmarks = new Vector();
            }
            this.bookmarks.addElement(new Bookmark(string));
        }
    }

    public void endListItemBody(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startListItemLabel(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(22);
        if (!this.state.skipContent && valueArray[125] != null) {
            String string = valueArray[125].id();
            if (this.bookmarks == null) {
                this.bookmarks = new Vector();
            }
            this.bookmarks.addElement(new Bookmark(string));
        }
    }

    public void endListItemLabel(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startBasicLink(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(0);
        if (!this.state.skipContent) {
            if (valueArray[125] != null) {
                if (this.paragraph == null) {
                    this.startParagraph(context);
                }
                this.paragraph.add(new Bookmark(valueArray[125].id()));
            }
            this.state.link = new Link(context);
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.start(this.state.link);
        }
    }

    public void endBasicLink(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.paragraph.end(this.state.link);
        }
        this.state = this.state.restore();
    }

    public void startMultiSwitch(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiSwitch(Context context) throws Exception {
    }

    public void startMultiCase(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiCase(Context context) throws Exception {
    }

    public void startMultiToggle(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiToggle(Context context) throws Exception {
    }

    public void startMultiProperties(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiProperties(Context context) throws Exception {
    }

    public void startMultiPropertySet(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiPropertySet(Context context) throws Exception {
    }

    public void startFloat(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(9);
    }

    public void endFloat(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startFootnote(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(11);
        if (!this.state.skipContent) {
            this.state.footnote = new Footnote();
            this.state.paragraph = this.paragraph;
            this.state.bookmarks = this.bookmarks;
            this.paragraph = new Paragraph();
            this.bookmarks = null;
        }
    }

    public void endFootnote(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.paragraph = this.state.paragraph;
            this.bookmarks = this.state.bookmarks;
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(this.state.footnote);
        }
        this.state = this.state.restore();
    }

    public void startFootnoteBody(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(12);
        if (!this.state.skipContent) {
            this.state.footnote.setLabel(this.paragraph);
            this.paragraph = null;
            this.state.referenceWidth = this.oddPageLayout.contentWidth();
        }
    }

    public void endFootnoteBody(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startWrapper(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(55);
        if (!this.state.skipContent && valueArray[125] != null) {
            Bookmark bookmark = new Bookmark(valueArray[125].id());
            if (this.paragraph == null || this.state.context == 2) {
                if (this.bookmarks == null) {
                    this.bookmarks = new Vector();
                }
                this.bookmarks.addElement(bookmark);
            } else {
                this.paragraph.add(bookmark);
            }
        }
    }

    public void endWrapper(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startMarker(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(23);
    }

    public void endMarker(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startRetrieveMarker(Value[] valueArray, Context context) throws Exception {
    }

    public void endRetrieveMarker(Context context) throws Exception {
    }
}

