/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.odt.Borders;
import com.xmlmind.fo.converter.odt.FooterStyle;
import com.xmlmind.fo.converter.odt.HeaderStyle;
import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.objects.PageSequence;
import com.xmlmind.fo.objects.Region;
import com.xmlmind.fo.objects.SimplePageMaster;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public final class PageLayout {
    public static final int ORIENTATION_PORTRAIT = 0;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public static final int COLOR_TRANSPARENT = -1;
    public static final int FORMAT_DECIMAL = 0;
    public static final int FORMAT_LOWERCASE_LETTER = 1;
    public static final int FORMAT_UPPERCASE_LETTER = 2;
    public static final int FORMAT_LOWERCASE_ROMAN = 3;
    public static final int FORMAT_UPPERCASE_ROMAN = 4;
    public static final int USAGE_ALL = 0;
    public static final int USAGE_LEFT = 1;
    public static final int USAGE_RIGHT = 2;
    public static final int USAGE_MIRRORED = 3;
    public static final int PAGE_NUMBER_CONTINUE = 0;
    public String name;
    public double width = 595.275590551181;
    public double height = 841.8897637795275;
    public int orientation;
    public double marginTop;
    public double marginBottom;
    public double marginLeft;
    public double marginRight;
    public double paddingTop;
    public double paddingBottom;
    public double paddingLeft;
    public double paddingRight;
    public int background = -1;
    public Borders borders;
    public int columnCount = 1;
    public double columnGap;
    public int firstPageNumber = 1;
    public int numberFormat;
    public int pageUsage;
    public HeaderStyle header;
    public FooterStyle footer;

    public PageLayout() {
    }

    public PageLayout(SimplePageMaster simplePageMaster) {
        this();
        this.initialize(simplePageMaster);
    }

    public void initialize(SimplePageMaster simplePageMaster) {
        Region region = simplePageMaster.regions[0];
        if (simplePageMaster.pageWidth.type == 4) {
            this.width = simplePageMaster.pageWidth.length();
        }
        if (simplePageMaster.pageHeight.type == 4) {
            this.height = simplePageMaster.pageHeight.length();
        }
        if (this.width > this.height) {
            this.orientation = 1;
        }
        this.marginTop = PageLayout.length(simplePageMaster.marginTop);
        this.marginBottom = PageLayout.length(simplePageMaster.marginBottom);
        this.marginLeft = PageLayout.length(simplePageMaster.marginLeft);
        this.marginRight = PageLayout.length(simplePageMaster.marginRight);
        if (simplePageMaster.regions[1] == null) {
            this.marginTop += PageLayout.length(region.marginTop);
        }
        if (simplePageMaster.regions[2] == null) {
            this.marginBottom += PageLayout.length(region.marginBottom);
        }
        this.marginLeft += PageLayout.length(region.marginLeft);
        this.marginRight += PageLayout.length(region.marginRight);
        this.paddingTop = PageLayout.length(region.paddingTop);
        this.paddingBottom = PageLayout.length(region.paddingBottom);
        this.paddingLeft = PageLayout.length(region.paddingLeft);
        this.paddingRight = PageLayout.length(region.paddingRight);
        Value value = region.properties[8];
        if (value.type == 24) {
            this.background = Odt.rgb(value.color());
        }
        this.borders = new Borders(region.properties);
        this.columnCount = region.columnCount;
        this.columnGap = PageLayout.length(region.columnGap);
        if (simplePageMaster.regions[1] != null) {
            this.header = new HeaderStyle(simplePageMaster.regions[1]);
            this.header.properties.marginBottom = this.paddingTop;
            this.paddingTop = PageLayout.length(region.marginTop) - this.header.properties.height;
            if (this.paddingTop < 0.0) {
                this.paddingTop = 0.0;
            }
        }
        if (simplePageMaster.regions[2] != null) {
            this.footer = new FooterStyle(simplePageMaster.regions[2]);
            this.footer.properties.marginTop = this.paddingBottom;
            this.paddingBottom = PageLayout.length(region.marginBottom) - this.footer.properties.height;
            if (this.paddingBottom < 0.0) {
                this.paddingBottom = 0.0;
            }
        }
    }

    private static double length(Value value) {
        double d = 0.0;
        if (value.type == 4) {
            d = value.length();
        }
        return d;
    }

    public void setPageNumbering(PageSequence pageSequence) {
        char c = '1';
        this.firstPageNumber = pageSequence.initialPageNumber > 0 ? pageSequence.initialPageNumber : 0;
        int n = pageSequence.format.length();
        for (int i = 0; i < n && !Character.isLetterOrDigit(c = (char)pageSequence.format.charAt(i)); ++i) {
        }
        switch (c) {
            default: {
                this.numberFormat = 0;
                break;
            }
            case 'a': {
                this.numberFormat = 1;
                break;
            }
            case 'A': {
                this.numberFormat = 2;
                break;
            }
            case 'i': {
                this.numberFormat = 3;
                break;
            }
            case 'I': {
                this.numberFormat = 4;
            }
        }
    }

    public double contentWidth() {
        double d = this.width;
        d -= this.marginLeft + this.marginRight;
        d -= this.paddingLeft + this.paddingRight;
        if (this.columnCount > 1) {
            d -= (double)(this.columnCount - 1) * this.columnGap;
            d /= (double)this.columnCount;
        }
        return d;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<style:page-layout style:name=\"" + this.name + "\"");
        printWriter.println(" style:page-usage=\"" + this.pageUsage() + "\">");
        printWriter.println("<style:page-layout-properties");
        printWriter.println(" fo:page-width=\"" + Odt.length(this.width, 1) + "\"");
        printWriter.println(" fo:page-height=\"" + Odt.length(this.height, 1) + "\"");
        printWriter.println(" style:print-orientation=\"" + this.orientation() + "\"");
        if (this.marginTop >= 0.0) {
            printWriter.println(" fo:margin-top=\"" + Odt.length(this.marginTop, 1) + "\"");
        }
        if (this.marginBottom >= 0.0) {
            printWriter.println(" fo:margin-bottom=\"" + Odt.length(this.marginBottom, 1) + "\"");
        }
        if (this.marginLeft >= 0.0) {
            printWriter.println(" fo:margin-left=\"" + Odt.length(this.marginLeft, 1) + "\"");
        }
        if (this.marginRight >= 0.0) {
            printWriter.println(" fo:margin-right=\"" + Odt.length(this.marginRight, 1) + "\"");
        }
        if (this.paddingTop > 0.0) {
            printWriter.println(" fo:padding-top=\"" + Odt.length(this.paddingTop, 1) + "\"");
        }
        if (this.paddingBottom > 0.0) {
            printWriter.println(" fo:padding-bottom=\"" + Odt.length(this.paddingBottom, 1) + "\"");
        }
        if (this.paddingLeft > 0.0) {
            printWriter.println(" fo:padding-left=\"" + Odt.length(this.paddingLeft, 1) + "\"");
        }
        if (this.paddingRight > 0.0) {
            printWriter.println(" fo:padding-right=\"" + Odt.length(this.paddingRight, 1) + "\"");
        }
        if (this.background != -1) {
            printWriter.println(" fo:background-color=\"" + Odt.color(this.background) + "\"");
        }
        if (this.borders != null) {
            this.borders.print(printWriter);
        }
        printWriter.println(" style:first-page-number=\"" + this.firstPageNumber() + "\"");
        printWriter.println(" style:num-format=\"" + this.numberFormat() + "\"");
        printWriter.println(">");
        if (this.columnCount > 1) {
            printWriter.println("<style:columns");
            printWriter.println(" fo:column-count=\"" + this.columnCount + "\"");
            printWriter.println(" fo:column-gap=\"" + Odt.length(this.columnGap, 1) + "\"");
            printWriter.println("/>");
        }
        printWriter.println("</style:page-layout-properties>");
        if (this.header != null) {
            this.header.print(printWriter);
        }
        if (this.footer != null) {
            this.footer.print(printWriter);
        }
        printWriter.println("</style:page-layout>");
    }

    private String orientation() {
        if (this.orientation == 1) {
            return "landscape";
        }
        return "portrait";
    }

    private String firstPageNumber() {
        if (this.firstPageNumber == 0) {
            return "continue";
        }
        return Integer.toString(this.firstPageNumber);
    }

    private char numberFormat() {
        char c = '1';
        switch (this.numberFormat) {
            case 1: {
                c = 'a';
                break;
            }
            case 2: {
                c = 'A';
                break;
            }
            case 3: {
                c = 'i';
                break;
            }
            case 4: {
                c = 'I';
            }
        }
        return c;
    }

    private String pageUsage() {
        String string = "all";
        switch (this.pageUsage) {
            case 1: {
                string = "left";
                break;
            }
            case 2: {
                string = "right";
                break;
            }
            case 3: {
                string = "mirrored";
            }
        }
        return string;
    }
}

