/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.odt.Bookmark;
import com.xmlmind.fo.converter.odt.BookmarkReference;
import com.xmlmind.fo.converter.odt.Footnote;
import com.xmlmind.fo.converter.odt.Image;
import com.xmlmind.fo.converter.odt.Leader;
import com.xmlmind.fo.converter.odt.Link;
import com.xmlmind.fo.converter.odt.ListStyle;
import com.xmlmind.fo.converter.odt.ParagraphStyle;
import com.xmlmind.fo.converter.odt.Span;
import com.xmlmind.fo.converter.odt.TabStop;
import com.xmlmind.fo.converter.odt.TabStops;
import com.xmlmind.fo.converter.odt.Text;
import com.xmlmind.fo.converter.odt.TextStyle;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public final class Paragraph {
    public ParagraphStyle style;
    public Vector bookmarks;
    public boolean hasImage;
    public ListStyle listStyle;
    private Vector elements = new Vector();

    public Paragraph() {
        this(null);
    }

    public Paragraph(ParagraphStyle paragraphStyle) {
        this.style = paragraphStyle;
    }

    private void add(int n, Object object) {
        this.elements.addElement(new Element(n, object));
    }

    public void add(Text text) {
        this.add(0, text);
    }

    public void add(Image image) {
        this.add(3, image);
        this.hasImage = true;
    }

    public void add(Footnote footnote) {
        this.add(4, footnote);
    }

    public void add(Leader leader) {
        if (this.style != null) {
            this.style.tabStops.add(leader.tabStop());
            this.addTab(leader.textStyle);
        }
    }

    public void add(Bookmark bookmark) {
        this.add(6, bookmark);
    }

    public void add(BookmarkReference bookmarkReference) {
        this.add(7, bookmarkReference);
    }

    public void addBreak(TextStyle textStyle) {
        this.add(1, textStyle);
    }

    public void addTab(TextStyle textStyle) {
        this.add(2, textStyle);
    }

    public void addPageNumber(TextStyle textStyle) {
        this.add(5, textStyle);
    }

    public void start(Link link) {
        this.add(8, link);
    }

    public void end(Link link) {
        this.add(9, link);
    }

    public void layout(double d) throws Exception {
        double d2 = d;
        if (this.style != null) {
            this.style.tabStops.layout(d, this.style.marginLeft, this.style.marginRight);
            d2 -= this.style.marginLeft + this.style.marginRight;
            if (this.listStyle != null) {
                d2 -= this.listStyle.labelWidth;
            }
        }
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)this.elements.elementAt(i);
            if (element.type != 3) continue;
            Image image = (Image)element.object;
            image.layout(d2);
        }
    }

    public void prepend(Paragraph paragraph) {
        this.style.textIndent = -(this.style.marginLeft - paragraph.style.marginLeft);
        TabStops tabStops = new TabStops();
        tabStops.add(new TabStop(this.style.marginLeft));
        tabStops.add(this.style.tabStops);
        this.style.tabStops = tabStops;
        int n = paragraph.elements.size();
        for (int i = 0; i < n; ++i) {
            this.elements.insertElementAt(paragraph.elements.elementAt(i), i);
        }
        Element element = new Element(2, this.textStyle());
        this.elements.insertElementAt(element, paragraph.elements.size());
    }

    public void print(PrintWriter printWriter, Encoder encoder) {
        Object object;
        int n;
        int n2;
        Object object2;
        int n3;
        Element[] elementArray = new Element[this.elements.size()];
        for (n3 = 0; n3 < elementArray.length; ++n3) {
            elementArray[n3] = (Element)this.elements.elementAt(n3);
        }
        for (n3 = 0; n3 < elementArray.length && elementArray[n3].type == 0; ++n3) {
            object2 = (Text)elementArray[n3].object;
            if (!((Text)object2).preserveSpace) {
                ((Text)object2).trimLeft();
            }
            if (((Text)object2).content.length() != 0) break;
        }
        for (n3 = elementArray.length - 1; n3 >= 0 && elementArray[n3].type == 0; --n3) {
            object2 = (Text)elementArray[n3].object;
            if (!((Text)object2).preserveSpace) {
                ((Text)object2).trimRight();
            }
            if (((Text)object2).content.length() != 0) break;
        }
        int n4 = n3 = this.style != null && this.style.name != null ? 1 : 0;
        if (n3 != 0 && this.style.outlineLevel >= 1 && this.style.outlineLevel <= 9) {
            object2 = "h";
            n2 = this.style.outlineLevel;
        } else {
            object2 = "p";
            n2 = -1;
        }
        printWriter.print("<text:" + (String)object2);
        if (n3 != 0) {
            if (n2 > 0) {
                printWriter.println(" text:outline-level=\"" + Integer.toString(n2) + "\"");
            }
            printWriter.println(" text:style-name=\"" + this.style.name + "\"");
        } else {
            printWriter.println();
        }
        printWriter.print(">");
        if (this.bookmarks != null) {
            int n5 = this.bookmarks.size();
            for (n = 0; n < n5; ++n) {
                object = (Bookmark)this.bookmarks.elementAt(n);
                ((Bookmark)object).print(printWriter, encoder);
            }
        }
        block16: for (n = 0; n < elementArray.length; ++n) {
            Element element = elementArray[n];
            switch (element.type) {
                case 0: {
                    object = (Text)element.object;
                    if (((Text)object).content.length() == 0) continue block16;
                    ((Text)object).print(printWriter, encoder);
                    continue block16;
                }
                case 1: {
                    Span.start(printWriter, (TextStyle)element.object);
                    printWriter.print("<text:line-break/>");
                    Span.end(printWriter);
                    continue block16;
                }
                case 2: {
                    Span.start(printWriter, (TextStyle)element.object);
                    printWriter.print("<text:tab/>");
                    Span.end(printWriter);
                    continue block16;
                }
                case 3: {
                    Image image = (Image)element.object;
                    image.print(printWriter);
                    continue block16;
                }
                case 4: {
                    Footnote footnote = (Footnote)element.object;
                    footnote.print(printWriter, encoder);
                    continue block16;
                }
                case 5: {
                    Span.start(printWriter, (TextStyle)element.object);
                    printWriter.print("<text:page-number/>");
                    Span.end(printWriter);
                    continue block16;
                }
                case 6: {
                    Bookmark bookmark = (Bookmark)element.object;
                    bookmark.print(printWriter, encoder);
                    continue block16;
                }
                case 7: {
                    BookmarkReference bookmarkReference = (BookmarkReference)element.object;
                    bookmarkReference.print(printWriter, encoder);
                    continue block16;
                }
                case 8: {
                    Link link = (Link)element.object;
                    link.start(printWriter, encoder);
                    continue block16;
                }
                case 9: {
                    Link link = (Link)element.object;
                    link.end(printWriter);
                }
            }
        }
        printWriter.println("</text:" + (String)object2 + ">");
    }

    public boolean requiresLayout() {
        return this.hasImage || this.hasTabs();
    }

    public boolean hasTabs() {
        return this.style != null && this.style.tabStops.count() > 0;
    }

    public boolean isEmpty() {
        if (this.bookmarks != null && this.bookmarks.size() > 0) {
            return false;
        }
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)this.elements.elementAt(i);
            if (element.type != 0) {
                return false;
            }
            Text text = (Text)element.object;
            if (text.content.length() == 0 || text.isSpace() && !text.preserveSpace) continue;
            return false;
        }
        return true;
    }

    public int elementCount() {
        return this.elements.size();
    }

    public Object firstElement() {
        if (this.elements.size() > 0) {
            Element element = (Element)this.elements.firstElement();
            return element.object;
        }
        return null;
    }

    public Text text() {
        StringBuffer stringBuffer = new StringBuffer();
        TextStyle textStyle = null;
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)this.elements.elementAt(i);
            if (element.type != 0) continue;
            Text text = (Text)element.object;
            stringBuffer.append(text.content);
            if (textStyle != null) continue;
            textStyle = text.style;
        }
        return new Text(stringBuffer.toString(), textStyle);
    }

    public TextStyle textStyle() {
        TextStyle textStyle = null;
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)this.elements.elementAt(i);
            if (element.type != 0) continue;
            Text text = (Text)element.object;
            if (text.style == null) continue;
            textStyle = text.style;
            break;
        }
        return textStyle;
    }

    public double minWidth() {
        double d = 0.0;
        int n = this.elements.size();
        block4: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.elements.elementAt(i);
            switch (element.type) {
                case 0: {
                    Text text = (Text)element.object;
                    double d2 = text.wordWidth();
                    if (!(d2 > d)) continue block4;
                    d = d2;
                    continue block4;
                }
                case 3: {
                    Image image = (Image)element.object;
                    double d2 = image.width();
                    if (!(d2 > d)) continue block4;
                    d = d2;
                }
            }
        }
        if (this.style != null) {
            d += this.style.marginLeft + this.style.marginRight;
        }
        return d;
    }

    public double maxWidth() {
        double d = 0.0;
        double d2 = 0.0;
        int n = this.elements.size();
        block5: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.elements.elementAt(i);
            switch (element.type) {
                case 0: {
                    Text text = (Text)element.object;
                    d += text.textWidth();
                    continue block5;
                }
                case 3: {
                    Image image = (Image)element.object;
                    d += image.width();
                    continue block5;
                }
                case 1: {
                    if (d > d2) {
                        d2 = d;
                    }
                    d = 0.0;
                }
            }
        }
        if (d > d2) {
            d2 = d;
        }
        if (this.style != null) {
            d2 += this.style.marginLeft + this.style.marginRight;
        }
        return d2;
    }

    private class Element {
        static final int TYPE_TEXT = 0;
        static final int TYPE_BREAK = 1;
        static final int TYPE_TAB = 2;
        static final int TYPE_IMAGE = 3;
        static final int TYPE_FOOTNOTE = 4;
        static final int TYPE_PAGE_NUMBER = 5;
        static final int TYPE_BOOKMARK = 6;
        static final int TYPE_BOOKMARK_REFERENCE = 7;
        static final int TYPE_LINK_START = 8;
        static final int TYPE_LINK_END = 9;
        int type;
        Object object;

        Element(int n, Object object) {
            this.type = n;
            this.object = object;
        }
    }
}

