/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.odt.Border;
import com.xmlmind.fo.converter.odt.Borders;
import com.xmlmind.fo.converter.odt.List;
import com.xmlmind.fo.converter.odt.Paragraph;
import com.xmlmind.fo.converter.odt.StyleTable;
import com.xmlmind.fo.converter.odt.TableAndCaption;
import com.xmlmind.fo.converter.odt.TableCell;
import com.xmlmind.fo.converter.odt.TableColumn;
import com.xmlmind.fo.converter.odt.TableColumnStyle;
import com.xmlmind.fo.converter.odt.TableGroup;
import com.xmlmind.fo.converter.odt.TableRow;
import com.xmlmind.fo.converter.odt.TableStyle;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;

public class Table {
    private int layout;
    private Borders borders;
    private TableStyle style;
    private int numColumns;
    private Vector columnList = new Vector();
    private Hashtable columnHash = new Hashtable();
    private TableColumn[] columns;
    private TableGroup header;
    private TableGroup footer;
    private Vector bodies = new Vector();
    private TableGroup[] groups;
    private TableGroup group;
    private TableRow row;
    private TableCell cell;
    private double tableWidth;
    private double maxTableWidth;
    private double[] columnWidths;
    private TableColumnStyle[] columnStyles;

    public Table(Context context) {
        this.initialize(context);
    }

    private void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        this.layout = valueArray[283].keyword();
        this.borders = new Borders(valueArray);
        this.style = new TableStyle(context);
    }

    public void setMasterPageName(String string) {
        this.style.masterPageName = string;
    }

    public void add(TableColumn tableColumn) {
        int n;
        if (tableColumn.repeat > 1) {
            n = tableColumn.number;
            for (int i = 0; i < tableColumn.repeat; ++i) {
                TableColumn tableColumn2 = tableColumn.copy();
                tableColumn2.number = n;
                tableColumn2.repeat = 1;
                this.columnList.addElement(tableColumn2);
                this.columnHash.put(new Integer(tableColumn2.number), tableColumn2);
                n += tableColumn.span;
            }
        } else {
            this.columnList.addElement(tableColumn);
            this.columnHash.put(new Integer(tableColumn.number), tableColumn);
        }
        n = tableColumn.last();
        if (n > this.numColumns) {
            this.numColumns = n;
        }
    }

    public void startHeader(Context context) {
        this.startGroup(0, context);
        this.header = this.group;
    }

    public void endHeader() {
        this.endGroup();
    }

    public void startFooter(Context context) {
        this.startGroup(2, context);
        this.footer = this.group;
    }

    public void endFooter() {
        this.endGroup();
    }

    public void startBody(Context context) {
        this.startGroup(1, context);
        this.bodies.addElement(this.group);
    }

    public void endBody() {
        this.endGroup();
    }

    private void startGroup(int n, Context context) {
        this.group = new TableGroup(n, context);
        this.row = null;
    }

    private void endGroup() {
        this.endRow();
        this.group = null;
    }

    public void startRow(Context context) {
        this.row = new TableRow(context);
        if (this.group != null) {
            this.group.add(this.row);
        }
    }

    public void endRow() {
        this.row = null;
    }

    public double startCell(Context context) {
        double d = 0.0;
        this.cell = new TableCell(context);
        int n = this.cell.colNumber + this.cell.colSpan - 1;
        if (n > this.numColumns) {
            this.numColumns = n;
        }
        if (this.cell.startsRow) {
            this.endRow();
        }
        if (this.row == null) {
            this.row = new TableRow();
            this.group.add(this.row);
        }
        this.row.add(this.cell);
        if (this.cell.width > 0.0 && !this.cell.relativeWidth) {
            d = this.cell.width;
        } else {
            TableColumn tableColumn = (TableColumn)this.columnHash.get(new Integer(this.cell.colNumber));
            if (tableColumn != null && tableColumn.width > 0.0 && tableColumn.widthType == 0) {
                d = tableColumn.width;
            }
        }
        if (d > 0.0) {
            d -= this.cell.style.paddingLeft + this.cell.style.paddingRight;
        }
        return d;
    }

    public void endCell() {
        if (this.cell.endsRow) {
            this.endRow();
        }
        this.cell = null;
    }

    public void add(Paragraph paragraph) {
        if (this.cell != null) {
            this.cell.add(paragraph);
            if (paragraph.requiresLayout()) {
                this.cell.requiresLayout = true;
                this.row.requiresLayout = true;
            }
        }
    }

    public void add(Table table) {
        if (this.cell != null) {
            this.cell.add(table);
            this.cell.requiresLayout = true;
            this.row.requiresLayout = true;
        }
    }

    public void add(TableAndCaption tableAndCaption) {
        if (this.cell != null) {
            this.cell.add(tableAndCaption);
            this.cell.requiresLayout = true;
            this.row.requiresLayout = true;
        }
    }

    public void add(List list) {
        if (this.cell != null) {
            this.cell.add(list);
            this.cell.requiresLayout = true;
            this.row.requiresLayout = true;
        }
    }

    public void layout(double d, StyleTable styleTable) throws Exception {
        Object object;
        int n;
        int n2;
        int n3;
        double d2;
        int n4;
        if (this.columns == null) {
            this.normalize();
        }
        this.maxTableWidth = d - (this.style.marginLeft + this.style.marginRight);
        if (this.style.relativeWidth) {
            double d3 = this.style.width;
            this.style.width = this.maxTableWidth * d3 / 100.0;
            this.style.relativeWidth = false;
        }
        this.tableWidth = this.style.width > 0.0 ? this.style.width : this.maxTableWidth;
        for (n4 = 0; n4 < this.numColumns; ++n4) {
            TableColumn tableColumn = this.columns[n4];
            if (tableColumn == null || tableColumn.widthType != 1) continue;
            d2 = tableColumn.width;
            tableColumn.width = this.tableWidth * d2 / 100.0;
            tableColumn.widthType = 0;
        }
        for (n3 = 0; n3 < this.groups.length; ++n3) {
            TableGroup tableGroup = this.groups[n3];
            for (n2 = 0; n2 < tableGroup.rows.length; ++n2) {
                TableRow tableRow = tableGroup.rows[n2];
                for (n = 0; n < tableRow.cells.length; ++n) {
                    object = tableRow.cells[n];
                    if (!((TableCell)object).relativeWidth) continue;
                    double d4 = ((TableCell)object).width;
                    ((TableCell)object).width = this.tableWidth * d4 / 100.0;
                    ((TableCell)object).relativeWidth = false;
                }
            }
        }
        if (this.layout == 69) {
            for (n4 = 0; n4 < this.columns.length; ++n4) {
                if (this.columns[n4] != null && this.columns[n4].width != 0.0) continue;
                this.layout = 10;
                break;
            }
        } else {
            boolean bl = true;
            for (n4 = 0; n4 < this.columns.length; ++n4) {
                if (this.columns[n4] != null && this.columns[n4].width != 0.0) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.layout = 69;
            }
        }
        this.columnWidths = this.layout == 69 ? this.fixedLayout() : this.automaticLayout();
        this.tableWidth = 0.0;
        for (n4 = 0; n4 < this.numColumns; ++n4) {
            this.tableWidth += this.columnWidths[n4];
        }
        this.style.width = this.tableWidth;
        if (Math.abs(this.maxTableWidth - this.tableWidth) < 1.0E-6) {
            this.style.alignment = 3;
        }
        if (this.style.alignment == 1 && this.style.marginRight != 0.0) {
            this.style.marginLeft += this.maxTableWidth - this.tableWidth;
            this.style.alignment = 3;
        }
        for (n3 = 0; n3 < this.groups.length; ++n3) {
            TableGroup tableGroup = this.groups[n3];
            for (n2 = 0; n2 < tableGroup.rows.length; ++n2) {
                TableRow tableRow = tableGroup.rows[n2];
                if (!tableRow.requiresLayout) continue;
                for (n = 0; n < tableRow.cells.length; ++n) {
                    TableCell tableCell = tableRow.cells[n];
                    if (!tableCell.requiresLayout) continue;
                    if (tableCell.colSpan > 1) {
                        d2 = 0.0;
                        for (n4 = 0; n4 < tableCell.colSpan; ++n4) {
                            d2 += this.columnWidths[n + n4];
                        }
                    } else {
                        d2 = this.columnWidths[n];
                    }
                    if (this.style.borderModel == 0) {
                        d2 -= this.leftBorderWidth(tableRow, tableCell);
                        d2 -= this.rightBorderWidth(tableRow, tableCell);
                    } else {
                        Borders borders = tableCell.style.borders;
                        if (borders.left.materialized()) {
                            d2 -= borders.left.width;
                        }
                        if (borders.right.materialized()) {
                            d2 -= borders.right.width;
                        }
                    }
                    tableCell.layout(d2, styleTable);
                }
            }
        }
        for (n3 = 0; n3 < this.groups.length; ++n3) {
            TableGroup tableGroup = this.groups[n3];
            for (n2 = 0; n2 < tableGroup.rows.length; ++n2) {
                TableRow tableRow = tableGroup.rows[n2];
                tableRow.style = styleTable.add(tableRow.style);
                for (n = 0; n < tableRow.cells.length; ++n) {
                    TableColumn tableColumn;
                    object = tableRow.cells[n];
                    if (((TableCell)object).isCovered || ((TableCell)object).hasBackground() || tableRow.hasBackground() || (tableColumn = this.columns[n]) == null || tableColumn.background == null || tableColumn.number != ((TableCell)object).colNumber || tableColumn.span != ((TableCell)object).colSpan) continue;
                    ((TableCell)object).setBackground(tableColumn.background);
                }
            }
        }
        this.style = styleTable.add(this.style);
        this.columnStyles = new TableColumnStyle[this.numColumns];
        boolean bl = this.layout == 10;
        for (n4 = 0; n4 < this.numColumns; ++n4) {
            this.columnStyles[n4] = new TableColumnStyle(this.columnWidths[n4]);
            this.columnStyles[n4].optimizeWidth = bl;
            this.columnStyles[n4] = styleTable.add(this.columnStyles[n4]);
        }
        for (n3 = 0; n3 < this.groups.length; ++n3) {
            TableGroup tableGroup = this.groups[n3];
            for (n2 = 0; n2 < tableGroup.rows.length; ++n2) {
                object = tableGroup.rows[n2];
                ((TableRow)object).style = styleTable.add(((TableRow)object).style);
                for (n = 0; n < ((TableRow)object).cells.length; ++n) {
                    TableCell tableCell = ((TableRow)object).cells[n];
                    tableCell.style = styleTable.add(tableCell.style);
                }
            }
        }
    }

    private void normalize() {
        int n;
        int n2;
        this.columns = new TableColumn[this.numColumns];
        int n3 = this.columnList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            TableColumn tableColumn = (TableColumn)this.columnList.elementAt(n2);
            for (n = 0; n < tableColumn.span; ++n) {
                this.columns[tableColumn.number + n - 1] = tableColumn;
            }
        }
        int n4 = this.bodies.size();
        if (this.header != null) {
            ++n4;
        }
        if (this.footer != null) {
            ++n4;
        }
        this.groups = new TableGroup[n4];
        if (this.header != null) {
            this.groups[0] = this.header;
        }
        n2 = 0;
        n = this.header == null ? 0 : 1;
        n3 = this.bodies.size();
        while (n2 < n3) {
            this.groups[n] = (TableGroup)this.bodies.elementAt(n2);
            ++n2;
            ++n;
        }
        if (this.footer != null) {
            this.groups[n4 - 1] = this.footer;
        }
        for (n2 = 0; n2 < this.groups.length; ++n2) {
            this.groups[n2].normalize(this.numColumns);
        }
        if (this.style.borderModel == 0) {
            this.setBorders();
        }
    }

    public void setBorders() {
        Vector<Border> vector = new Vector<Border>();
        Border border = null;
        int n = this.groups.length;
        for (int i = 0; i < n; ++i) {
            TableGroup tableGroup = this.groups[i];
            int n2 = tableGroup.rows.length;
            for (int j = 0; j < n2; ++j) {
                TableRow tableRow = tableGroup.rows[j];
                int n3 = tableRow.cells.length;
                for (int k = 0; k < n3; ++k) {
                    Border border2;
                    int n4;
                    int n5;
                    TableCell tableCell = tableRow.cells[k];
                    if (tableCell.isCovered) continue;
                    if (tableCell.style.borders.top.style != 75) {
                        vector.setSize(0);
                        border = null;
                        vector.addElement(tableRow.borders.top);
                        if (j == 0) {
                            vector.addElement(tableGroup.borders.top);
                            if (i == 0) {
                                vector.addElement(this.borders.top);
                            }
                        }
                        n5 = vector.size();
                        for (n4 = 0; n4 < n5; ++n4) {
                            Border border3 = (Border)vector.elementAt(n4);
                            if (border3.style == 125) continue;
                            border = border3;
                            if (border3.style == 75) break;
                        }
                        if (border != null) {
                            tableCell.style.borders.top = border;
                        }
                    }
                    if (tableCell.style.borders.bottom.style != 75) {
                        vector.setSize(0);
                        border = null;
                        n4 = j + tableCell.rowSpan - 1;
                        vector.addElement(tableGroup.rows[n4].borders.bottom);
                        if (n4 == n2 - 1) {
                            vector.addElement(tableGroup.borders.bottom);
                            if (i == n - 1) {
                                vector.addElement(this.borders.bottom);
                            }
                        }
                        int n6 = vector.size();
                        for (n5 = 0; n5 < n6; ++n5) {
                            border2 = (Border)vector.elementAt(n5);
                            if (border2.style == 125) continue;
                            border = border2;
                            if (border2.style == 75) break;
                        }
                        if (border != null) {
                            tableCell.style.borders.bottom = border;
                        }
                    }
                    if (tableCell.style.borders.left.style != 75) {
                        vector.setSize(0);
                        border = null;
                        TableColumn tableColumn = this.columns[k];
                        if (tableColumn != null && tableColumn.number == k + 1) {
                            vector.addElement(tableColumn.borders.left);
                        }
                        if (k == 0) {
                            vector.addElement(this.borders.left);
                        }
                        int n7 = vector.size();
                        for (n5 = 0; n5 < n7; ++n5) {
                            border2 = (Border)vector.elementAt(n5);
                            if (border2.style == 125) continue;
                            border = border2;
                            if (border2.style == 75) break;
                        }
                        if (border != null) {
                            tableCell.style.borders.left = border;
                        }
                    }
                    if (tableCell.style.borders.right.style == 75) continue;
                    vector.setSize(0);
                    border = null;
                    int n8 = k + tableCell.colSpan - 1;
                    TableColumn tableColumn = this.columns[n8];
                    if (tableColumn != null && tableColumn.last() == n8 + 1) {
                        vector.addElement(tableColumn.borders.right);
                    }
                    if (n8 == n3 - 1) {
                        vector.addElement(this.borders.right);
                    }
                    int n9 = vector.size();
                    for (int i2 = 0; i2 < n9; ++i2) {
                        Border border4 = (Border)vector.elementAt(i2);
                        if (border4.style == 125) continue;
                        border = border4;
                        if (border4.style == 75) break;
                    }
                    if (border == null) continue;
                    tableCell.style.borders.right = border;
                }
            }
        }
    }

    private double[] fixedLayout() {
        int n;
        double d = this.tableWidth;
        double d2 = 0.0;
        double[] dArray = new double[this.numColumns];
        for (n = 0; n < this.numColumns; ++n) {
            TableColumn tableColumn = this.columns[n];
            if (tableColumn == null) continue;
            if (tableColumn.widthType == 2) {
                d2 += tableColumn.width;
                continue;
            }
            dArray[n] = tableColumn.width;
            d -= tableColumn.width;
        }
        if (d2 > 0.0) {
            for (n = 0; n < this.numColumns; ++n) {
                if (dArray[n] != 0.0) continue;
                dArray[n] = d * this.columns[n].width / d2;
            }
        }
        return dArray;
    }

    private double[] automaticLayout() {
        double[] dArray;
        double d;
        TableCell tableCell;
        int n;
        TableRow tableRow;
        int n2;
        int n3;
        Object object;
        int n4;
        double[] dArray2 = new double[this.numColumns];
        double[] dArray3 = new double[this.numColumns];
        for (n4 = 0; n4 < this.numColumns; ++n4) {
            object = this.columns[n4];
            if (object == null || !(((TableColumn)object).width > 0.0)) continue;
            dArray2[n4] = ((TableColumn)object).width;
            dArray3[n4] = ((TableColumn)object).width;
        }
        for (n3 = 0; n3 < this.groups.length; ++n3) {
            object = this.groups[n3];
            for (n2 = 0; n2 < ((TableGroup)object).rows.length; ++n2) {
                tableRow = ((TableGroup)object).rows[n2];
                for (n = 0; n < tableRow.cells.length; ++n) {
                    tableCell = tableRow.cells[n];
                    if (tableCell.isCovered || tableCell.colSpan > 1) continue;
                    double d2 = tableCell.minWidth();
                    double d3 = tableCell.maxWidth();
                    double d4 = 0.0;
                    if (this.style.borderModel == 0) {
                        d4 += this.leftBorderWidth(tableRow, tableCell);
                        d4 += this.rightBorderWidth(tableRow, tableCell);
                    } else {
                        Borders borders = tableCell.style.borders;
                        if (borders.left.materialized()) {
                            d4 += borders.left.width;
                        }
                        if (borders.right.materialized()) {
                            d4 += borders.right.width;
                        }
                    }
                    d2 += d4;
                    d3 += d4;
                    if (d2 > dArray2[n]) {
                        dArray2[n] = d2;
                    }
                    if (!(d3 > dArray3[n])) continue;
                    dArray3[n] = d3;
                }
            }
        }
        for (n3 = 0; n3 < this.groups.length; ++n3) {
            object = this.groups[n3];
            for (n2 = 0; n2 < ((TableGroup)object).rows.length; ++n2) {
                tableRow = ((TableGroup)object).rows[n2];
                for (n = 0; n < tableRow.cells.length; ++n) {
                    tableCell = tableRow.cells[n];
                    if (tableCell.isCovered || tableCell.colSpan == 1) continue;
                    int n5 = tableCell.colSpan;
                    d = tableCell.minWidth();
                    double d5 = tableCell.maxWidth();
                    double d6 = 0.0;
                    if (this.style.borderModel == 0) {
                        d6 += this.leftBorderWidth(tableRow, tableCell);
                        d6 += this.rightBorderWidth(tableRow, tableCell);
                    } else {
                        Borders borders = tableCell.style.borders;
                        if (borders.left.materialized()) {
                            d6 += borders.left.width;
                        }
                        if (borders.right.materialized()) {
                            d6 += borders.right.width;
                        }
                    }
                    d += d6;
                    d5 += d6;
                    int n6 = n4 + n5;
                    d6 = 0.0;
                    for (n4 = n; n4 < n6; ++n4) {
                        d6 += dArray2[n4];
                    }
                    if (d > d6) {
                        d6 = (d - d6) / (double)n5;
                        n4 = n;
                        n6 = n4 + n5;
                        while (n4 < n6) {
                            int n7 = n4++;
                            dArray2[n7] = dArray2[n7] + d6;
                        }
                    }
                    n6 = n4 + n5;
                    d6 = 0.0;
                    for (n4 = n; n4 < n6; ++n4) {
                        d6 += dArray3[n4];
                    }
                    if (!(d5 > d6)) continue;
                    d6 = (d5 - d6) / (double)n5;
                    n4 = n;
                    n6 = n4 + n5;
                    while (n4 < n6) {
                        int n8 = n4++;
                        dArray3[n8] = dArray3[n8] + d6;
                    }
                }
            }
        }
        double d7 = 0.0;
        double d8 = 0.0;
        for (n4 = 0; n4 < this.numColumns; ++n4) {
            d7 += dArray2[n4];
            d8 += dArray3[n4];
        }
        if (this.style.width > 0.0) {
            if (this.style.width > d7) {
                d = this.style.width - d7;
                dArray = this.expand(dArray2, dArray3, d);
            } else if (this.style.width < d7) {
                d = d7 - this.style.width;
                dArray = this.shrink(dArray2, d);
            } else {
                dArray = dArray2;
            }
        } else if (d8 > this.maxTableWidth) {
            if (this.maxTableWidth > d7) {
                d = this.maxTableWidth - d7;
                dArray = this.expand(dArray2, dArray3, d);
            } else if (this.maxTableWidth < d7) {
                d = d7 - this.maxTableWidth;
                dArray = this.shrink(dArray2, d);
            } else {
                dArray = dArray2;
            }
        } else {
            dArray = dArray3;
        }
        return dArray;
    }

    private double[] expand(double[] dArray, double[] dArray2, double d) {
        int n;
        double[] dArray3 = new double[this.numColumns];
        int n2 = 0;
        for (n = 0; n < this.numColumns; ++n) {
            dArray3[n] = dArray[n];
            if (!(dArray3[n] < dArray2[n])) continue;
            ++n2;
        }
        while (d > 0.0) {
            double d2;
            if (n2 == 0) {
                d2 = d / (double)this.numColumns;
                n = 0;
                while (n < this.numColumns) {
                    int n3 = n++;
                    dArray3[n3] = dArray3[n3] + d2;
                }
                d = 0.0;
                continue;
            }
            d2 = d / (double)n2;
            n2 = 0;
            d = 0.0;
            for (n = 0; n < this.numColumns; ++n) {
                if (dArray3[n] < dArray2[n]) {
                    int n4 = n;
                    dArray3[n4] = dArray3[n4] + d2;
                }
                if (dArray3[n] > dArray2[n]) {
                    d += dArray3[n] - dArray2[n];
                    dArray3[n] = dArray2[n];
                    continue;
                }
                if (!(dArray3[n] < dArray2[n])) continue;
                ++n2;
            }
        }
        return dArray3;
    }

    private double[] shrink(double[] dArray, double d) {
        int n;
        double d2 = dArray[0];
        double d3 = dArray[0];
        double d4 = 0.0;
        double[] dArray2 = new double[this.numColumns];
        for (n = 1; n < this.numColumns; ++n) {
            if (dArray[n] < d2) {
                d2 = dArray[n];
                continue;
            }
            if (!(dArray[n] > d3)) continue;
            d3 = dArray[n];
        }
        double d5 = (d2 + d3) / 2.0;
        for (n = 0; n < this.numColumns; ++n) {
            if (!(dArray[n] >= d5)) continue;
            d4 += dArray[n];
        }
        for (n = 0; n < this.numColumns; ++n) {
            if (dArray[n] >= d5) {
                dArray2[n] = dArray[n] - d * dArray[n] / d4;
                if (!(dArray2[n] <= 0.0)) continue;
                dArray2[n] = dArray[n];
                continue;
            }
            dArray2[n] = dArray[n];
        }
        return dArray2;
    }

    private double leftBorderWidth(TableRow tableRow, TableCell tableCell) {
        int n;
        double d = 0.0;
        Borders borders = tableCell.style.borders;
        if (borders.left.materialized()) {
            d = borders.left.width;
        }
        if ((n = tableCell.colNumber - 1) >= 1) {
            borders = tableRow.cells[n - 1].style.borders;
            if (borders.right.materialized() && borders.right.width > d) {
                d = borders.right.width;
            }
            d /= 2.0;
        }
        return d;
    }

    private double rightBorderWidth(TableRow tableRow, TableCell tableCell) {
        int n;
        double d = 0.0;
        Borders borders = tableCell.style.borders;
        if (borders.right.materialized()) {
            d = borders.right.width;
        }
        if ((n = tableCell.colNumber + tableCell.colSpan) <= tableRow.cells.length) {
            borders = tableRow.cells[n - 1].style.borders;
            if (borders.left.materialized() && borders.left.width > d) {
                d = borders.left.width;
            }
            d /= 2.0;
        }
        return d;
    }

    public void print(PrintWriter printWriter, Encoder encoder) {
        int n;
        printWriter.print("<table:table");
        printWriter.print(" table:style-name=\"" + this.style.name + "\"");
        printWriter.println(">");
        for (n = 0; n < this.numColumns; ++n) {
            printWriter.print("<table:table-column");
            printWriter.print(" table:style-name=\"" + this.columnStyles[n].name + "\"");
            printWriter.println("/>");
        }
        if (this.header != null) {
            printWriter.println("<table:table-header-rows>");
            this.header.print(printWriter, encoder);
            printWriter.println("</table:table-header-rows>");
        }
        printWriter.println("<table:table-rows>");
        int n2 = this.bodies.size();
        for (n = 0; n < n2; ++n) {
            TableGroup tableGroup = (TableGroup)this.bodies.elementAt(n);
            tableGroup.print(printWriter, encoder);
        }
        if (this.footer != null) {
            this.footer.print(printWriter, encoder);
        }
        printWriter.println("</table:table-rows>");
        printWriter.println("</table:table>");
    }

    public double minWidth() {
        int n;
        if (this.style.width > 0.0 && !this.style.relativeWidth) {
            return this.style.width + this.style.marginLeft + this.style.marginRight;
        }
        if (this.columns == null) {
            this.normalize();
        }
        double[] dArray = new double[this.numColumns];
        for (n = 0; n < this.numColumns; ++n) {
            TableColumn tableColumn = this.columns[n];
            if (tableColumn == null || !(tableColumn.width > 0.0) || tableColumn.widthType != 0) continue;
            dArray[tableColumn.number - 1] = tableColumn.width;
        }
        double d = 0.0;
        boolean bl = true;
        for (n = 0; n < this.numColumns; ++n) {
            if (dArray[n] == 0.0) {
                bl = false;
                break;
            }
            d += dArray[n];
        }
        if (!bl) {
            for (int i = 0; i < this.groups.length; ++i) {
                TableGroup tableGroup = this.groups[i];
                for (int j = 0; j < tableGroup.rows.length; ++j) {
                    TableRow tableRow = tableGroup.rows[j];
                    for (int k = 0; k < tableRow.cells.length; ++k) {
                        TableCell tableCell = tableRow.cells[k];
                        if (tableCell.isCovered) continue;
                        d = tableCell.minWidth();
                        if (this.style.borderModel == 0) {
                            d += this.leftBorderWidth(tableRow, tableCell);
                            d += this.rightBorderWidth(tableRow, tableCell);
                        } else {
                            Borders borders = tableCell.style.borders;
                            if (borders.left.materialized()) {
                                d += borders.left.width;
                            }
                            if (borders.right.materialized()) {
                                d += borders.right.width;
                            }
                        }
                        int n2 = tableCell.colSpan;
                        if (n2 > 1) {
                            d /= (double)n2;
                            int n3 = n + n2;
                            for (n = tableCell.colNumber - 1; n < n3; ++n) {
                                if (!(d > dArray[n])) continue;
                                dArray[n] = d;
                            }
                            continue;
                        }
                        if (!(d > dArray[n])) continue;
                        dArray[n] = d;
                    }
                }
            }
            d = 0.0;
            for (n = 0; n < this.numColumns; ++n) {
                d += dArray[n];
            }
        }
        return d += this.style.marginLeft + this.style.marginRight;
    }

    public double maxWidth() {
        int n;
        if (this.style.width > 0.0 && !this.style.relativeWidth) {
            return this.style.width + this.style.marginLeft + this.style.marginRight;
        }
        if (this.columns == null) {
            this.normalize();
        }
        double[] dArray = new double[this.numColumns];
        for (n = 0; n < this.numColumns; ++n) {
            TableColumn tableColumn = this.columns[n];
            if (tableColumn == null || !(tableColumn.width > 0.0) || tableColumn.widthType != 0) continue;
            dArray[tableColumn.number - 1] = tableColumn.width;
        }
        double d = 0.0;
        boolean bl = true;
        for (n = 0; n < this.numColumns; ++n) {
            if (dArray[n] == 0.0) {
                bl = false;
                break;
            }
            d += dArray[n];
        }
        if (!bl) {
            for (int i = 0; i < this.groups.length; ++i) {
                TableGroup tableGroup = this.groups[i];
                for (int j = 0; j < tableGroup.rows.length; ++j) {
                    TableRow tableRow = tableGroup.rows[j];
                    for (int k = 0; k < tableRow.cells.length; ++k) {
                        TableCell tableCell = tableRow.cells[k];
                        if (tableCell.isCovered) continue;
                        d = tableCell.maxWidth();
                        if (this.style.borderModel == 0) {
                            d += this.leftBorderWidth(tableRow, tableCell);
                            d += this.rightBorderWidth(tableRow, tableCell);
                        } else {
                            Borders borders = tableCell.style.borders;
                            if (borders.left.materialized()) {
                                d += borders.left.width;
                            }
                            if (borders.right.materialized()) {
                                d += borders.right.width;
                            }
                        }
                        int n2 = tableCell.colSpan;
                        if (n2 > 1) {
                            d /= (double)n2;
                            int n3 = n + n2;
                            for (n = tableCell.colNumber - 1; n < n3; ++n) {
                                if (!(d > dArray[n])) continue;
                                dArray[n] = d;
                            }
                            continue;
                        }
                        if (!(d > dArray[n])) continue;
                        dArray[n] = d;
                    }
                }
            }
            d = 0.0;
            for (n = 0; n < this.numColumns; ++n) {
                d += dArray[n];
            }
        }
        return d += this.style.marginLeft + this.style.marginRight;
    }

    public double marginLeft() {
        return this.style.marginLeft;
    }
}

