/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.odt.Caption;
import com.xmlmind.fo.converter.odt.StyleTable;
import com.xmlmind.fo.converter.odt.Table;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;

public final class TableAndCaption {
    public Table table;
    public Caption caption;

    public TableAndCaption(Context context) {
        this.initialize(context);
    }

    private void initialize(Context context) {
    }

    public void layout(double d, StyleTable styleTable) throws Exception {
        if (this.table != null) {
            this.table.layout(d, styleTable);
        }
    }

    public void print(PrintWriter printWriter, Encoder encoder) {
        if (this.caption != null && this.caption.side == 0) {
            this.caption.print(printWriter, encoder);
        }
        if (this.table != null) {
            this.table.print(printWriter, encoder);
        }
        if (this.caption != null && this.caption.side == 1) {
            this.caption.print(printWriter, encoder);
        }
    }

    public double minWidth() {
        double d;
        double d2 = 0.0;
        if (this.table != null) {
            d2 = this.table.minWidth();
        }
        if (this.caption != null && (d = this.caption.minWidth()) > d2) {
            d2 = d;
        }
        return d2;
    }

    public double maxWidth() {
        double d;
        double d2 = 0.0;
        if (this.table != null) {
            d2 = this.table.maxWidth();
        }
        if (this.caption != null && (d = this.caption.maxWidth()) > d2) {
            d2 = d;
        }
        return d2;
    }
}

