/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.odt.Borders;
import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public final class TableCellStyle {
    public static final int COLOR_TRANSPARENT = -1;
    public static final int ALIGNMENT_TOP = 0;
    public static final int ALIGNMENT_MIDDLE = 1;
    public static final int ALIGNMENT_BOTTOM = 2;
    public String name;
    public Borders borders;
    public double paddingTop;
    public double paddingBottom;
    public double paddingLeft;
    public double paddingRight;
    public int background;
    public int alignment;

    public TableCellStyle() {
        this.borders = new Borders();
        this.background = -1;
    }

    public TableCellStyle(Context context) {
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        this.borders = new Borders(valueArray);
        this.paddingTop = TableCellStyle.length(valueArray[208]);
        this.paddingBottom = TableCellStyle.length(valueArray[199]);
        this.paddingLeft = TableCellStyle.length(valueArray[203]);
        this.paddingRight = TableCellStyle.length(valueArray[204]);
        Value value = valueArray[8];
        this.background = value.type == 24 ? Odt.rgb(value.color()) : -1;
        switch (valueArray[93].keyword()) {
            case 31: {
                this.alignment = 1;
                break;
            }
            case 4: {
                this.alignment = 2;
            }
        }
    }

    private static double length(Value value) {
        double d = 0.0;
        if (value.type == 4) {
            d = value.length();
        }
        return d;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<style:style style:family=\"table-cell\"");
        printWriter.print(" style:name=\"" + this.name + "\"");
        printWriter.println(">");
        printWriter.println("<style:table-cell-properties");
        this.borders.print(printWriter);
        if (this.paddingTop > 0.0) {
            printWriter.println(" fo:padding-top=\"" + Odt.length(this.paddingTop, 1) + "\"");
        }
        if (this.paddingBottom > 0.0) {
            printWriter.println(" fo:padding-bottom=\"" + Odt.length(this.paddingBottom, 1) + "\"");
        }
        if (this.paddingLeft > 0.0) {
            printWriter.println(" fo:padding-left=\"" + Odt.length(this.paddingLeft, 1) + "\"");
        }
        if (this.paddingRight > 0.0) {
            printWriter.println(" fo:padding-right=\"" + Odt.length(this.paddingRight, 1) + "\"");
        }
        if (this.background != -1) {
            printWriter.println(" fo:background-color=\"" + Odt.color(this.background) + "\"");
        }
        printWriter.println(" style:vertical-align=\"" + this.alignment() + "\"");
        printWriter.println(">");
        printWriter.println("</style:table-cell-properties>");
        printWriter.println("</style:style>");
    }

    private String alignment() {
        String string = "top";
        switch (this.alignment) {
            case 1: {
                string = "middle";
                break;
            }
            case 2: {
                string = "bottom";
            }
        }
        return string;
    }

    public int hashCode() {
        int n = 0;
        n = TableCellStyle.shift(n) ^ this.borders.hashCode();
        n = TableCellStyle.shift(n) ^ TableCellStyle.hash(this.paddingTop);
        n = TableCellStyle.shift(n) ^ TableCellStyle.hash(this.paddingBottom);
        n = TableCellStyle.shift(n) ^ TableCellStyle.hash(this.paddingLeft);
        n = TableCellStyle.shift(n) ^ TableCellStyle.hash(this.paddingRight);
        n = TableCellStyle.shift(n) ^ this.background;
        n = TableCellStyle.shift(n) ^ this.alignment;
        return n >>> 16 | n << 16;
    }

    private static int hash(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    private static int shift(int n) {
        return n << 1 | n >>> 31;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TableCellStyle)) {
            return false;
        }
        TableCellStyle tableCellStyle = (TableCellStyle)object;
        return this.borders.equals(tableCellStyle.borders) && this.paddingTop == tableCellStyle.paddingTop && this.paddingBottom == tableCellStyle.paddingBottom && this.paddingLeft == tableCellStyle.paddingLeft && this.paddingRight == tableCellStyle.paddingRight && this.background == tableCellStyle.background && this.alignment == tableCellStyle.alignment;
    }
}

