/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.odt.Odt;
import java.io.PrintWriter;

public final class TableColumnStyle {
    public String name;
    public double width;
    public boolean relativeWidth;
    public boolean optimizeWidth;

    public TableColumnStyle(double d) {
        this(d, false);
    }

    public TableColumnStyle(double d, boolean bl) {
        this.width = d;
        this.relativeWidth = bl;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<style:style style:family=\"table-column\"");
        printWriter.print(" style:name=\"" + this.name + "\"");
        printWriter.println(">");
        printWriter.println("<style:table-column-properties");
        if (this.relativeWidth) {
            printWriter.println(" style:rel-column-width=\"" + Odt.relativeLength(this.width, 0) + "\"");
        } else {
            printWriter.println(" style:column-width=\"" + Odt.length(this.width, 1) + "\"");
        }
        printWriter.println(" style:use-optimal-column-width=\"" + this.optimizeWidth() + "\"");
        printWriter.println(">");
        printWriter.println("</style:table-column-properties>");
        printWriter.println("</style:style>");
    }

    private String optimizeWidth() {
        if (this.optimizeWidth) {
            return "true";
        }
        return "false";
    }

    public int hashCode() {
        int n = 0;
        n = TableColumnStyle.shift(n) ^ TableColumnStyle.hash(this.width);
        n = TableColumnStyle.shift(n) ^ TableColumnStyle.hash(this.relativeWidth);
        n = TableColumnStyle.shift(n) ^ TableColumnStyle.hash(this.optimizeWidth);
        return n >>> 16 | n << 16;
    }

    private static int hash(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    private static int hash(boolean bl) {
        return bl ? 1 : 0;
    }

    private static int shift(int n) {
        return n << 1 | n >>> 31;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TableColumnStyle)) {
            return false;
        }
        TableColumnStyle tableColumnStyle = (TableColumnStyle)object;
        return this.width == tableColumnStyle.width && this.relativeWidth == tableColumnStyle.relativeWidth && this.optimizeWidth == tableColumnStyle.optimizeWidth;
    }
}

