/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public final class TableStyle {
    public static final int BREAK_AUTO = 0;
    public static final int BREAK_COLUMN = 1;
    public static final int BREAK_PAGE = 2;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_RIGHT = 1;
    public static final int ALIGNMENT_CENTER = 2;
    public static final int ALIGNMENT_MARGINS = 3;
    public static final int BORDER_COLLAPSE = 0;
    public static final int BORDER_SEPARATE = 1;
    public static final int COLOR_TRANSPARENT = -1;
    public String name;
    public int breakBefore;
    public boolean keepTogether;
    public boolean keepWithNext;
    public double marginTop;
    public double marginBottom;
    public double marginLeft;
    public double marginRight;
    public int alignment;
    public int borderModel;
    public double width;
    public boolean relativeWidth;
    public int background;
    public String masterPageName;

    public TableStyle() {
        this.width = 100.0;
        this.relativeWidth = true;
        this.background = -1;
        this.masterPageName = "";
    }

    public TableStyle(Context context) {
        this.initialize(context);
        this.masterPageName = "";
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        switch (context.breakBefore) {
            case 1: {
                this.breakBefore = 1;
                break;
            }
            case 2: {
                this.breakBefore = 2;
            }
        }
        this.keepTogether = TableStyle.keep(valueArray[137]);
        this.keepWithNext = TableStyle.keep(valueArray[141]);
        this.marginTop = context.spaceBefore();
        this.marginLeft = TableStyle.length(valueArray[277]);
        this.marginRight = TableStyle.length(valueArray[97]);
        int n = valueArray[37].keyword();
        if (n == 177) {
            int n2 = 54;
            int n3 = 55;
            double d = TableStyle.length(valueArray[n2]);
            double d2 = TableStyle.length(valueArray[n3]);
            if (d > 0.0 || d2 > 0.0) {
                this.borderModel = 1;
            }
        }
        Value value = valueArray[308];
        switch (value.type) {
            case 4: {
                this.width = value.length();
                break;
            }
            case 13: {
                this.width = value.percentage();
                this.relativeWidth = true;
            }
        }
        this.background = context.background != null ? Odt.rgb(context.background) : -1;
        Context context2 = context.parent();
        if (context2.fo == 46) {
            valueArray = context2.properties.values;
            switch (valueArray[289].keyword()) {
                case 52: 
                case 165: {
                    this.alignment = 1;
                    break;
                }
                case 31: 
                case 93: {
                    this.alignment = 2;
                }
            }
        }
    }

    private static boolean keep(Value value) {
        boolean bl = false;
        switch (value.type) {
            case 1: {
                if (value.keyword() != 8) break;
                bl = true;
                break;
            }
            case 2: {
                if (value.integer() <= 0) break;
                bl = true;
            }
        }
        return bl;
    }

    private static double length(Value value) {
        double d = 0.0;
        if (value.type == 4) {
            d = value.length();
        }
        return d;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<style:style style:family=\"table\"");
        printWriter.print(" style:name=\"" + this.name + "\"");
        if (this.masterPageName.length() > 0) {
            printWriter.print(" style:master-page-name=\"" + this.masterPageName + "\"");
        }
        printWriter.println(">");
        printWriter.println("<style:table-properties");
        if (this.breakBefore != 0) {
            printWriter.println(" fo:break-before=\"" + this.breakBefore() + "\"");
        }
        if (this.keepWithNext) {
            printWriter.println(" fo:keep-with-next=\"always\"");
        }
        printWriter.println(" style:may-break-between-rows=\"" + this.mayBreakBetweenRows() + "\"");
        if (this.marginTop > 0.0) {
            printWriter.println(" fo:margin-top=\"" + Odt.length(this.marginTop, 1) + "\"");
        }
        if (this.marginBottom > 0.0) {
            printWriter.println(" fo:margin-bottom=\"" + Odt.length(this.marginBottom, 1) + "\"");
        }
        if ((this.alignment == 0 || this.alignment == 3) && this.marginLeft != 0.0) {
            printWriter.println(" fo:margin-left=\"" + Odt.length(this.marginLeft, 1) + "\"");
        }
        if ((this.alignment == 1 || this.alignment == 3) && this.marginRight != 0.0) {
            printWriter.println(" fo:margin-right=\"" + Odt.length(this.marginRight, 1) + "\"");
        }
        printWriter.println(" table:align=\"" + this.alignment() + "\"");
        printWriter.println(" table:border-model=\"" + this.borderModel() + "\"");
        if (this.relativeWidth) {
            printWriter.println(" style:rel-width=\"" + Odt.percent(this.width, 0) + "\"");
        } else {
            printWriter.println(" style:width=\"" + Odt.length(this.width, 1) + "\"");
        }
        if (this.background != -1) {
            printWriter.println(" fo:background-color=\"" + Odt.color(this.background) + "\"");
        }
        printWriter.println(">");
        printWriter.println("</style:table-properties>");
        printWriter.println("</style:style>");
    }

    private String breakBefore() {
        String string = "auto";
        switch (this.breakBefore) {
            case 1: {
                string = "column";
                break;
            }
            case 2: {
                string = "page";
            }
        }
        return string;
    }

    private String mayBreakBetweenRows() {
        if (this.keepTogether) {
            return "false";
        }
        return "true";
    }

    private String alignment() {
        String string = "left";
        switch (this.alignment) {
            case 1: {
                string = "right";
                break;
            }
            case 2: {
                string = "center";
                break;
            }
            case 3: {
                string = "margins";
            }
        }
        return string;
    }

    private String borderModel() {
        if (this.borderModel == 1) {
            return "separating";
        }
        return "collapsing";
    }

    public int hashCode() {
        int n = 0;
        n = TableStyle.shift(n) ^ this.breakBefore;
        n = TableStyle.shift(n) ^ TableStyle.hash(this.keepTogether);
        n = TableStyle.shift(n) ^ TableStyle.hash(this.keepWithNext);
        n = TableStyle.shift(n) ^ TableStyle.hash(this.marginTop);
        n = TableStyle.shift(n) ^ TableStyle.hash(this.marginBottom);
        n = TableStyle.shift(n) ^ TableStyle.hash(this.marginLeft);
        n = TableStyle.shift(n) ^ TableStyle.hash(this.marginRight);
        n = TableStyle.shift(n) ^ this.alignment;
        n = TableStyle.shift(n) ^ this.borderModel;
        n = TableStyle.shift(n) ^ TableStyle.hash(this.width);
        n = TableStyle.shift(n) ^ TableStyle.hash(this.relativeWidth);
        n = TableStyle.shift(n) ^ this.background;
        n = TableStyle.shift(n) ^ this.masterPageName.hashCode();
        return n >>> 16 | n << 16;
    }

    private static int hash(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    private static int hash(boolean bl) {
        return bl ? 1 : 0;
    }

    private static int shift(int n) {
        return n << 1 | n >>> 31;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TableStyle)) {
            return false;
        }
        TableStyle tableStyle = (TableStyle)object;
        return this.breakBefore == tableStyle.breakBefore && this.keepTogether == tableStyle.keepTogether && this.keepWithNext == tableStyle.keepWithNext && this.marginTop == tableStyle.marginTop && this.marginBottom == tableStyle.marginBottom && this.marginLeft == tableStyle.marginLeft && this.marginRight == tableStyle.marginRight && this.alignment == tableStyle.alignment && this.borderModel == tableStyle.borderModel && this.width == tableStyle.width && this.relativeWidth == tableStyle.relativeWidth && this.background == tableStyle.background && this.masterPageName.equals(tableStyle.masterPageName);
    }
}

