/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.odt.FontFace;
import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.converter.odt.OdtTranslator;
import com.xmlmind.fo.font.Font;
import com.xmlmind.fo.font.FontCache;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public final class TextStyle
implements Cloneable {
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_ITALIC = 1;
    public static final int FONT_STYLE_OBLIQUE = 2;
    public static final int FONT_VARIANT_NORMAL = 0;
    public static final int FONT_VARIANT_SMALL_CAPS = 1;
    public static final int COLOR_TRANSPARENT = -1;
    public String name;
    public FontFace font;
    public double fontSize;
    public int fontStyle;
    public int fontWeight;
    public int fontVariant;
    public int fgColor;
    public int bgColor;
    public boolean lineThrough;
    public boolean underline;
    public int ulColor;
    public boolean subscript;
    public boolean superscript;
    public double textPosition;

    public TextStyle(Context context) {
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        Value[] valueArray2 = valueArray[104].list();
        this.font = new FontFace(((OdtTranslator)context.translator).unaliasFontFamily(valueArray2[0].string()));
        this.fontSize = valueArray[106].length();
        switch (valueArray[109].keyword()) {
            case 92: {
                this.fontStyle = 1;
                break;
            }
            case 139: {
                this.fontStyle = 2;
            }
        }
        this.fontWeight = valueArray[111].integer();
        switch (valueArray[110].keyword()) {
            case 184: {
                this.fontVariant = 1;
            }
        }
        this.fgColor = Odt.rgb(valueArray[78].color());
        this.bgColor = context.background != null ? Odt.rgb(context.background) : -1;
        this.ulColor = context.textDecoration.color != null ? Odt.rgb(context.textDecoration.color) : this.fgColor;
        this.lineThrough = context.textDecoration.lineThrough;
        this.underline = context.textDecoration.underline;
        Value value = valueArray[14];
        if (value.type == 1) {
            switch (value.keyword()) {
                case 193: {
                    this.subscript = true;
                    break;
                }
                case 194: {
                    this.superscript = true;
                }
            }
        } else {
            double d = context.parent().fontSize();
            double d2 = value.length();
            this.textPosition = d2 / d * 100.0;
        }
    }

    public Font getFont() {
        int n = -1;
        if (this.font.family != null) {
            if ("roman".equals(this.font.family)) {
                n = 1;
            } else if ("swiss".equals(this.font.family)) {
                n = 2;
            } else if ("modern".equals(this.font.family)) {
                n = 3;
            } else if ("decorative".equals(this.font.family)) {
                n = 4;
            } else if ("script".equals(this.font.family)) {
                n = 5;
            }
        }
        int n2 = 0;
        if (this.fontWeight >= 700) {
            n2 |= 1;
        }
        if (this.fontStyle == 1 || this.fontStyle == 2) {
            n2 |= 2;
        }
        int n3 = (int)Math.ceil(this.fontSize);
        if (n < 0) {
            return FontCache.getFont(this.font.name, n2, n3);
        }
        return FontCache.getFont(n, n2, n3);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<style:style style:family=\"text\"");
        printWriter.println(" style:name=\"" + this.name + "\">");
        this.printProperties(printWriter);
        printWriter.println("</style:style>");
    }

    public void printProperties(PrintWriter printWriter) {
        printWriter.println("<style:text-properties");
        printWriter.println(" style:font-name=\"" + this.font.id + "\"");
        printWriter.println(" fo:font-size=\"" + Odt.length(this.fontSize, 1) + "\"");
        printWriter.println(" fo:font-style=\"" + this.fontStyle() + "\"");
        printWriter.println(" fo:font-weight=\"" + this.fontWeight() + "\"");
        printWriter.println(" fo:font-variant=\"" + this.fontVariant() + "\"");
        printWriter.println(" fo:color=\"" + Odt.color(this.fgColor) + "\"");
        if (this.bgColor != -1) {
            printWriter.println(" fo:background-color=\"" + Odt.color(this.bgColor) + "\"");
        }
        if (this.lineThrough) {
            printWriter.println(" style:text-line-through-type=\"single\"");
            printWriter.println(" style:text-line-through-style=\"solid\"");
        }
        if (this.underline) {
            printWriter.println(" style:text-underline-type=\"single\"");
            printWriter.println(" style:text-underline-style=\"solid\"");
            printWriter.println(" style:text-underline-color=\"" + Odt.color(this.ulColor) + "\"");
        }
        if (this.subscript || this.superscript || this.textPosition != 0.0) {
            printWriter.println(" style:text-position=\"" + this.textPosition() + "\"");
        }
        printWriter.println("/>");
    }

    private String fontStyle() {
        String string = "normal";
        switch (this.fontStyle) {
            case 1: {
                string = "italic";
                break;
            }
            case 2: {
                string = "oblique";
            }
        }
        return string;
    }

    private String fontWeight() {
        if (this.fontWeight >= 700) {
            return "bold";
        }
        return "normal";
    }

    private String fontVariant() {
        if (this.fontVariant == 1) {
            return "small-caps";
        }
        return "normal";
    }

    private String textPosition() {
        if (this.subscript) {
            return "sub";
        }
        if (this.superscript) {
            return "super";
        }
        return Odt.percent(this.textPosition, 0);
    }

    public int hashCode() {
        int n = 0;
        n = TextStyle.shift(n) ^ this.font.hashCode();
        n = TextStyle.shift(n) ^ TextStyle.hash(this.fontSize);
        n = TextStyle.shift(n) ^ this.fontStyle;
        n = TextStyle.shift(n) ^ this.fontWeight;
        n = TextStyle.shift(n) ^ this.fontVariant;
        n = TextStyle.shift(n) ^ this.fgColor;
        n = TextStyle.shift(n) ^ this.bgColor;
        n = TextStyle.shift(n) ^ TextStyle.hash(this.lineThrough);
        n = TextStyle.shift(n) ^ TextStyle.hash(this.underline);
        n = TextStyle.shift(n) ^ this.ulColor;
        n = TextStyle.shift(n) ^ TextStyle.hash(this.subscript);
        n = TextStyle.shift(n) ^ TextStyle.hash(this.superscript);
        n = TextStyle.shift(n) ^ TextStyle.hash(this.textPosition);
        return n >>> 16 | n << 16;
    }

    private static int hash(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    private static int hash(boolean bl) {
        return bl ? 1 : 0;
    }

    private static int shift(int n) {
        return n << 1 | n >>> 31;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TextStyle)) {
            return false;
        }
        TextStyle textStyle = (TextStyle)object;
        return this.font.equals(textStyle.font) && this.fontSize == textStyle.fontSize && this.fontStyle == textStyle.fontStyle && this.fontWeight == textStyle.fontWeight && this.fontVariant == textStyle.fontVariant && this.fgColor == textStyle.fgColor && this.bgColor == textStyle.bgColor && this.lineThrough == textStyle.lineThrough && this.underline == textStyle.underline && this.ulColor == textStyle.ulColor && this.subscript == textStyle.subscript && this.superscript == textStyle.superscript && this.textPosition == textStyle.textPosition;
    }

    public TextStyle copy() {
        TextStyle textStyle = null;
        try {
            textStyle = (TextStyle)this.clone();
            textStyle.name = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return textStyle;
    }
}

