/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.rtf.ListTable;
import com.xmlmind.fo.converter.rtf.Paragraph;
import com.xmlmind.fo.converter.rtf.Rtf;
import com.xmlmind.fo.converter.rtf.RunProperties;
import com.xmlmind.fo.converter.rtf.Text;
import com.xmlmind.fo.properties.LabelFormat;
import com.xmlmind.fo.properties.Value;
import java.util.Vector;

public final class List {
    public int id = -1;
    public boolean plainText;
    public int labelSeparation;
    public LabelFormat labelFormat;
    public Item item;

    public List() {
    }

    public List(Context context) {
        this();
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        Value value = valueArray[224];
        if (value.type == 4) {
            this.labelSeparation = Rtf.toTwips(value.length());
        }
        if ((value = valueArray[321]) != null && value.type == 30) {
            this.labelFormat = value.labelFormat();
        }
    }

    public static class Item {
        public int breakBefore;
        public int spaceBefore;
        public Label label;

        public Item() {
        }

        public Item(Paragraph paragraph) {
            this();
            this.initialize(paragraph);
        }

        public void initialize(Paragraph paragraph) {
            this.breakBefore = paragraph.properties.breakBefore;
            this.spaceBefore = paragraph.properties.spaceBefore;
            this.label = new Label(paragraph);
        }

        public static class Label {
            public static final int ALIGNMENT_LEFT = 0;
            public static final int ALIGNMENT_CENTER = 1;
            public static final int ALIGNMENT_RIGHT = 2;
            private static final int STYLE_NONE = 0;
            private static final int STYLE_ARABIC = 1;
            private static final int STYLE_UPPERCASE_ROMAN = 2;
            private static final int STYLE_LOWERCASE_ROMAN = 3;
            private static final int STYLE_UPPERCASE_LETTER = 4;
            private static final int STYLE_LOWERCASE_LETTER = 5;
            private static final int STYLE_BULLET = 6;
            public int alignment = 0;
            public int startIndent;
            public int endIndent;
            public Vector runs = new Vector();
            public RunProperties properties;
            public String text = "";

            public Label() {
            }

            public Label(Paragraph paragraph) {
                this();
                this.initialize(paragraph);
            }

            public void initialize(Paragraph paragraph) {
                Paragraph.Run run;
                int n = paragraph.properties.alignment;
                boolean bl = true;
                if (n == 1) {
                    this.alignment = 1;
                } else if (n == 2) {
                    this.alignment = 2;
                }
                this.startIndent = paragraph.properties.startIndent;
                this.endIndent = paragraph.properties.endIndent;
                int n2 = paragraph.runs.size();
                for (int i = 0; i < n2; ++i) {
                    run = (Paragraph.Run)paragraph.runs.elementAt(i);
                    if (run.type == 2) break;
                    if (run.type != 1) {
                        bl = false;
                    }
                    this.runs.addElement(run);
                }
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n3 = this.runs.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        run = (Paragraph.Run)this.runs.elementAt(n2);
                        Text text = (Text)run.object;
                        if (this.properties == null) {
                            this.properties = text.properties;
                        }
                        stringBuffer.append(text.text);
                    }
                    this.text = stringBuffer.toString().trim();
                }
            }

            public ListTable.List list(LabelFormat labelFormat) {
                ListTable.List list;
                if (labelFormat != null) {
                    if (labelFormat.type == 0) {
                        return null;
                    }
                    list = new ListTable.List();
                    switch (labelFormat.type) {
                        case 2: {
                            list.style = 0;
                            break;
                        }
                        case 3: {
                            list.style = 4;
                            break;
                        }
                        case 4: {
                            list.style = 3;
                            break;
                        }
                        case 5: {
                            list.style = 2;
                            break;
                        }
                        case 6: {
                            list.style = 1;
                            break;
                        }
                        default: {
                            list.style = 23;
                            list.textAfter = labelFormat.suffix;
                        }
                    }
                    if (labelFormat.type != 1) {
                        list.start = labelFormat.start;
                        if (labelFormat.prefix != null) {
                            list.textBefore = labelFormat.prefix;
                        }
                        if (labelFormat.suffix != null) {
                            list.textAfter = labelFormat.suffix;
                        }
                    }
                } else {
                    char c = '1';
                    char c2 = '\u0000';
                    char c3 = '\u0000';
                    int n = 0;
                    switch (this.text.length()) {
                        case 1: {
                            c = this.text.charAt(0);
                            n = Label.style(c);
                            break;
                        }
                        case 2: {
                            c3 = this.text.charAt(1);
                            if (c3 != '.' && c3 != ')' || (n = Label.style(c = this.text.charAt(0))) != 6) break;
                            n = 0;
                            break;
                        }
                        case 3: {
                            c2 = this.text.charAt(0);
                            c3 = this.text.charAt(2);
                            if (!(c2 == '(' && c3 == ')' || c2 == '<' && c3 == '>') && (c2 != '[' || c3 != ']') || (n = Label.style(c = this.text.charAt(1))) != 6) break;
                            n = 0;
                        }
                    }
                    if (n == 0) {
                        return null;
                    }
                    list = new ListTable.List();
                    switch (n) {
                        case 1: {
                            list.style = 0;
                            break;
                        }
                        case 2: {
                            list.style = 1;
                            break;
                        }
                        case 3: {
                            list.style = 2;
                            break;
                        }
                        case 4: {
                            list.style = 3;
                            break;
                        }
                        case 5: {
                            list.style = 4;
                            break;
                        }
                        case 6: {
                            list.style = 23;
                        }
                    }
                    list.start = c == '0' ? 0 : 1;
                    if (n == 6) {
                        list.setBullet(c);
                    } else {
                        if (c2 != '\u0000') {
                            list.textBefore = new String(new char[]{c2});
                        }
                        if (c3 != '\u0000') {
                            list.textAfter = new String(new char[]{c3});
                        }
                    }
                }
                switch (this.alignment) {
                    default: {
                        list.alignment = 0;
                        break;
                    }
                    case 1: {
                        list.alignment = 1;
                        break;
                    }
                    case 2: {
                        list.alignment = 2;
                    }
                }
                list.properties = this.properties.copy();
                return list;
            }

            private static int style(char c) {
                int n = 0;
                switch (c) {
                    case '*': 
                    case '+': 
                    case '-': 
                    case '\u2013': 
                    case '\u2022': {
                        n = 6;
                        break;
                    }
                    case '0': 
                    case '1': {
                        n = 1;
                        break;
                    }
                    case 'I': {
                        n = 2;
                        break;
                    }
                    case 'i': {
                        n = 3;
                        break;
                    }
                    case 'A': {
                        n = 4;
                        break;
                    }
                    case 'a': {
                        n = 5;
                    }
                }
                return n;
            }
        }
    }
}

