/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import com.xmlmind.fo.converter.rtf.RunProperties;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Vector;

public final class ListTable {
    private Vector lists = new Vector();
    private Random random = new Random(123456789L);

    public int add(List list) {
        list.id = (int)Math.rint(this.random.nextDouble() * 1.0E9);
        this.lists.addElement(list);
        return this.lists.size();
    }

    public void print(PrintWriter printWriter) {
        List list;
        int n;
        if (this.lists.size() == 0) {
            return;
        }
        printWriter.println("{\\*\\listtable");
        int n2 = this.lists.size();
        for (n = 0; n < n2; ++n) {
            list = (List)this.lists.elementAt(n);
            list.print(printWriter);
        }
        printWriter.println("}");
        printWriter.println("{\\*\\listoverridetable");
        n2 = this.lists.size();
        for (n = 0; n < n2; ++n) {
            list = (List)this.lists.elementAt(n);
            printWriter.print("{\\listoverride");
            printWriter.print("\\listid" + list.id);
            printWriter.print("\\listoverridecount0");
            printWriter.print("\\ls" + (n + 1));
            printWriter.println("}");
        }
        printWriter.println("}");
    }

    public static class List
    implements Cloneable {
        public static final int STYLE_ARABIC = 0;
        public static final int STYLE_UPPERCASE_ROMAN = 1;
        public static final int STYLE_LOWERCASE_ROMAN = 2;
        public static final int STYLE_UPPERCASE_LETTER = 3;
        public static final int STYLE_LOWERCASE_LETTER = 4;
        public static final int STYLE_BULLET = 23;
        public static final int ALIGNMENT_LEFT = 0;
        public static final int ALIGNMENT_CENTER = 1;
        public static final int ALIGNMENT_RIGHT = 2;
        public int style;
        public int start;
        public int alignment;
        public String textBefore;
        public String textAfter;
        public RunProperties properties;
        private int id;

        public List() {
            this(0);
        }

        public List(int n) {
            this.style = n;
            this.start = 1;
            this.alignment = 0;
        }

        public List(int n, int n2, int n3, String string, String string2, RunProperties runProperties) {
            this.style = n;
            this.start = n2;
            this.alignment = n3;
            this.textBefore = string;
            this.textAfter = string2;
            this.properties = runProperties;
        }

        public char getBullet() {
            if (this.style == 23 && this.textAfter != null) {
                return this.textAfter.charAt(0);
            }
            return '\u0000';
        }

        public void setBullet(char c) {
            if (this.style == 23) {
                this.textAfter = new String(new char[]{c});
            }
        }

        public void print(PrintWriter printWriter) {
            printWriter.println("{\\list\\listid" + this.id + "\\listsimple");
            printWriter.print("{\\listlevel");
            printWriter.print("\\levelnfc" + this.style);
            printWriter.print("\\leveljc" + this.alignment);
            printWriter.print("\\levelstartat" + this.start);
            printWriter.println("\\levelfollow0");
            printWriter.println("{\\leveltext" + this.levelText() + ";}");
            printWriter.println("{\\levelnumbers" + this.levelNumbers() + ";}");
            if (this.properties != null) {
                this.properties.print(printWriter);
                printWriter.println();
            }
            printWriter.println("}");
            printWriter.println("}");
        }

        private String levelText() {
            int n = 1;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.textBefore != null) {
                n += this.textBefore.length();
            }
            if (this.textAfter != null) {
                n += this.textAfter.length();
            }
            stringBuffer.append(List.hexString(n));
            if (this.textBefore != null) {
                stringBuffer.append(this.textBefore);
            }
            stringBuffer.append("\\'00");
            if (this.textAfter != null) {
                stringBuffer.append(this.textAfter);
            }
            return stringBuffer.toString();
        }

        private String levelNumbers() {
            int n = 1;
            if (this.textBefore != null) {
                n += this.textBefore.length();
            }
            return List.hexString(n);
        }

        private static String hexString(int n) {
            return "\\'" + Integer.toHexString(n >> 4 & 0xF) + Integer.toHexString(n & 0xF);
        }

        public List copy() {
            try {
                return (List)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

