/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import com.xmlmind.fo.converter.rtf.Bookmark;
import com.xmlmind.fo.converter.rtf.Break;
import com.xmlmind.fo.converter.rtf.Field;
import com.xmlmind.fo.converter.rtf.Footnote;
import com.xmlmind.fo.converter.rtf.PageNumber;
import com.xmlmind.fo.converter.rtf.ParProperties;
import com.xmlmind.fo.converter.rtf.Picture;
import com.xmlmind.fo.converter.rtf.RunProperties;
import com.xmlmind.fo.converter.rtf.Tab;
import com.xmlmind.fo.converter.rtf.Text;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public final class Paragraph {
    public static final int RUN_TYPE_TEXT = 1;
    public static final int RUN_TYPE_BREAK = 2;
    public static final int RUN_TYPE_TAB = 3;
    public static final int RUN_TYPE_PGNUM = 4;
    public static final int RUN_TYPE_FIELD = 5;
    public static final int RUN_TYPE_PICTURE = 6;
    public static final int RUN_TYPE_RTF = 7;
    public static final Paragraph EMPTY = new Paragraph();
    public Vector runs = new Vector();
    public ParProperties properties;
    public Bookmark[] bookmarks;
    public boolean startsListItem;
    public boolean isLast;
    public boolean hasPicture;

    public Paragraph() {
        this(null);
    }

    public Paragraph(ParProperties parProperties) {
        this.properties = parProperties;
    }

    public void add(Object object, int n) {
        this.runs.addElement(new Run(n, object));
    }

    public void add(Text text) {
        this.add(text, 1);
    }

    public void add(Break break_) {
        this.add(break_, 2);
    }

    public void add(Tab tab) {
        this.add(tab, 3);
    }

    public void add(PageNumber pageNumber) {
        this.add(pageNumber, 4);
    }

    public void add(Field field) {
        this.add(field, 5);
    }

    public void add(Picture picture) {
        this.add(picture, 6);
        this.hasPicture = true;
    }

    public void add(String string) {
        this.add(string, 7);
    }

    public void add(Footnote footnote) {
        Text text = null;
        int n = this.runs.size();
        if (n > 0) {
            Run run = (Run)this.runs.elementAt(n - 1);
            if (run.type == 7) {
                run = n > 1 ? (Run)this.runs.elementAt(n - 2) : null;
            }
            if (run != null && run.type == 1) {
                text = (Text)run.object;
            }
        }
        if (text == null) {
            text = new Text();
            this.add(text);
        }
        text.footnote = footnote;
    }

    public void add(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.runs.addElement(vector.elementAt(i));
        }
    }

    public void layout(int n) throws Exception {
        if (!this.hasPicture) {
            return;
        }
        if (this.properties != null) {
            n -= this.properties.startIndent + this.properties.endIndent;
        }
        double d = (double)n / 20.0;
        int n2 = this.runs.size();
        for (int i = 0; i < n2; ++i) {
            Run run = (Run)this.runs.elementAt(i);
            if (run.type != 6) continue;
            Picture picture = (Picture)run.object;
            picture.layout(d);
        }
    }

    public void print(PrintWriter printWriter) throws Exception {
        this.print(printWriter, null);
    }

    public void print(PrintWriter printWriter, Encoder encoder) throws Exception {
        Object object;
        Object object2;
        int n;
        int n2;
        Run[] runArray = new Run[this.runs.size()];
        for (n2 = 0; n2 < runArray.length; ++n2) {
            runArray[n2] = (Run)this.runs.elementAt(n2);
        }
        if (this.bookmarks != null) {
            for (n2 = 0; n2 < this.bookmarks.length; ++n2) {
                this.bookmarks[n2].start(printWriter, encoder);
            }
        }
        if (this.properties != null) {
            this.properties.print(printWriter, encoder);
            printWriter.println();
            if (this.properties.listId > 0 && this.properties.listText != null) {
                Tab tab = new Tab(this.properties.listText.properties);
                printWriter.println("{\\listtext");
                this.properties.listText.print(printWriter, encoder);
                tab.print(printWriter);
                printWriter.println("}");
            }
            switch (this.properties.breakBefore) {
                case 1: {
                    Break.COLUMN.print(printWriter);
                }
            }
        }
        for (n = 0; n < runArray.length && runArray[n].type == 1; ++n) {
            object2 = (Text)runArray[n].object;
            ((Text)object2).trimLeft();
            if (!((Text)object2).isVoid()) break;
            runArray[n].discard = true;
        }
        for (n = runArray.length - 1; n >= 0 && runArray[n].type == 1; --n) {
            object2 = (Text)runArray[n].object;
            ((Text)object2).trimRight();
            if (!((Text)object2).isVoid()) break;
            runArray[n].discard = true;
        }
        if (this.startsListItem) {
            block16: for (n = 0; n < runArray.length; ++n) {
                int n3;
                if (runArray[n].type != 3) continue;
                object2 = (Tab)runArray[n].object;
                if (!((Tab)object2).isSeparator) continue;
                for (n3 = n - 1; n3 >= 0 && runArray[n3].type == 1; --n3) {
                    object = (Text)runArray[n3].object;
                    ((Text)object).trimRight();
                    if (!((Text)object).isVoid()) break;
                    runArray[n3].discard = true;
                }
                for (n3 = n + 1; n3 < runArray.length && runArray[n3].type == 1; ++n3) {
                    object = (Text)runArray[n3].object;
                    ((Text)object).trimLeft();
                    if (!((Text)object).isVoid()) break block16;
                    runArray[n3].discard = true;
                }
                break;
            }
        }
        block19: for (n = 0; n < runArray.length; ++n) {
            object2 = runArray[n];
            if (((Run)object2).discard) continue;
            switch (((Run)object2).type) {
                case 1: {
                    Text text = (Text)((Run)object2).object;
                    text.print(printWriter, encoder);
                    continue block19;
                }
                case 2: {
                    object = (Break)((Run)object2).object;
                    ((Break)object).print(printWriter);
                    continue block19;
                }
                case 3: {
                    Tab tab = (Tab)((Run)object2).object;
                    tab.print(printWriter);
                    continue block19;
                }
                case 4: {
                    PageNumber pageNumber = (PageNumber)((Run)object2).object;
                    pageNumber.print(printWriter);
                    continue block19;
                }
                case 5: {
                    Field field = (Field)((Run)object2).object;
                    field.print(printWriter, encoder);
                    continue block19;
                }
                case 6: {
                    Picture picture = (Picture)((Run)object2).object;
                    picture.print(printWriter);
                    continue block19;
                }
                case 7: {
                    printWriter.println((String)((Run)object2).object);
                }
            }
        }
        if (!this.isLast) {
            printWriter.println("\\par");
        }
        if (this.bookmarks != null) {
            for (n = this.bookmarks.length - 1; n >= 0; --n) {
                this.bookmarks[n].end(printWriter, encoder);
            }
        }
    }

    public boolean isVoid() {
        int n = this.runs.size();
        for (int i = 0; i < n; ++i) {
            Run run = (Run)this.runs.elementAt(i);
            if (run.type != 1) {
                return false;
            }
            Text text = (Text)run.object;
            if (!text.isSpace() || text.preserveSpace()) {
                return false;
            }
            if (text.footnote == null) continue;
            return false;
        }
        if (this.properties != null && this.properties.listId != 0) {
            return false;
        }
        return this.bookmarks == null;
    }

    public boolean hasTabs() {
        return this.properties != null && this.properties.hasTabs();
    }

    public int maxWidth() {
        int n = 0;
        int n2 = 0;
        int n3 = this.runs.size();
        block5: for (int i = 0; i < n3; ++i) {
            Run run = (Run)this.runs.elementAt(i);
            switch (run.type) {
                case 1: {
                    Text text = (Text)run.object;
                    n2 += text.textWidth();
                    continue block5;
                }
                case 6: {
                    Picture picture = (Picture)run.object;
                    n2 += picture.width();
                    continue block5;
                }
                case 2: {
                    if (n2 > n) {
                        n = n2;
                    }
                    n2 = 0;
                }
            }
        }
        if (n2 > n) {
            n = n2;
        }
        if (this.properties != null) {
            n += this.properties.startIndent;
            n += this.properties.endIndent;
        }
        return n;
    }

    public int minWidth() {
        int n = 0;
        int n2 = this.runs.size();
        block4: for (int i = 0; i < n2; ++i) {
            Run run = (Run)this.runs.elementAt(i);
            switch (run.type) {
                case 1: {
                    Text text = (Text)run.object;
                    int n3 = text.wordWidth();
                    if (n3 <= n) continue block4;
                    n = n3;
                    continue block4;
                }
                case 6: {
                    Picture picture = (Picture)run.object;
                    int n3 = picture.width();
                    if (n3 <= n) continue block4;
                    n = n3;
                }
            }
        }
        if (this.properties != null) {
            n += this.properties.startIndent;
            n += this.properties.endIndent;
        }
        return n;
    }

    public static Paragraph empty() {
        return Paragraph.empty(0);
    }

    public static Paragraph empty(int n) {
        Paragraph paragraph = new Paragraph(new ParProperties());
        if (n > 0) {
            RunProperties runProperties = new RunProperties();
            runProperties.fontSize = n;
            paragraph.properties.markProperties = runProperties;
        }
        return paragraph;
    }

    public static class Run {
        public int type;
        public Object object;
        public boolean discard;

        Run(int n, Object object) {
            this.type = n;
            this.object = object;
        }
    }
}

