/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import com.xmlmind.fo.converter.rtf.ColorTable;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.util.Encoder;

public final class Rtf {
    public static final int CS_ANSI = 0;
    public static final int CS_SYMBOL = 2;
    public static final int CS_RUSSIAN = 204;
    public static final int CS_EASTERN_EUROPEAN = 238;
    public static final int UNIT_MILLIMETER = 1;
    public static final int UNIT_CENTIMETER = 2;
    public static final int UNIT_INCH = 3;
    public static final int UNIT_POINT = 4;

    public static int toTwips(double d, int n) {
        double d2;
        switch (n) {
            case 1: {
                d2 = d / 25.4 * 72.0;
                break;
            }
            case 2: {
                d2 = d / 2.54 * 72.0;
                break;
            }
            case 3: {
                d2 = d * 72.0;
                break;
            }
            default: {
                d2 = d;
            }
        }
        return Rtf.toTwips(d2);
    }

    public static int toTwips(double d) {
        return (int)Math.rint(20.0 * d);
    }

    public static String escape(String string) {
        return Rtf.escape(string, null);
    }

    public static String escape(String string, Encoder encoder) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        if (encoder != null) {
            block18: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\n': {
                        stringBuffer.append("\\line ");
                        continue block18;
                    }
                    case '\u00a0': {
                        stringBuffer.append("\\~");
                        continue block18;
                    }
                    case '\u00ad': {
                        stringBuffer.append("\\-");
                        continue block18;
                    }
                    case '\u2011': {
                        stringBuffer.append("\\_");
                        continue block18;
                    }
                    case '\\': {
                        stringBuffer.append("\\\\");
                        continue block18;
                    }
                    case '{': {
                        stringBuffer.append("\\{");
                        continue block18;
                    }
                    case '}': {
                        stringBuffer.append("\\}");
                        continue block18;
                    }
                    default: {
                        if (!encoder.canEncode(c)) {
                            stringBuffer.append("\\u" + Short.toString((short)c) + "?");
                            continue block18;
                        }
                        stringBuffer.append(c);
                    }
                }
            }
        } else {
            block19: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\n': {
                        stringBuffer.append("\\line ");
                        continue block19;
                    }
                    case '\u00a0': {
                        stringBuffer.append("\\~");
                        continue block19;
                    }
                    case '\u00ad': {
                        stringBuffer.append("\\-");
                        continue block19;
                    }
                    case '\u2011': {
                        stringBuffer.append("\\_");
                        continue block19;
                    }
                    case '\\': {
                        stringBuffer.append("\\\\");
                        continue block19;
                    }
                    case '{': {
                        stringBuffer.append("\\{");
                        continue block19;
                    }
                    case '}': {
                        stringBuffer.append("\\}");
                        continue block19;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    public static int toSymbolChar(char c) {
        switch (c) {
            case ' ': {
                return 32;
            }
            case '!': {
                return 33;
            }
            case '\u2200': {
                return 34;
            }
            case '#': {
                return 35;
            }
            case '\u2203': {
                return 36;
            }
            case '%': {
                return 37;
            }
            case '&': {
                return 38;
            }
            case '\u220d': {
                return 39;
            }
            case '(': {
                return 40;
            }
            case ')': {
                return 41;
            }
            case '\u2217': {
                return 42;
            }
            case '+': {
                return 43;
            }
            case ',': {
                return 44;
            }
            case '\u2012': 
            case '\u2013': 
            case '\u2014': 
            case '\u2212': {
                return 45;
            }
            case '.': {
                return 46;
            }
            case '/': {
                return 47;
            }
            case '0': {
                return 48;
            }
            case '1': {
                return 49;
            }
            case '2': {
                return 50;
            }
            case '3': {
                return 51;
            }
            case '4': {
                return 52;
            }
            case '5': {
                return 53;
            }
            case '6': {
                return 54;
            }
            case '7': {
                return 55;
            }
            case '8': {
                return 56;
            }
            case '9': {
                return 57;
            }
            case ':': {
                return 58;
            }
            case ';': {
                return 59;
            }
            case '<': {
                return 60;
            }
            case '=': {
                return 61;
            }
            case '>': {
                return 62;
            }
            case '?': {
                return 63;
            }
            case '\u2245': {
                return 64;
            }
            case '\u0391': {
                return 65;
            }
            case '\u0392': {
                return 66;
            }
            case '\u03a7': {
                return 67;
            }
            case '\u0394': {
                return 68;
            }
            case '\u0395': {
                return 69;
            }
            case '\u03a6': {
                return 70;
            }
            case '\u0393': {
                return 71;
            }
            case '\u0397': {
                return 72;
            }
            case '\u0399': {
                return 73;
            }
            case '\u03d1': {
                return 74;
            }
            case '\u039a': {
                return 75;
            }
            case '\u039b': {
                return 76;
            }
            case '\u039c': {
                return 77;
            }
            case '\u039d': {
                return 78;
            }
            case '\u039f': {
                return 79;
            }
            case '\u03a0': {
                return 80;
            }
            case '\u0398': {
                return 81;
            }
            case '\u03a1': {
                return 82;
            }
            case '\u03a3': {
                return 83;
            }
            case '\u03a4': {
                return 84;
            }
            case '\u03a5': {
                return 85;
            }
            case '\u03c2': {
                return 86;
            }
            case '\u03a9': {
                return 87;
            }
            case '\u039e': {
                return 88;
            }
            case '\u03a8': {
                return 89;
            }
            case '\u0396': {
                return 90;
            }
            case '[': {
                return 91;
            }
            case '\u2234': {
                return 92;
            }
            case ']': {
                return 93;
            }
            case '\u22a5': {
                return 94;
            }
            case '_': {
                return 95;
            }
            case '\uf8e5': {
                return 96;
            }
            case '\u03b1': {
                return 97;
            }
            case '\u03b2': {
                return 98;
            }
            case '\u03c7': {
                return 99;
            }
            case '\u03b4': {
                return 100;
            }
            case '\u03b5': {
                return 101;
            }
            case '\u03c6': {
                return 102;
            }
            case '\u03b3': {
                return 103;
            }
            case '\u03b7': {
                return 104;
            }
            case '\u03b9': {
                return 105;
            }
            case '\u03d5': {
                return 106;
            }
            case '\u03ba': {
                return 107;
            }
            case '\u03bb': {
                return 108;
            }
            case '\u03bc': {
                return 109;
            }
            case '\u03bd': {
                return 110;
            }
            case '\u03bf': {
                return 111;
            }
            case '\u03c0': {
                return 112;
            }
            case '\u03b8': {
                return 113;
            }
            case '\u03c1': {
                return 114;
            }
            case '\u03c3': {
                return 115;
            }
            case '\u03c4': {
                return 116;
            }
            case '\u03c5': {
                return 117;
            }
            case '\u03d6': {
                return 118;
            }
            case '\u03c9': {
                return 119;
            }
            case '\u03be': {
                return 120;
            }
            case '\u03c8': {
                return 121;
            }
            case '\u03b6': {
                return 122;
            }
            case '{': {
                return 123;
            }
            case '|': {
                return 124;
            }
            case '}': {
                return 125;
            }
            case '\u223c': {
                return 126;
            }
            case '\u20ac': {
                return 160;
            }
            case '\u03d2': {
                return 161;
            }
            case '\u2032': {
                return 162;
            }
            case '\u2264': {
                return 163;
            }
            case '\u2044': {
                return 164;
            }
            case '\u221e': {
                return 165;
            }
            case '\u0192': {
                return 166;
            }
            case '\u2663': {
                return 167;
            }
            case '\u2666': {
                return 168;
            }
            case '\u2665': {
                return 169;
            }
            case '\u2660': {
                return 170;
            }
            case '\u2194': {
                return 171;
            }
            case '\u2190': {
                return 172;
            }
            case '\u2191': {
                return 173;
            }
            case '\u2192': {
                return 174;
            }
            case '\u2193': {
                return 175;
            }
            case '\u00b0': {
                return 176;
            }
            case '\u00b1': {
                return 177;
            }
            case '\u2033': {
                return 178;
            }
            case '\u2265': {
                return 179;
            }
            case '\u00d7': {
                return 180;
            }
            case '\u221d': {
                return 181;
            }
            case '\u2202': {
                return 182;
            }
            case '\u2022': {
                return 183;
            }
            case '\u00f7': {
                return 184;
            }
            case '\u2260': {
                return 185;
            }
            case '\u2261': {
                return 186;
            }
            case '\u2248': {
                return 187;
            }
            case '\u2026': {
                return 188;
            }
            case '\u23d0': {
                return 189;
            }
            case '\u23af': {
                return 190;
            }
            case '\u21b5': {
                return 191;
            }
            case '\u2135': {
                return 192;
            }
            case '\u2111': {
                return 193;
            }
            case '\u211c': {
                return 194;
            }
            case '\u2118': {
                return 195;
            }
            case '\u2297': {
                return 196;
            }
            case '\u2295': {
                return 197;
            }
            case '\u2205': {
                return 198;
            }
            case '\u2229': {
                return 199;
            }
            case '\u222a': {
                return 200;
            }
            case '\u2283': {
                return 201;
            }
            case '\u2287': {
                return 202;
            }
            case '\u2284': {
                return 203;
            }
            case '\u2282': {
                return 204;
            }
            case '\u2286': {
                return 205;
            }
            case '\u2208': {
                return 206;
            }
            case '\u2209': {
                return 207;
            }
            case '\u2220': {
                return 208;
            }
            case '\u2207': {
                return 209;
            }
            case '\u00ae': {
                return 210;
            }
            case '\u00a9': {
                return 211;
            }
            case '\u2122': {
                return 212;
            }
            case '\u220f': {
                return 213;
            }
            case '\u221a': {
                return 214;
            }
            case '\u22c5': {
                return 215;
            }
            case '\u00ac': {
                return 216;
            }
            case '\u2227': {
                return 217;
            }
            case '\u2228': {
                return 218;
            }
            case '\u21d4': {
                return 219;
            }
            case '\u21d0': {
                return 220;
            }
            case '\u21d1': {
                return 221;
            }
            case '\u21d2': {
                return 222;
            }
            case '\u21d3': {
                return 223;
            }
            case '\u22c4': {
                return 224;
            }
            case '\u3008': {
                return 225;
            }
            case '\u2211': {
                return 229;
            }
            case '\u239b': {
                return 230;
            }
            case '\u239c': {
                return 231;
            }
            case '\u239d': {
                return 232;
            }
            case '\u23a1': {
                return 233;
            }
            case '\u23a2': {
                return 234;
            }
            case '\u23a3': {
                return 235;
            }
            case '\u23a7': {
                return 236;
            }
            case '\u23a8': {
                return 237;
            }
            case '\u23a9': {
                return 238;
            }
            case '\u23aa': {
                return 239;
            }
            case '\uf8ff': {
                return 240;
            }
            case '\u3009': {
                return 241;
            }
            case '\u222b': {
                return 242;
            }
            case '\u2320': {
                return 243;
            }
            case '\u23ae': {
                return 244;
            }
            case '\u2321': {
                return 245;
            }
            case '\u239e': {
                return 246;
            }
            case '\u239f': {
                return 247;
            }
            case '\u23a0': {
                return 248;
            }
            case '\u23a4': {
                return 249;
            }
            case '\u23a5': {
                return 250;
            }
            case '\u23a6': {
                return 251;
            }
            case '\u23ab': {
                return 252;
            }
            case '\u23ac': {
                return 253;
            }
            case '\u23ad': {
                return 254;
            }
        }
        return -1;
    }

    public static int colorIndex(Color color, ColorTable colorTable) {
        int n = -1;
        if (color != null && (n = color.name != null ? colorTable.index(color.name) : colorTable.index(color.red, color.green, color.blue)) < 0) {
            n = colorTable.add(color.red, color.green, color.blue);
        }
        return n;
    }
}

