/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.rtf.Border;
import com.xmlmind.fo.converter.rtf.Borders;
import com.xmlmind.fo.converter.rtf.ColorTable;
import com.xmlmind.fo.converter.rtf.FontTable;
import com.xmlmind.fo.converter.rtf.Rtf;
import com.xmlmind.fo.font.Font;
import com.xmlmind.fo.font.FontCache;
import com.xmlmind.fo.objects.Fo;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public class RunProperties
implements Cloneable {
    public FontTable.Font font;
    public int fontIndex;
    public int fontSize;
    public boolean bold;
    public boolean italic;
    public boolean underline;
    public boolean strikeThrough;
    public boolean smallCaps;
    public boolean subscript;
    public boolean superscript;
    public int baselineShift;
    public int alignmentBaseline;
    public int fgColor;
    public int bgColor;
    public int ulColor;
    public Border border;
    public boolean preserveSpace;

    public RunProperties() {
    }

    public RunProperties(Context context, FontTable fontTable, ColorTable colorTable) {
        this();
        this.initialize(context, fontTable, colorTable);
    }

    public void initialize(Context context, FontTable fontTable, ColorTable colorTable) {
        int n;
        int n2;
        int n3;
        Value[] valueArray = context.properties.values;
        Value[] valueArray2 = valueArray[104].list();
        String string = valueArray2[0].string();
        this.fontIndex = fontTable.index(string);
        if (this.fontIndex < 0) {
            this.fontIndex = fontTable.add(string);
        }
        this.font = fontTable.font(this.fontIndex);
        double d = valueArray[106].length();
        this.fontSize = (int)Math.round(2.0 * d);
        int n4 = valueArray[111].integer();
        if (n4 >= 700) {
            this.bold = true;
        }
        if ((n3 = valueArray[109].keyword()) == 92 || n3 == 139) {
            this.italic = true;
        }
        if ((n2 = valueArray[110].keyword()) == 184) {
            this.smallCaps = true;
        }
        this.underline = context.textDecoration.underline;
        this.strikeThrough = context.textDecoration.lineThrough;
        Value value = valueArray[14];
        if (value.type == 1) {
            switch (value.keyword()) {
                case 193: {
                    this.subscript = true;
                    break;
                }
                case 194: {
                    this.superscript = true;
                }
            }
        } else {
            n = (int)Math.round(2.0 * value.length());
            if (n < 0) {
                this.subscript = true;
            } else if (n > 0) {
                this.superscript = true;
            }
            this.baselineShift = Math.abs(n);
        }
        this.alignmentBaseline = valueArray[3].keyword();
        this.fgColor = Rtf.colorIndex(valueArray[78].color(), colorTable);
        if (context.background != null) {
            this.bgColor = Rtf.colorIndex(context.background, colorTable);
        }
        if (context.textDecoration.color != null) {
            this.ulColor = Rtf.colorIndex(context.textDecoration.color, colorTable);
        }
        if (Fo.isInline(context.fo)) {
            Borders borders = new Borders(valueArray, colorTable);
            if (borders.top.materialized() && borders.bottom.materialized() && borders.left.materialized() && borders.right.materialized()) {
                this.border = new Border(5);
                this.border.set(borders.top.style, borders.top.width, borders.top.color, borders.top.space);
            }
        }
        if ((n = valueArray[306].keyword()) == 152) {
            this.preserveSpace = true;
        }
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("\\plain");
        if (this.fontIndex >= 0) {
            printWriter.print("\\f" + this.fontIndex);
        }
        printWriter.print("\\fs" + this.fontSize);
        if (this.bold) {
            printWriter.print("\\b");
        }
        if (this.italic) {
            printWriter.print("\\i");
        }
        if (this.underline) {
            printWriter.print("\\ul");
        }
        if (this.strikeThrough) {
            printWriter.print("\\strike");
        }
        if (this.smallCaps) {
            printWriter.print("\\scaps");
        }
        if (this.subscript) {
            printWriter.print("\\sub");
            if (this.baselineShift > 0) {
                printWriter.print("\\dn" + this.baselineShift);
            }
        } else if (this.superscript) {
            printWriter.print("\\super");
            if (this.baselineShift > 0) {
                printWriter.print("\\up" + this.baselineShift);
            }
        }
        if (this.fgColor > 0) {
            printWriter.print("\\cf" + this.fgColor);
        }
        if (this.bgColor > 0) {
            printWriter.print("\\chcbpat" + this.bgColor);
        }
        if (this.ulColor > 0) {
            printWriter.print("\\ulc" + this.ulColor);
        }
        if (this.border != null) {
            this.border.print(printWriter);
        }
    }

    public Font font() {
        int n = -1;
        if ("roman".equals(this.font.family)) {
            n = 1;
        } else if ("swiss".equals(this.font.family)) {
            n = 2;
        } else if ("modern".equals(this.font.family)) {
            n = 3;
        } else if ("decor".equals(this.font.family)) {
            n = 4;
        } else if ("script".equals(this.font.family)) {
            n = 5;
        }
        int n2 = 0;
        if (this.bold) {
            n2 |= 1;
        }
        if (this.italic) {
            n2 |= 2;
        }
        int n3 = this.fontSize / 2;
        if (n < 0) {
            return FontCache.getFont(this.font.name, n2, n3);
        }
        return FontCache.getFont(n, n2, n3);
    }

    public RunProperties copy() {
        RunProperties runProperties = null;
        try {
            runProperties = (RunProperties)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return runProperties;
    }
}

