/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import com.xmlmind.fo.converter.rtf.Borders;
import com.xmlmind.fo.converter.rtf.ColorTable;
import com.xmlmind.fo.converter.rtf.Footer;
import com.xmlmind.fo.converter.rtf.Header;
import com.xmlmind.fo.converter.rtf.Rtf;
import com.xmlmind.fo.objects.PageSequence;
import com.xmlmind.fo.objects.Region;
import com.xmlmind.fo.objects.SimplePageMaster;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;

public class Section {
    public static final String FORMAT_DECIMAL = "dec";
    public static final String FORMAT_LOWERCASE_LETTER = "lcltr";
    public static final String FORMAT_UPPERCASE_LETTER = "ucltr";
    public static final String FORMAT_LOWERCASE_ROMAN = "lcrm";
    public static final String FORMAT_UPPERCASE_ROMAN = "ucrm";
    public int pageWidth;
    public int pageHeight;
    public int marginTop;
    public int marginBottom;
    public int marginLeft;
    public int marginRight;
    public int headerOffset;
    public int footerOffset;
    public int columnCount;
    public int columnGap;
    public int columnWidth;
    public int contentWidth;
    public Borders borders;
    public boolean titlePage;
    public boolean mirrorMargins;
    public int startPageNumber;
    public String numberFormat;
    public Header headerOdd;
    public Header headerEven;
    public Header headerFirst;
    public Footer footerOdd;
    public Footer footerEven;
    public Footer footerFirst;

    public Section() {
    }

    public Section(SimplePageMaster simplePageMaster, SimplePageMaster simplePageMaster2, SimplePageMaster simplePageMaster3, PageSequence pageSequence, ColorTable colorTable) {
        this();
        this.initialize(simplePageMaster, simplePageMaster2, simplePageMaster3, pageSequence, colorTable);
    }

    public void initialize(SimplePageMaster simplePageMaster, SimplePageMaster simplePageMaster2, SimplePageMaster simplePageMaster3, PageSequence pageSequence, ColorTable colorTable) {
        int n;
        int n2;
        char c = '1';
        Region region = simplePageMaster.regions[0];
        if (simplePageMaster.pageWidth.type == 4) {
            this.pageWidth = Rtf.toTwips(simplePageMaster.pageWidth.length());
        }
        if (simplePageMaster.pageHeight.type == 4) {
            this.pageHeight = Rtf.toTwips(simplePageMaster.pageHeight.length());
        }
        this.marginTop = Section.length(simplePageMaster.marginTop);
        this.marginBottom = Section.length(simplePageMaster.marginBottom);
        this.marginLeft = Section.length(simplePageMaster.marginLeft);
        this.marginRight = Section.length(simplePageMaster.marginRight);
        this.headerOffset = this.marginTop;
        this.footerOffset = this.marginBottom;
        this.marginTop += Section.length(region.marginTop);
        this.marginBottom += Section.length(region.marginBottom);
        this.marginLeft += Section.length(region.marginLeft);
        this.marginRight += Section.length(region.marginRight);
        this.marginTop += Section.length(region.paddingTop);
        this.marginBottom += Section.length(region.paddingBottom);
        this.marginLeft += Section.length(region.paddingLeft);
        this.marginRight += Section.length(region.paddingRight);
        this.contentWidth = this.pageWidth - (this.marginLeft + this.marginRight);
        this.columnCount = region.columnCount;
        this.columnGap = Section.length(region.columnGap);
        this.columnWidth = this.contentWidth;
        if (this.columnCount > 1) {
            this.columnWidth -= (this.columnCount - 1) * this.columnGap;
            this.columnWidth /= this.columnCount;
        }
        this.borders = new Borders(3);
        this.borders.initialize(region.properties, colorTable);
        if (simplePageMaster2 != null) {
            n2 = Section.length(simplePageMaster2.marginLeft);
            n = Section.length(simplePageMaster2.marginRight);
            region = simplePageMaster2.regions[0];
            n2 += Section.length(region.marginLeft);
            n += Section.length(region.marginRight);
            if ((n2 += Section.length(region.paddingLeft)) == this.marginRight && (n += Section.length(region.paddingRight)) == this.marginLeft) {
                this.mirrorMargins = true;
            }
        }
        if (simplePageMaster3 != null) {
            this.titlePage = true;
        }
        if (pageSequence.initialPageNumber > 0) {
            this.startPageNumber = pageSequence.initialPageNumber;
        }
        n = pageSequence.format.length();
        for (n2 = 0; n2 < n && !Character.isLetterOrDigit(c = (char)pageSequence.format.charAt(n2)); ++n2) {
        }
        switch (c) {
            default: {
                this.numberFormat = FORMAT_DECIMAL;
                break;
            }
            case 'a': {
                this.numberFormat = FORMAT_LOWERCASE_LETTER;
                break;
            }
            case 'A': {
                this.numberFormat = FORMAT_UPPERCASE_LETTER;
                break;
            }
            case 'i': {
                this.numberFormat = FORMAT_LOWERCASE_ROMAN;
                break;
            }
            case 'I': {
                this.numberFormat = FORMAT_UPPERCASE_ROMAN;
            }
        }
    }

    public void start(PrintWriter printWriter, Encoder encoder, int n) throws Exception {
        printWriter.println("\\sectd");
        printWriter.println("\\pghsxn" + this.pageHeight + "\\pgwsxn" + this.pageWidth);
        if (this.pageWidth > this.pageHeight) {
            printWriter.println("\\lndscpsxn");
        }
        printWriter.print("\\margtsxn" + this.marginTop + "\\margbsxn" + this.marginBottom);
        printWriter.println("\\marglsxn" + this.marginLeft + "\\margrsxn" + this.marginRight);
        if (this.mirrorMargins) {
            printWriter.println("\\margmirsxn");
        }
        if (this.headerOffset > 0) {
            printWriter.println("\\headery" + this.headerOffset);
        }
        if (this.footerOffset > 0) {
            printWriter.println("\\footery" + this.footerOffset);
        }
        if (this.titlePage) {
            printWriter.println("\\titlepg");
        }
        if (this.columnCount > 1) {
            printWriter.println("\\cols" + this.columnCount + "\\colsx" + this.columnGap);
        }
        if (this.borders.materialized()) {
            this.borders.print(printWriter);
            printWriter.println();
        }
        if (this.startPageNumber > 0) {
            printWriter.print("\\pgnrestart\\pgnstarts" + this.startPageNumber);
        } else {
            printWriter.print("\\pgncont");
        }
        printWriter.println("\\pgn" + this.numberFormat);
        if (this.headerOdd != null) {
            this.headerOdd.print(printWriter, encoder, n);
        }
        if (this.headerEven != null) {
            this.headerEven.print(printWriter, encoder, n);
        }
        if (this.headerFirst != null) {
            this.headerFirst.print(printWriter, encoder, n);
        }
        if (this.footerOdd != null) {
            this.footerOdd.print(printWriter, encoder, n);
        }
        if (this.footerEven != null) {
            this.footerEven.print(printWriter, encoder, n);
        }
        if (this.footerFirst != null) {
            this.footerFirst.print(printWriter, encoder, n);
        }
    }

    public void end(PrintWriter printWriter) {
        printWriter.println("\\pard\\sect");
    }

    private static int length(Value value) {
        int n = 0;
        if (value.type == 4) {
            n = Rtf.toTwips(value.length());
        }
        return n;
    }
}

