/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.rtf.Borders;
import com.xmlmind.fo.converter.rtf.Caption;
import com.xmlmind.fo.converter.rtf.ColorTable;
import com.xmlmind.fo.converter.rtf.ParProperties;
import com.xmlmind.fo.converter.rtf.Paragraph;
import com.xmlmind.fo.converter.rtf.Rtf;
import com.xmlmind.fo.converter.rtf.RunProperties;
import com.xmlmind.fo.converter.rtf.Table;
import com.xmlmind.fo.converter.rtf.TableAndCaption;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public final class TableCell
implements Cloneable {
    public static final int ALIGNMENT_TOP = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_BOTTOM = 2;
    public static final int MERGE_NONE = 0;
    public static final int MERGE_START = 1;
    public static final int MERGE_CONTINUE = 2;
    public int columnNumber;
    public int columnSpan = 1;
    public int rowSpan = 1;
    public boolean startsRow;
    public boolean endsRow;
    public int width;
    public double percentage;
    public int alignment = 0;
    public Borders borders;
    public int background;
    public int fontSize;
    public int paddingTop;
    public int paddingBottom;
    public int paddingLeft;
    public int paddingRight;
    public int hMerge = 0;
    public int vMerge = 0;
    public int boundary;
    public boolean isNested;
    public int nestingLevel;
    private Vector elements = new Vector();
    private boolean requiresLayout;

    public TableCell() {
    }

    public TableCell(Context context, ColorTable colorTable) {
        this();
        this.initialize(context, colorTable);
    }

    public void initialize(Context context, ColorTable colorTable) {
        Value[] valueArray = context.properties.values;
        this.columnNumber = TableCell.number(valueArray[82]);
        this.columnSpan = TableCell.number(valueArray[187]);
        this.rowSpan = TableCell.number(valueArray[188]);
        if (valueArray[279].keyword() == 209) {
            this.startsRow = true;
        }
        if (valueArray[98].keyword() == 209) {
            this.endsRow = true;
        }
        Value value = valueArray[308];
        switch (value.type) {
            case 4: {
                this.width = Rtf.toTwips(value.length());
                break;
            }
            case 13: {
                this.percentage = value.percentage();
            }
        }
        switch (valueArray[93].keyword()) {
            default: {
                this.alignment = 0;
                break;
            }
            case 31: {
                this.alignment = 1;
                break;
            }
            case 4: {
                this.alignment = 2;
            }
        }
        this.borders = new Borders(2);
        this.borders.initialize(valueArray, colorTable);
        this.paddingTop = this.borders.top.space;
        this.borders.top.space = 0;
        this.paddingBottom = this.borders.bottom.space;
        this.borders.bottom.space = 0;
        this.paddingLeft = this.borders.left.space;
        this.borders.left.space = 0;
        this.paddingRight = this.borders.right.space;
        this.borders.right.space = 0;
        Value value2 = valueArray[8];
        if (value2.type == 24) {
            this.background = Rtf.colorIndex(value2.color(), colorTable);
        }
        double d = valueArray[106].length();
        this.fontSize = (int)Math.round(2.0 * d);
    }

    public void setReference(int n) {
        if (this.percentage > 0.0) {
            this.width = (int)((double)n * this.percentage / 100.0);
        }
    }

    private static int number(Value value) {
        int n = (int)Math.round(value.number());
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    public void add(Paragraph paragraph) {
        if (paragraph.properties == null) {
            paragraph.properties = new ParProperties();
        }
        paragraph.properties.isInTable = true;
        paragraph.properties.nestingLevel = this.nestingLevel;
        this.elements.addElement(new Element(1, paragraph));
        if (paragraph.hasPicture) {
            this.requiresLayout = true;
        }
    }

    public void add(Table table) {
        this.elements.addElement(new Element(2, table));
        this.requiresLayout = true;
    }

    public void add(TableAndCaption tableAndCaption) {
        this.elements.addElement(new Element(3, tableAndCaption));
        this.requiresLayout = true;
    }

    public boolean isEmpty() {
        return this.elements.size() == 0;
    }

    public void close() {
        if (this.isEmpty()) {
            Paragraph paragraph = Paragraph.empty();
            paragraph.isLast = true;
            this.add(paragraph);
        } else {
            Element element = (Element)this.elements.lastElement();
            switch (element.type) {
                case 1: {
                    Paragraph paragraph = (Paragraph)element.object;
                    paragraph.isLast = true;
                    break;
                }
                case 2: {
                    Paragraph paragraph = Paragraph.empty();
                    paragraph.isLast = true;
                    this.add(paragraph);
                    break;
                }
                case 3: {
                    Paragraph paragraph;
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    Caption caption = tableAndCaption.caption;
                    if (caption != null && caption.side == 2 && (paragraph = caption.lastParagraph()) != null) {
                        paragraph.isLast = true;
                        break;
                    }
                    Paragraph paragraph2 = Paragraph.empty();
                    paragraph2.isLast = true;
                    this.add(paragraph2);
                }
            }
        }
    }

    public void keepWithNext() {
        if (this.isEmpty()) {
            Paragraph paragraph = Paragraph.empty();
            paragraph.properties.keepWithNext = true;
            this.add(paragraph);
            return;
        }
        Element element = (Element)this.elements.elementAt(0);
        switch (element.type) {
            case 1: {
                Paragraph paragraph = (Paragraph)element.object;
                paragraph.properties.keepWithNext = true;
            }
        }
    }

    public void breakBefore(int n) {
        if (this.isEmpty()) {
            Paragraph paragraph = Paragraph.empty();
            paragraph.properties.breakBefore = n;
            this.add(paragraph);
            return;
        }
        Element element = (Element)this.elements.elementAt(0);
        switch (element.type) {
            case 1: {
                Paragraph paragraph = (Paragraph)element.object;
                paragraph.properties.breakBefore = n;
            }
        }
    }

    public Paragraph lastParagraph() {
        Paragraph paragraph = null;
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            Object object;
            Element element = (Element)this.elements.elementAt(i);
            if (element.type == 1) {
                object = (Paragraph)element.object;
                if (((Paragraph)object).isVoid()) continue;
                paragraph = object;
                break;
            }
            if (element.type != 3) break;
            object = (TableAndCaption)element.object;
            Caption caption = ((TableAndCaption)object).caption;
            if (caption == null || caption.side != 2) break;
            paragraph = caption.lastParagraph();
            break;
        }
        return paragraph;
    }

    public boolean requiresLayout() {
        return this.requiresLayout;
    }

    public void layout(int n) throws Exception {
        if (!this.requiresLayout) {
            return;
        }
        int n2 = this.elements.size();
        block5: for (int i = 0; i < n2; ++i) {
            Element element = (Element)this.elements.elementAt(i);
            switch (element.type) {
                case 1: {
                    Paragraph paragraph = (Paragraph)element.object;
                    if (!paragraph.hasPicture) continue block5;
                    paragraph.layout(n);
                    continue block5;
                }
                case 2: {
                    Table table = (Table)element.object;
                    table.layout(n);
                    continue block5;
                }
                case 3: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    tableAndCaption.layout(n);
                }
            }
        }
    }

    void printDefinition(PrintWriter printWriter, int n) {
        int n2 = this.paddingTop;
        int n3 = this.paddingLeft;
        switch (this.hMerge) {
            case 1: {
                printWriter.println("\\clmgf");
                break;
            }
            case 2: {
                printWriter.println("\\clmrg");
            }
        }
        switch (this.vMerge) {
            case 1: {
                printWriter.println("\\clvmgf");
                break;
            }
            case 2: {
                printWriter.println("\\clvmrg");
            }
        }
        if (n == 1) {
            n2 = this.paddingLeft;
            n3 = this.paddingTop;
        }
        if (n2 > 0) {
            printWriter.println("\\clpadft3\\clpadt" + n2);
        }
        if (this.paddingBottom > 0) {
            printWriter.println("\\clpadfb3\\clpadb" + this.paddingBottom);
        }
        if (n3 > 0) {
            printWriter.println("\\clpadfl3\\clpadl" + n3);
        }
        if (this.paddingRight > 0) {
            printWriter.println("\\clpadfr3\\clpadr" + this.paddingRight);
        }
        switch (this.alignment) {
            case 0: {
                printWriter.println("\\clvertalt");
                break;
            }
            case 1: {
                printWriter.println("\\clvertalc");
                break;
            }
            case 2: {
                printWriter.println("\\clvertalb");
            }
        }
        if (this.background > 0) {
            printWriter.println("\\clcbpat" + this.background);
        }
        if (this.borders != null && this.borders.materialized()) {
            this.borders.print(printWriter);
        }
        printWriter.println("\\cellx" + this.boundary);
    }

    void printContent(PrintWriter printWriter, Encoder encoder, int n) throws Exception {
        Object object;
        Element element;
        int n2;
        if (this.isEmpty()) {
            this.close();
        }
        if ((n2 = this.elements.size()) == 1) {
            Paragraph paragraph;
            element = (Element)this.elements.elementAt(0);
            if (element.type == 1 && (paragraph = (Paragraph)element.object).isVoid()) {
                object = new RunProperties();
                ((RunProperties)object).fontSize = this.fontSize;
                paragraph.properties.markProperties = object;
            }
        }
        block5: for (int i = 0; i < n2; ++i) {
            element = (Element)this.elements.elementAt(i);
            switch (element.type) {
                case 1: {
                    object = (Paragraph)element.object;
                    ((Paragraph)object).print(printWriter, encoder);
                    continue block5;
                }
                case 2: {
                    Table table = (Table)element.object;
                    table.print(printWriter, encoder, n);
                    continue block5;
                }
                case 3: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    tableAndCaption.print(printWriter, encoder, n);
                }
            }
        }
        if (this.isNested) {
            printWriter.println("\\nestcell");
        } else {
            printWriter.println("\\cell");
        }
    }

    public int maxWidth() {
        int n = 0;
        int n2 = this.elements.size();
        block5: for (int i = 0; i < n2; ++i) {
            Element element = (Element)this.elements.elementAt(i);
            switch (element.type) {
                case 1: {
                    Paragraph paragraph = (Paragraph)element.object;
                    int n3 = paragraph.maxWidth();
                    if (n3 <= n) continue block5;
                    n = n3;
                    continue block5;
                }
                case 2: {
                    Table table = (Table)element.object;
                    int n3 = table.maxWidth();
                    if (n3 <= n) continue block5;
                    n = n3;
                    continue block5;
                }
                case 3: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    int n3 = tableAndCaption.maxWidth();
                    if (n3 <= n) continue block5;
                    n = n3;
                }
            }
        }
        n += this.paddingLeft;
        n += this.paddingRight;
        if (this.width > (n += 28)) {
            n = this.width;
        }
        return n;
    }

    public int minWidth() {
        int n = 0;
        int n2 = this.elements.size();
        block5: for (int i = 0; i < n2; ++i) {
            Element element = (Element)this.elements.elementAt(i);
            switch (element.type) {
                case 1: {
                    Paragraph paragraph = (Paragraph)element.object;
                    int n3 = paragraph.minWidth();
                    if (n3 <= n) continue block5;
                    n = n3;
                    continue block5;
                }
                case 2: {
                    Table table = (Table)element.object;
                    int n3 = table.minWidth();
                    if (n3 <= n) continue block5;
                    n = n3;
                    continue block5;
                }
                case 3: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    int n3 = tableAndCaption.minWidth();
                    if (n3 <= n) continue block5;
                    n = n3;
                }
            }
        }
        n += this.paddingLeft;
        n += this.paddingRight;
        if (this.width > (n += 28)) {
            n = this.width;
        }
        return n;
    }

    public TableCell copy() {
        TableCell tableCell = null;
        try {
            tableCell = (TableCell)this.clone();
            if (this.borders != null) {
                tableCell.borders = this.borders.copy();
            }
            tableCell.elements = new Vector();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return tableCell;
    }

    private class Element {
        static final int TYPE_PARAGRAPH = 1;
        static final int TYPE_TABLE = 2;
        static final int TYPE_TABLE_AND_CAPTION = 3;
        int type;
        Object object;

        Element(int n, Object object) {
            this.type = n;
            this.object = object;
        }
    }
}

