/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.rtf.Bookmark;
import com.xmlmind.fo.converter.rtf.Borders;
import com.xmlmind.fo.converter.rtf.ColorTable;
import com.xmlmind.fo.converter.rtf.Rtf;
import com.xmlmind.fo.converter.rtf.TableCell;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public final class TableRow {
    public int breakBefore = 0;
    public int breakAfter = 0;
    public boolean keepTogether;
    public boolean keepWithNext;
    public boolean keepWithPrevious;
    public int height;
    public Borders borders;
    public int background;
    public Bookmark[] bookmarks;
    public int indent;
    public int rowSpacing;
    public int columnSpacing;
    public boolean isHeaderRow;
    public boolean isNested;
    public int nestingLevel;
    public Vector cells = new Vector();

    public TableRow() {
    }

    public TableRow(Context context, ColorTable colorTable) {
        this();
        this.initialize(context, colorTable);
    }

    public void initialize(Context context, ColorTable colorTable) {
        Value[] valueArray = context.properties.values;
        this.breakBefore = context.properties.breakBefore();
        this.breakAfter = context.properties.breakAfter();
        this.keepTogether = TableRow.keep(valueArray[137]);
        this.keepWithNext = TableRow.keep(valueArray[141]);
        this.keepWithPrevious = TableRow.keep(valueArray[145]);
        Value value = valueArray[118];
        if (value.type == 4) {
            this.height = Rtf.toTwips(value.length());
        }
        this.borders = new Borders(1);
        this.borders.initialize(valueArray, colorTable);
        value = valueArray[8];
        if (value.type == 24) {
            this.background = Rtf.colorIndex(value.color(), colorTable);
        }
    }

    private static boolean keep(Value value) {
        boolean bl = false;
        switch (value.type) {
            case 1: {
                if (value.keyword() != 8) break;
                bl = true;
                break;
            }
            case 2: {
                if (value.integer() <= 0) break;
                bl = true;
            }
        }
        return bl;
    }

    public void add(TableCell tableCell) {
        if (this.isNested) {
            tableCell.isNested = true;
            tableCell.nestingLevel = this.nestingLevel;
        }
        this.cells.addElement(tableCell);
    }

    public int size() {
        return this.cells.size();
    }

    public TableCell get(int n) {
        return (TableCell)this.cells.elementAt(n);
    }

    void print(PrintWriter printWriter, Encoder encoder, int n) throws Exception {
        int n2;
        if (this.bookmarks != null) {
            for (n2 = 0; n2 < this.bookmarks.length; ++n2) {
                this.bookmarks[n2].start(printWriter, encoder);
            }
        }
        if (!this.isNested) {
            this.printDefinition(printWriter, n);
        }
        int n3 = this.cells.size();
        for (n2 = 0; n2 < n3; ++n2) {
            TableCell tableCell = (TableCell)this.cells.elementAt(n2);
            tableCell.printContent(printWriter, encoder, n);
        }
        if (this.isNested) {
            printWriter.println("{\\*\\nesttableprops");
            this.printDefinition(printWriter, n);
            printWriter.println("\\nestrow}");
        } else {
            printWriter.println("\\row");
        }
        if (this.bookmarks != null) {
            for (n2 = this.bookmarks.length - 1; n2 >= 0; --n2) {
                this.bookmarks[n2].end(printWriter, encoder);
            }
        }
    }

    private void printDefinition(PrintWriter printWriter, int n) {
        int n2;
        printWriter.print("\\trowd");
        printWriter.print("\\trleft" + this.indent);
        if (this.height > 0) {
            printWriter.print("\\trrh" + this.height);
        }
        if (this.isHeaderRow) {
            printWriter.print("\\trhdr");
        }
        if (this.keepTogether) {
            printWriter.print("\\trkeep");
        }
        if (this.keepWithNext) {
            printWriter.print("\\trkeepfollow");
        }
        printWriter.println();
        if (this.borders != null && this.borders.materialized()) {
            this.borders.print(printWriter);
        }
        if (this.rowSpacing > 0) {
            n2 = this.rowSpacing / 2;
            printWriter.print("\\trspdft3\\trspdt" + n2);
            printWriter.println("\\trspdfb3\\trspdb" + n2);
        }
        if (this.columnSpacing > 0) {
            n2 = this.columnSpacing / 2;
            printWriter.print("\\trspdfl3\\trspdl" + n2);
            printWriter.println("\\trspdfr3\\trspdr" + n2);
        }
        int n3 = this.cells.size();
        for (n2 = 0; n2 < n3; ++n2) {
            TableCell tableCell = (TableCell)this.cells.elementAt(n2);
            tableCell.printDefinition(printWriter, n);
        }
    }
}

