/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import com.xmlmind.fo.converter.rtf.Footnote;
import com.xmlmind.fo.converter.rtf.Rtf;
import com.xmlmind.fo.converter.rtf.RunProperties;
import com.xmlmind.fo.font.Font;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public final class Text {
    public String text;
    public RunProperties properties;
    public Footnote footnote;

    public Text() {
        this("");
    }

    public Text(String string) {
        this(string, null);
    }

    public Text(String string, RunProperties runProperties) {
        this.text = string;
        this.properties = runProperties;
    }

    public boolean isVoid() {
        return this.text.length() == 0 && this.footnote == null;
    }

    public boolean isSpace() {
        int n = this.text.length();
        for (int i = 0; i < n; ++i) {
            if (this.text.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public boolean preserveSpace() {
        return this.properties != null && this.properties.preserveSpace;
    }

    public void trimLeft() {
        int n = this.text.length();
        if (n == 0 || this.text.charAt(0) != ' ' || this.preserveSpace()) {
            return;
        }
        for (int i = 1; i < n; ++i) {
            if (this.text.charAt(i) == ' ') continue;
            this.text = this.text.substring(i);
            return;
        }
        this.text = "";
    }

    public void trimRight() {
        int n = this.text.length();
        if (n == 0 || this.text.charAt(n - 1) != ' ' || this.preserveSpace()) {
            return;
        }
        for (int i = n - 2; i >= 0; --i) {
            if (this.text.charAt(i) == ' ') continue;
            this.text = this.text.substring(0, i + 1);
            return;
        }
        this.text = "";
    }

    public void print(PrintWriter printWriter) throws Exception {
        this.print(printWriter, null);
    }

    public void print(PrintWriter printWriter, Encoder encoder) throws Exception {
        printWriter.print("{");
        if (this.properties != null) {
            this.properties.print(printWriter);
        }
        printWriter.println();
        printWriter.println(Rtf.escape(this.text, encoder));
        if (this.footnote != null) {
            this.footnote.print(printWriter, encoder);
        }
        printWriter.println("}");
    }

    public int textWidth() {
        Font font = null;
        if (this.properties != null) {
            font = this.properties.font();
        }
        int n = font != null ? font.getTextExtents((String)this.text).width : this.text.length() * this.charWidth();
        return n;
    }

    public int wordWidth() {
        Font font = null;
        if (this.properties != null) {
            font = this.properties.font();
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(this.text);
        if (font != null) {
            while (stringTokenizer.hasMoreTokens()) {
                int n2 = font.getTextExtents((String)stringTokenizer.nextToken()).width;
                if (n2 <= n) continue;
                n = n2;
            }
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                int n3 = stringTokenizer.nextToken().length();
                if (n3 <= n) continue;
                n = n3;
            }
            n *= this.charWidth();
        }
        return n;
    }

    private int charWidth() {
        int n = 24;
        if (this.properties != null) {
            n = this.properties.fontSize;
        }
        int n2 = 3 * n / 4;
        return 10 * n2;
    }
}

