/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.wml;

import com.xmlmind.fo.converter.wml.Wml;
import com.xmlmind.fo.properties.Color;
import java.io.PrintWriter;

public final class Border
implements Cloneable {
    public static final String SIDE_TOP = "top";
    public static final String SIDE_BOTTOM = "bottom";
    public static final String SIDE_LEFT = "left";
    public static final String SIDE_RIGHT = "right";
    public static final String SIDE_ALL = "bdr";
    public String side;
    public int style;
    public int width;
    public Color color;
    public int space;

    public Border(String string) {
        this(string, 125, 0, null, 0);
    }

    public Border(String string, int n, int n2, Color color, int n3) {
        this.side = string;
        this.set(n, n2, color, n3);
    }

    public void set(int n, int n2, Color color, int n3) {
        this.style = n;
        this.width = n2;
        this.color = color;
        this.space = n3;
    }

    public boolean materialized() {
        if (this.style != 125 && this.style != 75 && this.width > 0) {
            return true;
        }
        return this.space > 0;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<w:" + this.side);
        printWriter.print(" w:val=\"" + this.style() + "\"");
        if (this.width > 0) {
            printWriter.print(" w:sz=\"" + Wml.toEighths((double)this.width() / 20.0) + "\"");
        }
        if (this.color != null) {
            printWriter.print(" w:color=\"" + Wml.hexColorType(this.color) + "\"");
        }
        if (this.space > 0) {
            printWriter.print(" w:space=\"" + this.space / 20 + "\"");
        }
        printWriter.print(" />");
    }

    private String style() {
        String string;
        switch (this.style) {
            default: {
                string = "none";
                break;
            }
            case 187: {
                string = "single";
                break;
            }
            case 50: {
                string = "double";
                break;
            }
            case 49: {
                string = "dotted";
                break;
            }
            case 42: {
                string = "dashed";
                break;
            }
            case 73: {
                string = "three-d-engrave";
                break;
            }
            case 164: {
                string = "three-d-emboss";
                break;
            }
            case 89: {
                string = "inset";
                break;
            }
            case 143: {
                string = "outset";
            }
        }
        return string;
    }

    private int width() {
        if (this.style == 50) {
            int n = this.width / 3;
            if (n <= 0) {
                n = 1;
            }
            return n;
        }
        return this.width;
    }

    public Border copy() {
        Border border = null;
        try {
            border = (Border)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return border;
    }
}

