/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.wml;

import com.xmlmind.fo.converter.wml.Border;
import com.xmlmind.fo.converter.wml.Wml;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public final class Borders {
    private static final int BORDER_THIN = 20;
    private static final int BORDER_MEDIUM = 40;
    private static final int BORDER_THICK = 60;
    private static final int BORDER_MIN_WIDTH = 5;
    private static final int BORDER_MAX_WIDTH = 240;
    public Border top = new Border("top");
    public Border bottom = new Border("bottom");
    public Border left = new Border("left");
    public Border right = new Border("right");

    public Borders() {
    }

    public Borders(Value[] valueArray) {
        this();
        this.initialize(valueArray);
    }

    public void initialize(Value[] valueArray) {
        Color color;
        int n;
        int n2 = valueArray[66].keyword();
        int n3 = Borders.space(valueArray[208]);
        if (n2 != 125) {
            n = Borders.width(valueArray[67]);
            color = valueArray[65].color();
            this.top.set(n2, n, color, n3);
        } else {
            this.top.space = n3;
        }
        n2 = valueArray[35].keyword();
        n3 = Borders.space(valueArray[199]);
        if (n2 != 125) {
            n = Borders.width(valueArray[36]);
            color = valueArray[34].color();
            this.bottom.set(n2, n, color, n3);
        } else {
            this.bottom.space = n3;
        }
        n2 = valueArray[47].keyword();
        n3 = Borders.space(valueArray[203]);
        if (n2 != 125) {
            n = Borders.width(valueArray[48]);
            color = valueArray[46].color();
            this.left.set(n2, n, color, n3);
        } else {
            this.left.space = n3;
        }
        n2 = valueArray[51].keyword();
        n3 = Borders.space(valueArray[204]);
        if (n2 != 125) {
            n = Borders.width(valueArray[52]);
            color = valueArray[50].color();
            this.right.set(n2, n, color, n3);
        } else {
            this.right.space = n3;
        }
    }

    private static int width(Value value) {
        int n;
        if (value.type == 1) {
            switch (value.keyword()) {
                case 202: {
                    n = 20;
                    break;
                }
                default: {
                    n = 40;
                    break;
                }
                case 203: {
                    n = 60;
                    break;
                }
            }
        } else {
            n = Wml.toTwips(value.length());
            if (n > 0) {
                if (n < 5) {
                    n = 5;
                } else if (n > 240) {
                    n = 240;
                }
            } else if (n < 0) {
                n = 0;
            }
        }
        return n;
    }

    private static int space(Value value) {
        int n = 0;
        if (value.type == 4) {
            n = Wml.toTwips(value.length());
        }
        return n;
    }

    public boolean materialized() {
        return this.top.materialized() || this.bottom.materialized() || this.left.materialized() || this.right.materialized();
    }

    public void print(PrintWriter printWriter) {
        if (this.top.materialized()) {
            this.top.print(printWriter);
        }
        if (this.left.materialized()) {
            this.left.print(printWriter);
        }
        if (this.bottom.materialized()) {
            this.bottom.print(printWriter);
        }
        if (this.right.materialized()) {
            this.right.print(printWriter);
        }
    }

    public Borders copy() {
        Borders borders = new Borders();
        borders.top = this.top.copy();
        borders.bottom = this.bottom.copy();
        borders.left = this.left.copy();
        borders.right = this.right.copy();
        return borders;
    }
}

