/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.wml;

import com.xmlmind.fo.converter.wml.Wml;
import com.xmlmind.fo.font.FontUtil;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public final class FontTable {
    public static final String FAMILY_ROMAN = "Roman";
    public static final String FAMILY_SWISS = "Swiss";
    public static final String FAMILY_MODERN = "Modern";
    public static final String FAMILY_DECORATIVE = "Decorative";
    public static final String FAMILY_SCRIPT = "Script";
    private int charset;
    private Hashtable fonts = new Hashtable();
    private Hashtable aliases = new Hashtable();

    public FontTable() {
        this(-1);
    }

    public FontTable(int n) {
        this.charset = n;
    }

    public void alias(String string, String string2) {
        this.aliases.put(string, string2);
    }

    public String name(String string) {
        String string2 = (String)this.aliases.get(string);
        return string2 != null ? string2 : string;
    }

    public Font add(String string) {
        return this.add(string, null, this.charset);
    }

    public Font add(String string, String string2) {
        return this.add(string, string2, this.charset);
    }

    public Font add(String string, String string2, int n) {
        Font font = new Font(this.name(string), string2, n);
        return this.add(font);
    }

    public Font add(Font font) {
        String string = this.key(font.name);
        if (!this.fonts.containsKey(string)) {
            this.fonts.put(string, font);
        } else {
            font = (Font)this.fonts.get(string);
        }
        return font;
    }

    private String key(String string) {
        return string.toLowerCase();
    }

    public Font get(String string) {
        return (Font)this.fonts.get(this.key(this.name(string)));
    }

    public void print(PrintWriter printWriter) {
        if (this.fonts.size() == 0) {
            return;
        }
        printWriter.println("<w:fonts>");
        Enumeration enumeration = this.fonts.elements();
        while (enumeration.hasMoreElements()) {
            Font font = (Font)enumeration.nextElement();
            if (font.family == null && font.charset < 0) continue;
            printWriter.print("<w:font w:name=\"" + font.name + "\">");
            if (font.charset >= 0) {
                String string = Wml.hexNumberType(font.charset, 8);
                printWriter.print("<w:charset w:val=\"" + string + "\" />");
            }
            if (font.family != null) {
                printWriter.print("<w:family w:val=\"" + font.family + "\" />");
            }
            printWriter.println("</w:font>");
        }
        printWriter.println("</w:fonts>");
    }

    public static class Font {
        public String name;
        public String family;
        public int charset;

        public Font(String string, String string2) {
            this(string, string2, -1);
        }

        public Font(String string, String string2, int n) {
            this.name = string;
            if (string2 == null) {
                switch (FontUtil.toGenericFamily(string, false)) {
                    case 1: {
                        string2 = FontTable.FAMILY_ROMAN;
                        break;
                    }
                    case 2: {
                        string2 = FontTable.FAMILY_SWISS;
                        break;
                    }
                    case 3: {
                        string2 = FontTable.FAMILY_MODERN;
                        break;
                    }
                    case 4: {
                        string2 = FontTable.FAMILY_DECORATIVE;
                        break;
                    }
                    case 5: {
                        string2 = FontTable.FAMILY_SCRIPT;
                    }
                }
            }
            this.family = string2;
            this.charset = n;
        }
    }
}

