/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.wml;

import com.xmlmind.fo.converter.GraphicLayout;
import com.xmlmind.fo.converter.wml.RunProperties;
import com.xmlmind.fo.converter.wml.Wml;
import com.xmlmind.fo.graphic.Graphic;
import com.xmlmind.fo.graphic.GraphicEnv;
import com.xmlmind.fo.graphic.GraphicFactories;
import com.xmlmind.fo.graphic.GraphicUtil;
import com.xmlmind.fo.objects.ExternalGraphic;
import com.xmlmind.fo.util.Base64;
import com.xmlmind.fo.util.Encoder;
import com.xmlmind.fo.util.StringUtil;
import com.xmlmind.fo.util.URLUtil;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Locale;

public class Picture {
    private int id;
    private Graphic graphic;
    private GraphicEnv graphicEnv;
    private RunProperties properties;
    private boolean prescaled;
    private int imageResolution;
    private int imageRendererResolution;
    private String[] graphicFormats;
    private Encoder encoder;
    private NumberFormat numberFormat;
    private double xScale = 1.0;
    private double yScale = 1.0;
    private Graphic picture;
    private GraphicLayout layout;
    private static final String[] graphicFormats1 = new String[]{"image/x-wmf", "image/x-emf", "image/jpeg", "image/png"};
    private static final String[] graphicFormats2 = new String[]{"image/x-wmf", "image/x-emf", "image/png"};

    public Picture(int n, Graphic graphic, GraphicEnv graphicEnv, RunProperties runProperties, boolean bl, int n2, int n3, boolean bl2, Encoder encoder) {
        this.id = n;
        this.graphic = graphic;
        this.graphicEnv = graphicEnv;
        this.properties = runProperties;
        this.prescaled = bl;
        this.imageResolution = n2;
        this.imageRendererResolution = n3;
        this.graphicFormats = bl2 ? graphicFormats2 : graphicFormats1;
        this.encoder = encoder;
        this.numberFormat = NumberFormat.getInstance(Locale.US);
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setMinimumIntegerDigits(1);
    }

    public int width() {
        double d = GraphicLayout.width(this.graphic, this.imageResolution);
        if (d == 0.0) {
            d = GraphicLayout.intrinsicWidth(this.graphic, this.imageResolution);
        }
        if (this.properties != null && this.properties.border != null) {
            d += (double)(this.properties.border.width + this.properties.border.space) / 10.0;
        }
        return Picture.toTwips(d);
    }

    public void layout(double d) throws Exception {
        if (this.picture != null) {
            return;
        }
        if (this.properties != null && this.properties.border != null) {
            d -= (double)(this.properties.border.width + this.properties.border.space) / 10.0;
        }
        this.layout = new GraphicLayout(this.graphic, this.imageResolution, d);
        double d2 = GraphicLayout.intrinsicWidth(this.graphic, this.imageRendererResolution);
        double d3 = GraphicLayout.intrinsicHeight(this.graphic, this.imageRendererResolution);
        if (this.layout.contentWidth != d2) {
            this.xScale = this.layout.contentWidth / d2;
        }
        if (this.layout.contentHeight != d3) {
            this.yScale = this.layout.contentHeight / d3;
        }
        switch (this.graphic.getType()) {
            case 2: {
                this.prescaled = true;
                break;
            }
            case 0: {
                this.prescaled = false;
                break;
            }
            default: {
                if (this.xScale < 1.0 && this.yScale < 1.0) break;
                this.prescaled = false;
            }
        }
        if (this.prescaled || !StringUtil.contains(this.graphicFormats, this.graphic.getFormat())) {
            try {
                if (this.prescaled) {
                    this.picture = GraphicFactories.convertGraphic(this.graphic, this.graphicFormats, this.xScale, this.yScale, null, this.graphicEnv);
                }
                this.picture = GraphicFactories.convertGraphic(this.graphic, this.graphicFormats, 1.0, 1.0, null, this.graphicEnv);
            }
            catch (Exception exception) {
                this.graphicEnv.reportWarning("failed to convert image \"" + this.graphic.getLocation() + "\": " + exception.getMessage());
                this.picture = null;
                return;
            }
        } else {
            this.picture = this.graphic;
        }
        if (this.properties != null) {
            int n = 0;
            int n2 = (int)Math.round(2.0 * this.layout.viewportHeight);
            int n3 = this.properties.fontSize;
            int n4 = this.properties.fontSize / 4;
            int n5 = (n3 + n4) / 2 - n4;
            switch (this.properties.alignmentBaseline) {
                case 121: {
                    n = -(n2 / 2) + n5;
                    break;
                }
                case 17: 
                case 199: {
                    n = -n2 + n3;
                    break;
                }
                case 5: 
                case 198: {
                    n = -n4;
                }
            }
            this.properties.baselineShift = n;
        }
    }

    public void print(PrintWriter printWriter) throws Exception {
        if (this.picture == null) {
            return;
        }
        printWriter.println("<w:r>");
        if (this.properties != null) {
            this.properties.print(printWriter);
        }
        this.printPicture(printWriter);
        printWriter.println("</w:r>");
    }

    private void printPicture(PrintWriter printWriter) throws Exception {
        String string = "wordml://" + this.id + GraphicUtil.formatToSuffix(this.picture.getFormat());
        printWriter.println("<w:pict>");
        try {
            this.printImageData(string, printWriter);
        }
        catch (Exception exception) {
            this.graphicEnv.reportWarning("failed to read image \"" + this.graphic.getLocation() + "\": " + exception.getMessage());
            string = null;
        }
        printWriter.print("<v:shape filled=\"f\"");
        String string2 = null;
        ExternalGraphic externalGraphic = GraphicLayout.properties(this.graphic);
        if (externalGraphic != null) {
            string2 = externalGraphic.role;
        }
        if (string2 != null && string2.length() > 0) {
            printWriter.print(" alt=\"");
            printWriter.print(Wml.escape(string2, this.encoder));
            printWriter.print("\"");
        }
        printWriter.print(" style=\"");
        printWriter.print("width:" + this.format(this.layout.viewportWidth, 2) + "pt;");
        printWriter.print("height:" + this.format(this.layout.viewportHeight, 2) + "pt");
        printWriter.println("\">");
        if (string != null) {
            printWriter.print("<v:imagedata src=\"" + string + "\"");
            if (this.layout.contentWidth != this.layout.viewportWidth || this.layout.contentHeight != this.layout.viewportHeight) {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                if (this.layout.contentWidth < this.layout.viewportWidth) {
                    d = -this.layout.contentX;
                    double d5 = this.layout.contentX + this.layout.contentWidth;
                    d3 = -(this.layout.viewportWidth - d5);
                } else if (this.layout.contentWidth > this.layout.viewportWidth) {
                    d = this.layout.cropX;
                    double d6 = this.layout.cropX + this.layout.viewportWidth;
                    d3 = this.layout.contentWidth - d6;
                }
                d /= this.layout.contentWidth;
                d3 /= this.layout.contentWidth;
                if (this.layout.contentHeight < this.layout.viewportHeight) {
                    d2 = -this.layout.contentY;
                    double d7 = this.layout.contentY + this.layout.contentHeight;
                    d4 = -(this.layout.viewportHeight - d7);
                } else if (this.layout.contentHeight > this.layout.viewportHeight) {
                    d2 = this.layout.cropY;
                    double d8 = this.layout.cropY + this.layout.viewportHeight;
                    d4 = this.layout.contentHeight - d8;
                }
                printWriter.print(" cropleft=\"" + this.format(d, 2) + "\"");
                printWriter.print(" croptop=\"" + this.format(d2 /= this.layout.contentHeight, 2) + "\"");
                printWriter.print(" cropright=\"" + this.format(d3, 2) + "\"");
                printWriter.print(" cropbottom=\"" + this.format(d4 /= this.layout.contentHeight, 2) + "\"");
            }
            printWriter.println(" />");
        }
        printWriter.println("</v:shape>");
        printWriter.println("</w:pict>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printImageData(String string, PrintWriter printWriter) throws Exception {
        printWriter.print("<w:binData w:name=\"" + string + "\">");
        printWriter.print("\r\n");
        InputStream inputStream = URLUtil.openStream(this.picture.getLocation());
        try {
            int n;
            printWriter.flush();
            Base64.OutputStream outputStream = new Base64.OutputStream(printWriter);
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) >= 0) {
                if (n <= 0) continue;
                outputStream.write(byArray, 0, n);
            }
            outputStream.finish();
        }
        finally {
            inputStream.close();
        }
        printWriter.println("</w:binData>");
    }

    private String format(double d, int n) {
        this.numberFormat.setMaximumFractionDigits(n);
        this.numberFormat.setMinimumFractionDigits(n);
        return this.numberFormat.format(d);
    }

    private static int toTwips(double d) {
        return (int)Math.round(d * 20.0);
    }
}

