/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.wml;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.wml.Borders;
import com.xmlmind.fo.converter.wml.ParProperties;
import com.xmlmind.fo.converter.wml.Paragraph;
import com.xmlmind.fo.converter.wml.Table;
import com.xmlmind.fo.converter.wml.TableAndCaption;
import com.xmlmind.fo.converter.wml.Wml;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public final class TableCell
implements Cloneable {
    public static final String ALIGNMENT_TOP = "top";
    public static final String ALIGNMENT_CENTER = "center";
    public static final String ALIGNMENT_BOTTOM = "bottom";
    public static final String MERGE_START = "restart";
    public static final String MERGE_CONTINUE = "continue";
    public int columnNumber;
    public int columnSpan = 1;
    public int rowSpan = 1;
    public boolean startsRow;
    public boolean endsRow;
    public int width;
    public double percentage;
    public String alignment = "top";
    public Borders borders;
    public Color background;
    public int marginTop;
    public int marginBottom;
    public int marginLeft;
    public int marginRight;
    public int gridSpan = 1;
    public String hMerge;
    public String vMerge;
    private Vector elements = new Vector();
    private boolean requiresLayout;

    public TableCell() {
    }

    public TableCell(Context context) {
        this();
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        this.columnNumber = TableCell.number(valueArray[82]);
        this.columnSpan = TableCell.number(valueArray[187]);
        this.rowSpan = TableCell.number(valueArray[188]);
        if (valueArray[279].keyword() == 209) {
            this.startsRow = true;
        }
        if (valueArray[98].keyword() == 209) {
            this.endsRow = true;
        }
        Value value = valueArray[308];
        switch (value.type) {
            case 4: {
                this.width = Wml.toTwips(value.length());
                break;
            }
            case 13: {
                this.percentage = value.percentage();
            }
        }
        switch (valueArray[93].keyword()) {
            default: {
                this.alignment = ALIGNMENT_TOP;
                break;
            }
            case 31: {
                this.alignment = ALIGNMENT_CENTER;
                break;
            }
            case 4: {
                this.alignment = ALIGNMENT_BOTTOM;
            }
        }
        this.borders = new Borders(valueArray);
        this.marginTop = this.borders.top.space;
        this.borders.top.space = 0;
        this.marginBottom = this.borders.bottom.space;
        this.borders.bottom.space = 0;
        this.marginLeft = this.borders.left.space;
        this.borders.left.space = 0;
        this.marginRight = this.borders.right.space;
        this.borders.right.space = 0;
        Value value2 = valueArray[8];
        if (value2.type == 24) {
            this.background = value2.color();
        }
    }

    public void setReference(int n) {
        if (this.percentage > 0.0) {
            this.width = (int)((double)n * this.percentage / 100.0);
        }
    }

    private static int number(Value value) {
        int n = (int)Math.round(value.number());
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    public void add(Paragraph paragraph) {
        this.elements.addElement(new Element(1, paragraph));
        if (paragraph.hasPicture) {
            this.requiresLayout = true;
        }
    }

    public void add(Table table) {
        this.elements.addElement(new Element(2, table));
        this.requiresLayout = true;
    }

    public void add(TableAndCaption tableAndCaption) {
        this.elements.addElement(new Element(3, tableAndCaption));
        this.requiresLayout = true;
    }

    public void keepWithNext() {
        if (this.isEmpty()) {
            Paragraph paragraph = Paragraph.empty();
            paragraph.properties.keepWithNext = true;
            this.add(paragraph);
            return;
        }
        Element element = (Element)this.elements.elementAt(0);
        switch (element.type) {
            case 1: {
                Paragraph paragraph = (Paragraph)element.object;
                if (paragraph.properties == null) {
                    paragraph.properties = new ParProperties();
                }
                paragraph.properties.keepWithNext = true;
            }
        }
    }

    public void breakBefore(int n) {
        if (this.isEmpty()) {
            Paragraph paragraph = Paragraph.empty();
            paragraph.properties.breakBefore = n;
            this.add(paragraph);
            return;
        }
        Element element = (Element)this.elements.elementAt(0);
        switch (element.type) {
            case 1: {
                Paragraph paragraph = (Paragraph)element.object;
                if (paragraph.properties == null) {
                    paragraph.properties = new ParProperties();
                }
                paragraph.properties.breakBefore = n;
            }
        }
    }

    public boolean requiresLayout() {
        return this.requiresLayout;
    }

    public void layout(int n) throws Exception {
        if (!this.requiresLayout) {
            return;
        }
        int n2 = this.elements.size();
        block5: for (int i = 0; i < n2; ++i) {
            Element element = (Element)this.elements.elementAt(i);
            switch (element.type) {
                case 1: {
                    Paragraph paragraph = (Paragraph)element.object;
                    if (!paragraph.hasPicture) continue block5;
                    paragraph.layout(n);
                    continue block5;
                }
                case 2: {
                    Table table = (Table)element.object;
                    table.layout(n);
                    continue block5;
                }
                case 3: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    tableAndCaption.layout(n);
                }
            }
        }
    }

    public void print(PrintWriter printWriter, Encoder encoder) throws Exception {
        printWriter.println("<w:tc>");
        printWriter.print("<w:tcPr>");
        if (this.width > 0) {
            printWriter.print("<w:tcW w:w=\"" + this.width + "\" w:type=\"dxa\" />");
        } else if (this.gridSpan > 1) {
            printWriter.print("<w:gridSpan w:val=\"" + this.gridSpan + "\" />");
        }
        if (this.hMerge != null) {
            printWriter.print("<w:hmerge w:val=\"" + this.hMerge + "\" />");
        }
        if (this.vMerge != null) {
            printWriter.print("<w:vmerge w:val=\"" + this.vMerge + "\" />");
        }
        if (this.borders != null && this.borders.materialized()) {
            printWriter.print("<w:tcBorders>");
            this.borders.print(printWriter);
            printWriter.print("</w:tcBorders>");
        }
        if (this.background != null) {
            printWriter.print("<w:shd");
            printWriter.print(" w:val=\"clear\"");
            printWriter.print(" w:fill=\"" + Wml.hexColorType(this.background) + "\"");
            printWriter.print(" />");
        }
        if (this.hasMargin()) {
            printWriter.print("<w:tcMar>");
            if (this.marginTop > 0) {
                printWriter.print(this.margin(ALIGNMENT_TOP, this.marginTop));
            }
            if (this.marginLeft > 0) {
                printWriter.print(this.margin("left", this.marginLeft));
            }
            if (this.marginBottom > 0) {
                printWriter.print(this.margin(ALIGNMENT_BOTTOM, this.marginBottom));
            }
            if (this.marginRight > 0) {
                printWriter.print(this.margin("right", this.marginRight));
            }
            printWriter.print("</w:tcMar>");
        }
        printWriter.print("<w:vAlign w:val=\"" + this.alignment + "\" />");
        printWriter.println("</w:tcPr>");
        if (this.isEmpty()) {
            Paragraph.EMPTY.print(printWriter);
        } else {
            int n = this.elements.size();
            block9: for (int i = 0; i < n; ++i) {
                Element element = (Element)this.elements.elementAt(i);
                switch (element.type) {
                    case 1: {
                        Paragraph paragraph = (Paragraph)element.object;
                        paragraph.print(printWriter, encoder);
                        continue block9;
                    }
                    case 2: {
                        Table table = (Table)element.object;
                        table.print(printWriter, encoder);
                        continue block9;
                    }
                    case 3: {
                        TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                        tableAndCaption.print(printWriter, encoder);
                    }
                }
            }
            Element element = (Element)this.elements.lastElement();
            switch (element.type) {
                case 2: {
                    Paragraph.EMPTY.print(printWriter);
                    break;
                }
                case 3: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    if (tableAndCaption.caption != null && tableAndCaption.caption.side != 1) break;
                    Paragraph.EMPTY.print(printWriter);
                }
            }
        }
        printWriter.println("</w:tc>");
    }

    public boolean hasMargin() {
        return this.marginTop > 0 || this.marginBottom > 0 || this.marginLeft > 0 || this.marginRight > 0;
    }

    private String margin(String string, int n) {
        return "<w:" + string + " w:w=\"" + n + "\" w:type=\"dxa\" />";
    }

    public boolean isEmpty() {
        return this.elements.size() == 0;
    }

    public int maxWidth() {
        int n = 0;
        int n2 = this.elements.size();
        block5: for (int i = 0; i < n2; ++i) {
            Element element = (Element)this.elements.elementAt(i);
            switch (element.type) {
                case 1: {
                    Paragraph paragraph = (Paragraph)element.object;
                    int n3 = paragraph.maxWidth();
                    if (n3 <= n) continue block5;
                    n = n3;
                    continue block5;
                }
                case 2: {
                    Table table = (Table)element.object;
                    int n3 = table.maxWidth();
                    if (n3 <= n) continue block5;
                    n = n3;
                    continue block5;
                }
                case 3: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    int n3 = tableAndCaption.maxWidth();
                    if (n3 <= n) continue block5;
                    n = n3;
                }
            }
        }
        n += this.marginLeft;
        n += this.marginRight;
        if (this.width > (n += 28)) {
            n = this.width;
        }
        return n;
    }

    public int minWidth() {
        int n = 0;
        int n2 = this.elements.size();
        block5: for (int i = 0; i < n2; ++i) {
            Element element = (Element)this.elements.elementAt(i);
            switch (element.type) {
                case 1: {
                    Paragraph paragraph = (Paragraph)element.object;
                    int n3 = paragraph.minWidth();
                    if (n3 <= n) continue block5;
                    n = n3;
                    continue block5;
                }
                case 2: {
                    Table table = (Table)element.object;
                    int n3 = table.minWidth();
                    if (n3 <= n) continue block5;
                    n = n3;
                    continue block5;
                }
                case 3: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    int n3 = tableAndCaption.minWidth();
                    if (n3 <= n) continue block5;
                    n = n3;
                }
            }
        }
        n += this.marginLeft;
        n += this.marginRight;
        if (this.width > (n += 28)) {
            n = this.width;
        }
        return n;
    }

    public TableCell copy() {
        TableCell tableCell = null;
        try {
            tableCell = (TableCell)this.clone();
            if (this.borders != null) {
                tableCell.borders = this.borders.copy();
            }
            tableCell.elements = new Vector();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return tableCell;
    }

    private class Element {
        static final int TYPE_PARAGRAPH = 1;
        static final int TYPE_TABLE = 2;
        static final int TYPE_TABLE_AND_CAPTION = 3;
        int type;
        Object object;

        Element(int n, Object object) {
            this.type = n;
            this.object = object;
        }
    }
}

