/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.wml;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.wml.Borders;
import com.xmlmind.fo.converter.wml.TableRow;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public class TableGroup {
    public Borders borders;
    public Color background;
    public boolean isHeader;
    public Vector rows = new Vector();

    public TableGroup() {
        this(false);
    }

    public TableGroup(boolean bl) {
        this.isHeader = bl;
    }

    public TableGroup(Context context) {
        this(false, context);
    }

    public TableGroup(boolean bl, Context context) {
        this(bl);
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        this.borders = new Borders(valueArray);
        Value value = valueArray[8];
        if (value.type == 24) {
            this.background = value.color();
        }
    }

    public void add(TableRow tableRow) {
        this.rows.addElement(tableRow);
        if (this.isHeader) {
            tableRow.isHeaderRow = true;
        }
    }

    public int size() {
        return this.rows.size();
    }

    public TableRow get(int n) {
        return (TableRow)this.rows.elementAt(n);
    }

    public void print(PrintWriter printWriter, Encoder encoder) throws Exception {
        int n = this.rows.size();
        for (int i = 0; i < n; ++i) {
            TableRow tableRow = (TableRow)this.rows.elementAt(i);
            tableRow.print(printWriter, encoder);
        }
    }
}

