/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.font;

import com.xmlmind.fo.font.CharMetrics;
import com.xmlmind.fo.font.DiacriticUtil;
import com.xmlmind.fo.font.FontMetrics;
import com.xmlmind.fo.font.TextExtents;

public final class Font {
    public static final int FAMILY_SERIF = 1;
    public static final int FAMILY_SANS_SERIF = 2;
    public static final int FAMILY_MONOSPACE = 3;
    public static final int FAMILY_FANTASY = 4;
    public static final int FAMILY_CURSIVE = 5;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public final int family;
    public final int style;
    public final int size;
    private FontMetrics metrics;

    public Font(int n, int n2, int n3) throws Exception {
        this.family = n;
        this.style = n2;
        this.size = n3;
        this.metrics = FontMetrics.find(n, n2);
    }

    public TextExtents getTextExtents(String string) {
        int n;
        boolean bl = this.metrics.fixedPitch;
        int n2 = 0;
        short s = 0;
        short s2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            n = string.charAt(i);
            if (n > 255) {
                if (bl) {
                    n = 109;
                } else if ((n = DiacriticUtil.collapse((char)n)) > 255) {
                    n = Character.isLetter((char)n) ? (Character.isUpperCase((char)n) ? 77 : 109) : (Character.isDigit((char)n) ? 56 : (Character.isWhitespace((char)n) ? 32 : 58));
                }
            }
            CharMetrics charMetrics = this.metrics.charMetrics[n];
            n2 += charMetrics.wx;
            if (charMetrics.ury > s) {
                s = charMetrics.ury;
            }
            if (charMetrics.lly >= s2) continue;
            s2 = charMetrics.lly;
        }
        n = s + Math.abs(s2);
        return new TextExtents(this.toTwips(n2), this.toTwips(n), this.toTwips(s));
    }

    private int toTwips(int n) {
        return (int)Math.round((double)(n * this.size) / 50.0);
    }
}

