/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.font;

import java.util.Hashtable;

public final class FontUtil {
    private static final String[] serifFamilies;
    private static final String[] sansSerifFamilies;
    private static final String[] monospaceFamilies;
    private static final String[] fantasyFamilies;
    private static final String[] cursiveFamilies;
    private static Hashtable wellKnownFamilies;

    private FontUtil() {
    }

    public static String normalizeFamily(String string) {
        if (string == null || (string = string.trim()).length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (Character.isWhitespace(c2)) {
                c2 = ' ';
                if (c != ' ') {
                    stringBuffer.append(c2);
                }
            } else {
                stringBuffer.append(c2);
            }
            c = c2;
        }
        return stringBuffer.toString();
    }

    public static int toGenericFamily(String string, boolean bl) {
        int n = -1;
        if ((string = FontUtil.normalizeFamily(string)) != null) {
            Integer n2 = (Integer)wellKnownFamilies.get(string = string.toLowerCase());
            if (n2 != null) {
                n = n2;
            }
            if (bl && n < 0) {
                if (string.indexOf("mono") >= 0 || string.indexOf("typewriter") >= 0 || string.indexOf("courier") >= 0) {
                    n = 3;
                } else if (string.indexOf("sans") >= 0 || string.indexOf("arial") >= 0 || string.indexOf("helvetica") >= 0) {
                    n = 2;
                } else if (string.indexOf("serif") >= 0 || string.indexOf("roman") >= 0 || string.indexOf("times") >= 0) {
                    n = 1;
                }
            }
        }
        return n;
    }

    static {
        int n;
        serifFamilies = new String[]{"serif", "american typewriter", "baskerville", "baskerville old face", "bell mt", "belwe", "bembo", "bernhard modern std", "big caslon", "bitstream charter", "bitstream vera serif", "bodoni mt", "bodoni mt black", "bodoni mt condensed", "bodoni mt poster compressed", "book antiqua", "bookman", "bookman old style", "californian fb", "calisto mt", "cambria", "caslon", "centaur", "century schoolbook", "century schoolbook l", "charter", "clearlyu", "constantia", "dejavu lgc serif", "dejavu lgc serif condensed", "dejavu serif", "dejavu serif condensed", "didot", "footlight mt light", "freeserif", "garamond", "georgia", "georgia ref", "gloucester mt extra condensed", "goudy old style", "high tower text", "hoefler text", "itc century", "liberation serif", "linux libertine", "lucidabright", "lucida bright", "lucida fax", "luxi serif", "mgopen canonica", "minion std", "minion web", "ms reference serif", "new century schoolbook", "new york", "niagara engraved", "niagara solid", "nimbus roman no9 l", "onyx", "palatino", "palatino linotype", "perpetua", "rockwell", "rockwell condensed", "runic mt condensed", "sylfaen", "times", "times new roman", "university roman let", "urw antiqua t", "urw bookman l", "urw palladio l", "utopia", "vera serif"};
        sansSerifFamilies = new String[]{"sans-serif", "04b_21", "abadi mt condensed", "abadi mt condensed extra bold", "abadi mt condensed light", "arial", "arial black", "arial narrow", "arial rounded mt bold", "arial unicode ms", "avant garde", "avenir", "berlin sans fb", "berlin sans fb demi", "berthold akzidenz grotesk be", "bitstream vera sans", "calibri", "candara", "century gothic", "charcoal", "chicago", "corbel", "dejavu lgc sans", "dejavu lgc sans condensed", "dejavu sans", "dejavu sans condensed", "dejavu sans extra light", "dejavu sans light", "dustismo", "electron", "eras bold itc", "eras demi itc", "eras light itc", "eras medium itc", "eurostile", "firsthome", "franklin gothic book", "franklin gothic demi", "franklin gothic demi cond", "franklin gothic heavy", "franklin gothic medium", "franklin gothic medium cond", "freesans", "futura", "gadget", "geneva", "gill sans", "gill sans mt", "gill sans mt condensed", "gill sans mt ext condensed bold", "gill sans ultra bold", "gill sans ultra bold condensed", "helvetica", "helvetica narrow", "helveticaneue", "helvetica neue", "interstate", "itc franklin gothic", "kabel ult bt", "kartika", "liberation sans", "lucida", "lucida grande", "lucida sans", "lucida sans unicode", "luxi sans", "metal", "mgopen cosmetica", "mgopen modata", "mgopen moderna", "microsoft sans serif", "ms reference sans serif", "news gothic mt", "nice", "nimbus sans l", "nimbus sans l condensed", "optima", "rotissemisans", "segoe ui", "skia", "tahoma", "techno", "tradegothic", "trebuchet ms", "tw cen mt", "tw cen mt condensed", "tw cen mt condensed extra bold", "univers", "urw gothic l", "vera sans", "verdana", "verdana ref", "vrinda"};
        monospaceFamilies = new String[]{"monospace", "andale mono", "andale mono ipa", "bitstream vera sans mono", "consolas", "courier", "courier 10 pitch", "courier new", "dejavu lgc sans mono", "dejavu sans mono", "fixed", "freemono", "liberation mono", "lucida console", "lucida sans typewriter", "lucida typewriter", "luxi mono", "monaco", "monotype.com", "nimbus mono l", "ocr a extended", "ocrb", "terminal", "vera sans mono"};
        fantasyFamilies = new String[]{"fantasy", "academy engraved let", "agency fb", "alba", "alba matter", "alba super", "algerian", "baby kruffy", "balker", "base 02", "bauhaus 93", "beesknees itc", "bernard mt condensed", "blackletter686 bt", "braggadocio", "britannic bold", "broadway", "broadway bt", "campbell", "capitals", "castellar", "chick", "chiller", "colonna mt", "cooper black", "copperplate", "copperplate gothic bold", "copperplate gothic light", "croobie", "curlz mt", "desdemona", "engravers mt", "felix titling", "freshbot", "frosty", "genuine", "goudy stout", "haettenschweiler", "harlow solid italic", "harrington", "herculanum", "highlight let", "impact", "imprint mt shadow", "isabella", "jokerman", "jokerman let", "jokewood", "juice itc", "junkyard", "kino mt", "linux libertine c", "magneto", "marked fool", "marker felt", "marketpro", "matisse itc", "matura mt script capitals", "mekanik let", "milano let", "misterearl bt", "odessa let", "olddreadfulno7 bt", "old english text mt", "orange let", "papyrus", "penguin attack", "perpetua titling mt", "placard condensed", "playbill", "poornut", "pump demi bold let", "pussycat", "quixley let", "ravie", "rockwell extra bold", "scruff let", "showcard gothic", "snap itc", "square721 bt", "stencil", "victorian let", "weltron urban", "westwood let", "wide latin"};
        cursiveFamilies = new String[]{"cursive", "a charming font", "adobe garamond", "andy", "apple casual", "apple chancery", "bickley script", "blackadder itc", "bradley hand itc", "brush script mt", "budhand", "caflisch script pro", "calligraph421 bt", "casual", "cataneo bt", "champignon", "comic sans ms", "dombold bt", "domestic manners", "edwardian script itc", "fat", "fine hand", "forte", "freestyle script", "french script mt", "gigi", "gloogun", "informal roman", "jenkins v2.0", "john handy let", "kaufmann", "kristen itc", "kunstler script", "la bamba let", "lucida calligraphy", "lucida handwriting", "maiandra gd", "mead bold", "mercurius script mt bold", "mistral", "monotype corsiva", "one stroke script let", "palace script mt", "parkavenue bt", "pepita mt", "porcelain", "pristina", "rage italic", "rage italic let", "ruach let", "sand", "script mt bold", "shelley", "smudger let", "staccato222 bt", "tempus sans itc", "textile", "tiranti solid let", "urw chancery l", "viner hand itc", "vivaldi", "vladimir script", "zapf chancery", "zapfino"};
        wellKnownFamilies = new Hashtable();
        Integer n2 = new Integer(1);
        int n3 = serifFamilies.length;
        for (n = 0; n < n3; ++n) {
            wellKnownFamilies.put(serifFamilies[n], n2);
        }
        n2 = new Integer(2);
        n3 = sansSerifFamilies.length;
        for (n = 0; n < n3; ++n) {
            wellKnownFamilies.put(sansSerifFamilies[n], n2);
        }
        n2 = new Integer(3);
        n3 = monospaceFamilies.length;
        for (n = 0; n < n3; ++n) {
            wellKnownFamilies.put(monospaceFamilies[n], n2);
        }
        n2 = new Integer(4);
        n3 = fantasyFamilies.length;
        for (n = 0; n < n3; ++n) {
            wellKnownFamilies.put(fantasyFamilies[n], n2);
        }
        n2 = new Integer(5);
        n3 = cursiveFamilies.length;
        for (n = 0; n < n3; ++n) {
            wellKnownFamilies.put(cursiveFamilies[n], n2);
        }
    }
}

