/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.graphic.emf;

import com.xmlmind.fo.graphic.emf.EMFInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class WMFHeader {
    public long key;
    public int handle;
    public short left;
    public short top;
    public short right;
    public short bottom;
    public int inch;
    public long reserved;
    public int checksum;

    private WMFHeader() {
    }

    public static WMFHeader read(InputStream inputStream) throws IOException {
        EMFInputStream eMFInputStream = new EMFInputStream(inputStream);
        WMFHeader wMFHeader = new WMFHeader();
        wMFHeader.key = eMFInputStream.readDWORD();
        wMFHeader.handle = eMFInputStream.readWORD();
        wMFHeader.left = eMFInputStream.readSHORT();
        wMFHeader.top = eMFInputStream.readSHORT();
        wMFHeader.right = eMFInputStream.readSHORT();
        wMFHeader.bottom = eMFInputStream.readSHORT();
        wMFHeader.inch = eMFInputStream.readWORD();
        wMFHeader.reserved = eMFInputStream.readDWORD();
        wMFHeader.checksum = eMFInputStream.readWORD();
        if (wMFHeader.key != 2596720087L) {
            throw new IOException("invalid 'key' field: 0x" + Long.toString(wMFHeader.key, 16));
        }
        if (wMFHeader.handle != 0) {
            throw new IOException("invalid 'handle' field: 0x" + Integer.toString(wMFHeader.handle, 16));
        }
        if (wMFHeader.left >= wMFHeader.right || wMFHeader.top >= wMFHeader.bottom) {
            throw new IOException("invalid bounding box fields: " + wMFHeader.left + " " + wMFHeader.top + " " + wMFHeader.right + " " + wMFHeader.bottom);
        }
        if (wMFHeader.inch <= 0) {
            throw new IOException("invalid 'inch' field: " + wMFHeader.inch);
        }
        if (wMFHeader.reserved != 0L) {
            throw new IOException("invalid 'reserved' field: 0x" + Long.toString(wMFHeader.reserved, 16));
        }
        int n = wMFHeader.checksum();
        if (wMFHeader.checksum != n) {
            throw new IOException("invalid 'checksum' field: " + wMFHeader.checksum + "; expected " + n);
        }
        return wMFHeader;
    }

    private int checksum() {
        long l = 0L;
        l ^= this.key & 0xFFFFL;
        l ^= (this.key & 0xFFFF0000L) >> 16;
        l ^= (long)(this.handle & 0xFFFF);
        l ^= (long)this.left;
        l ^= (long)this.top;
        l ^= (long)this.right;
        l ^= (long)this.bottom;
        l ^= (long)(this.inch & 0xFFFF);
        l ^= this.reserved & 0xFFFFL;
        return (int)(l ^= (this.reserved & 0xFFFF0000L) >> 16);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WMFHeader[left=");
        stringBuffer.append(this.left);
        stringBuffer.append(", top=");
        stringBuffer.append(this.top);
        stringBuffer.append(", right=");
        stringBuffer.append(this.right);
        stringBuffer.append(", bottom=");
        stringBuffer.append(this.bottom);
        stringBuffer.append(", inch=");
        stringBuffer.append(this.inch);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

