/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.properties;

import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Keyword;
import com.xmlmind.fo.properties.LabelFormat;
import com.xmlmind.fo.properties.Shadow;
import com.xmlmind.fo.properties.expression.Expression;
import com.xmlmind.fo.properties.expression.Function;
import java.text.NumberFormat;
import java.util.Locale;

public final class Value {
    public static final byte TYPE_KEYWORD = 1;
    public static final byte TYPE_INTEGER = 2;
    public static final byte TYPE_NUMBER = 3;
    public static final byte TYPE_LENGTH = 4;
    public static final byte TYPE_LENGTH_RANGE = 5;
    public static final byte TYPE_LENGTH_CONDITIONAL = 6;
    public static final byte TYPE_LENGTH_BP_IP_DIRECTION = 7;
    public static final byte TYPE_KEEP = 8;
    public static final byte TYPE_SPACE = 9;
    public static final byte TYPE_ANGLE = 10;
    public static final byte TYPE_TIME = 11;
    public static final byte TYPE_FREQUENCY = 12;
    public static final byte TYPE_PERCENTAGE = 13;
    public static final byte TYPE_CHARACTER = 14;
    public static final byte TYPE_STRING = 15;
    public static final byte TYPE_NAME = 16;
    public static final byte TYPE_ID = 17;
    public static final byte TYPE_IDREF = 18;
    public static final byte TYPE_COUNTRY = 19;
    public static final byte TYPE_LANGUAGE = 20;
    public static final byte TYPE_SCRIPT = 21;
    public static final byte TYPE_URI_SPECIFICATION = 22;
    public static final byte TYPE_FUNCTION = 23;
    public static final byte TYPE_COLOR = 24;
    public static final byte TYPE_SHADOW = 25;
    public static final byte TYPE_SHAPE = 26;
    public static final byte TYPE_LIST = 27;
    public static final byte TYPE_EXPRESSION = 28;
    public static final byte TYPE_PROPORTIONAL_COLUMN_WIDTH = 29;
    public static final byte TYPE_LABEL_FORMAT = 30;
    public static final Value INTEGER_ZERO = new Value(2, 0);
    public static final Value KEYWORD_ALWAYS = new Value(1, 8);
    public static final Value KEYWORD_AUTO = new Value(1, 10);
    public static final Value KEYWORD_DISCARD = new Value(1, 44);
    public static final Value KEYWORD_FALSE = new Value(1, 61);
    public static final Value KEYWORD_FORCE = new Value(1, 72);
    public static final Value KEYWORD_MEDIUM = new Value(1, 118);
    public static final Value KEYWORD_NONE = new Value(1, 125);
    public static final Value KEYWORD_NORMAL = new Value(1, 127);
    public static final Value KEYWORD_RETAIN = new Value(1, 163);
    public static final Value KEYWORD_STATIC = new Value(1, 191);
    public static final Value KEYWORD_TRUE = new Value(1, 209);
    public static final Value LENGTH_ZERO = new Value(4, 4, 0.0);
    public static final Value NUMBER_ONE = new Value(3, 1.0);
    public static final Value KEEP_AUTO = new Value(8, null);
    public static final Value SPACE_ZERO;
    public byte type;
    public int intValue;
    public double doubleValue;
    public Object objectValue;

    public Value(byte by, int n) {
        this.type = by;
        this.intValue = n;
    }

    public Value(byte by, double d) {
        this.type = by;
        this.doubleValue = d;
    }

    public Value(byte by, Object object) {
        this.type = by;
        this.objectValue = object;
    }

    public Value(byte by, int n, double d) {
        this.type = by;
        this.intValue = n;
        this.doubleValue = d;
    }

    public Value(byte by, int n, Object object) {
        this.type = by;
        this.intValue = n;
        this.objectValue = object;
    }

    public static Value keyword(int n) {
        return new Value(1, n);
    }

    public static Value number(double d) {
        return new Value(3, d);
    }

    public static Value length(double d, int n) {
        return new Value(4, n, d);
    }

    public static Value percentage(double d) {
        return new Value(13, d);
    }

    public static Value color(Color color) {
        return new Value(24, color);
    }

    public static Value name(String string) {
        return new Value(16, string);
    }

    public static Value function(int n, Value[] valueArray) {
        return new Value(23, n, valueArray);
    }

    public static Value expression(Expression expression) {
        return new Value(28, expression);
    }

    public static Value proportionalColumnWidth(double d) {
        return new Value(29, d);
    }

    public static Value labelFormat(LabelFormat labelFormat) {
        return new Value(30, labelFormat);
    }

    public int keyword() {
        return this.intValue;
    }

    public int integer() {
        return this.intValue;
    }

    public double number() {
        return this.doubleValue;
    }

    public double length() {
        return this.doubleValue;
    }

    public int unit() {
        return this.intValue;
    }

    public Value[] lengthRange() {
        return (Value[])this.objectValue;
    }

    public Value[] lengthConditional() {
        return (Value[])this.objectValue;
    }

    public Value[] lengthBpIpDirection() {
        return (Value[])this.objectValue;
    }

    public Value[] keep() {
        return (Value[])this.objectValue;
    }

    public Value[] space() {
        return (Value[])this.objectValue;
    }

    public double angle() {
        return this.doubleValue;
    }

    public double time() {
        return this.doubleValue;
    }

    public int frequency() {
        return this.intValue;
    }

    public double percentage() {
        return this.doubleValue;
    }

    public char character() {
        return (char)this.intValue;
    }

    public String string() {
        return (String)this.objectValue;
    }

    public String name() {
        return (String)this.objectValue;
    }

    public String id() {
        return (String)this.objectValue;
    }

    public String idref() {
        return (String)this.objectValue;
    }

    public String country() {
        return (String)this.objectValue;
    }

    public String language() {
        return (String)this.objectValue;
    }

    public String script() {
        return (String)this.objectValue;
    }

    public String uriSpecification() {
        return (String)this.objectValue;
    }

    public int function() {
        return this.intValue;
    }

    public Value[] arguments() {
        return (Value[])this.objectValue;
    }

    public Color color() {
        return (Color)this.objectValue;
    }

    public Shadow shadow() {
        return (Shadow)this.objectValue;
    }

    public Value[] shape() {
        return (Value[])this.objectValue;
    }

    public Value[] list() {
        return (Value[])this.objectValue;
    }

    public Expression expression() {
        return (Expression)this.objectValue;
    }

    public double proportionalColumnWidth() {
        return this.doubleValue;
    }

    public LabelFormat labelFormat() {
        return (LabelFormat)this.objectValue;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return Keyword.list[this.intValue].keyword;
            }
            case 2: 
            case 12: {
                return String.valueOf(this.intValue);
            }
            case 3: {
                return Value.format(this.doubleValue, 3);
            }
            case 4: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Value.format(this.doubleValue, 3));
                switch (this.intValue) {
                    case 1: {
                        stringBuffer.append("cm");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("mm");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("in");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("pt");
                        break;
                    }
                    case 5: {
                        stringBuffer.append("pc");
                        break;
                    }
                    case 6: {
                        stringBuffer.append("px");
                        break;
                    }
                    case 7: {
                        stringBuffer.append("em");
                        break;
                    }
                    case 8: {
                        stringBuffer.append("ex");
                    }
                }
                return stringBuffer.toString();
            }
            case 10: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Value.format(this.doubleValue, 3));
                stringBuffer.append("deg");
                return stringBuffer.toString();
            }
            case 11: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Value.format(this.doubleValue, 3));
                stringBuffer.append("s");
                return stringBuffer.toString();
            }
            case 13: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Value.format(this.doubleValue, 3));
                stringBuffer.append("%");
                return stringBuffer.toString();
            }
            case 14: {
                return String.valueOf((char)this.intValue);
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                String string = (String)this.objectValue;
                if (string.indexOf(32) >= 0) {
                    return "\"" + string + "\"";
                }
                return string;
            }
            case 23: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Function.name(this.intValue));
                stringBuffer.append('(');
                if (this.objectValue != null) {
                    Value[] valueArray = (Value[])this.objectValue;
                    stringBuffer.append(valueArray[0].toString());
                    for (int i = 1; i < valueArray.length; ++i) {
                        stringBuffer.append(", " + valueArray[i].toString());
                    }
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 24: {
                return this.color().toString();
            }
            case 30: {
                return this.labelFormat().toString();
            }
            case 25: {
                return this.shadow().toString();
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 26: 
            case 27: {
                StringBuffer stringBuffer = new StringBuffer();
                Value[] valueArray = (Value[])this.objectValue;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(valueArray[i].toString());
                }
                return stringBuffer.toString();
            }
            case 28: {
                Expression expression = (Expression)this.objectValue;
                return expression.toString();
            }
        }
        return "?";
    }

    private static String format(double d, int n) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setMaximumFractionDigits(n);
        return numberFormat.format(d);
    }

    static {
        Value.KEEP_AUTO.objectValue = new Value[]{KEYWORD_AUTO, KEYWORD_AUTO, KEYWORD_AUTO};
        SPACE_ZERO = new Value(9, null);
        Value.SPACE_ZERO.objectValue = new Value[]{LENGTH_ZERO, LENGTH_ZERO, LENGTH_ZERO, KEYWORD_DISCARD, INTEGER_ZERO};
    }
}

