/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.properties;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.properties.Property;
import com.xmlmind.fo.properties.Value;

public class Volume
extends Property {
    public static final double MEDIUM = 50.0;

    public Volume(int n, String string, int n2, boolean bl, byte[] byArray, int[] nArray, Value value) {
        super(n, string, n2, bl, byArray, nArray, value);
    }

    protected Value number(String string) {
        double d;
        try {
            d = Double.valueOf(string);
            if (d < 0.0) {
                d = 0.0;
            } else if (d > 100.0) {
                d = 100.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Value(3, d);
    }

    public Value compute(Value value, Context context) {
        if (value.type == 13) {
            double d = value.percentage();
            Context context2 = context.parent();
            value = context2 == null ? this.initialValue : context2.properties.values[303];
            if (value.type == 3) {
                double d2 = value.number() * d / 100.0;
                if (d2 > 100.0) {
                    d2 = 100.0;
                }
                value = new Value(3, d2);
            }
        } else if (value.type == 1) {
            int n = value.keyword();
            if (n == 88) {
                return super.compute(value, context);
            }
            if (n != 179) {
                double d;
                switch (n) {
                    case 244: {
                        d = 0.0;
                        break;
                    }
                    case 186: {
                        d = 25.0;
                        break;
                    }
                    default: {
                        d = 50.0;
                        break;
                    }
                    case 109: {
                        d = 75.0;
                        break;
                    }
                    case 240: {
                        d = 100.0;
                    }
                }
                value = new Value(3, d);
            }
        } else {
            value = super.compute(value, context);
        }
        return value;
    }
}

