/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.properties.expression;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.properties.Property;
import com.xmlmind.fo.properties.PropertyValues;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.properties.expression.Function;
import com.xmlmind.fo.properties.expression.ParseException;
import com.xmlmind.fo.properties.expression.Parser;

public class Expression {
    public static final int OPERATOR_NONE = 0;
    public static final int OPERATOR_NEGATION = 1;
    public static final int OPERATOR_ADDITION = 2;
    public static final int OPERATOR_SUBTRACTION = 3;
    public static final int OPERATOR_MULTIPLICATION = 4;
    public static final int OPERATOR_DIVISION = 5;
    public static final int OPERATOR_REMAINDER = 6;
    public int operator = 0;
    public Value operand1;
    public Value operand2;

    public static Value parse(String string) {
        try {
            Expression expression = Parser.parse(string);
            return Value.expression(expression);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Value evaluate(Property property, Context context) {
        Expression expression;
        Value value = this.operand1;
        Value value2 = this.operand2;
        Value value3 = null;
        if (value != null) {
            switch (value.type) {
                case 28: {
                    expression = value.expression();
                    value = expression.evaluate(property, context);
                    break;
                }
                case 23: {
                    value = Function.evaluate(value.function(), value.arguments(), property, context);
                    break;
                }
                default: {
                    value = property.compute(value, context);
                }
            }
        }
        if (value2 != null) {
            switch (value2.type) {
                case 28: {
                    expression = value2.expression();
                    value2 = expression.evaluate(property, context);
                    break;
                }
                case 23: {
                    value2 = Function.evaluate(value2.function(), value2.arguments(), property, context);
                    break;
                }
                default: {
                    value2 = property.compute(value2, context);
                }
            }
        }
        if (value == null) {
            return null;
        }
        block8 : switch (this.operator) {
            case 0: {
                value3 = value;
                break;
            }
            case 1: {
                switch (value.type) {
                    case 3: {
                        value3 = Value.number(-value.number());
                        break;
                    }
                    case 4: {
                        value3 = Value.length(-value.length(), 4);
                    }
                }
                break;
            }
            case 2: {
                if (value2 == null || value2.type != value.type) break;
                switch (value.type) {
                    case 3: {
                        double d = value.number() + value2.number();
                        value3 = Value.number(d);
                        break;
                    }
                    case 4: {
                        double d = value.length() + value2.length();
                        value3 = Value.length(d, 4);
                    }
                }
                break;
            }
            case 3: {
                if (value2 == null || value2.type != value.type) break;
                switch (value.type) {
                    case 3: {
                        double d = value.number() - value2.number();
                        value3 = Value.number(d);
                        break;
                    }
                    case 4: {
                        double d = value.length() - value2.length();
                        value3 = Value.length(d, 4);
                    }
                }
                break;
            }
            case 4: {
                if (value2 == null) break;
                switch (value.type) {
                    case 3: {
                        switch (value2.type) {
                            case 3: {
                                double d = value.number() * value2.number();
                                value3 = Value.number(d);
                                break;
                            }
                            case 4: {
                                double d = value.number() * value2.length();
                                value3 = Value.length(d, 4);
                            }
                        }
                        break;
                    }
                    case 4: {
                        if (value2.type != 3) break;
                        double d = value.length() * value2.number();
                        value3 = Value.length(d, 4);
                    }
                }
                break;
            }
            case 5: {
                if (value2 == null || value2.type != 3) break;
                switch (value.type) {
                    case 3: {
                        double d = value.number() / value2.number();
                        value3 = Value.number(d);
                        break;
                    }
                    case 4: {
                        double d = value.length() / value2.number();
                        value3 = Value.length(d, 4);
                    }
                }
                break;
            }
            case 6: {
                if (value2 == null || value2.type != 3) break;
                switch (value.type) {
                    case 3: {
                        double d = value.number() % value2.number();
                        value3 = Value.number(d);
                        break block8;
                    }
                    case 4: {
                        double d = value.length() % value2.number();
                        value3 = Value.length(d, 4);
                    }
                }
            }
        }
        return value3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.operand1 == null) {
            return "?";
        }
        stringBuffer.append("( ");
        if (this.operator == 0) {
            stringBuffer.append(this.operand1.toString());
        } else if (this.operator == 1) {
            stringBuffer.append("- " + this.operand1.toString());
        } else {
            if (this.operand2 == null) {
                return "?";
            }
            stringBuffer.append(this.operand1.toString());
            switch (this.operator) {
                case 2: {
                    stringBuffer.append(" + ");
                    break;
                }
                case 3: {
                    stringBuffer.append(" - ");
                    break;
                }
                case 4: {
                    stringBuffer.append(" * ");
                    break;
                }
                case 5: {
                    stringBuffer.append(" / ");
                    break;
                }
                case 6: {
                    stringBuffer.append(" % ");
                    break;
                }
                default: {
                    return "?";
                }
            }
            stringBuffer.append(this.operand2.toString());
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Property property;
        Expression expression = null;
        if (stringArray.length != 2) {
            String string = "com.xmlmind.fo.properties.expression.Expression";
            System.err.println("usage: java " + string + "<property> <expression>");
            System.exit(1);
        }
        if ((property = Property.property(stringArray[0])) == null) {
            System.out.println("Error: bad property name '" + stringArray[0] + "'");
            System.exit(2);
        }
        try {
            expression = Parser.parse(stringArray[1]);
        }
        catch (ParseException parseException) {
            System.out.println("Error: " + parseException.toString());
            System.exit(2);
        }
        Context context = new Context();
        context = context.startElement(2, new PropertyValues());
        context.properties.set(106, Value.length(12.0, 4));
        context.update();
        Value value = expression.evaluate(property, context);
        if (value == null) {
            System.out.println("Error: cannot evaluate '" + stringArray[1] + "'");
            System.exit(2);
        }
        System.out.println(value.toString());
        System.exit(0);
    }
}

