/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.properties.expression;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.properties.Property;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.properties.expression.Expression;
import java.util.Hashtable;

public final class Function {
    public static final int ABS = 0;
    public static final int BODY_START = 1;
    public static final int CEILING = 2;
    public static final int FLOOR = 3;
    public static final int FROM_NEAREST_SPECIFIED_VALUE = 4;
    public static final int FROM_PARENT = 5;
    public static final int FROM_TABLE_COLUMN = 6;
    public static final int INHERITED_PROPERTY_VALUE = 7;
    public static final int LABEL_END = 8;
    public static final int MAX = 9;
    public static final int MERGE_PROPERTY_VALUES = 10;
    public static final int MIN = 11;
    public static final int PROPORTIONAL_COLUMN_WIDTH = 12;
    public static final int RGB = 13;
    public static final int RGB_ICC = 14;
    public static final int ROUND = 15;
    public static final int SYSTEM_COLOR = 16;
    public static final int SYSTEM_FONT = 17;
    public static final Function[] list = new Function[]{new Function(0, "abs", 1), new Function(1, "body-start", 0), new Function(2, "ceiling", 1), new Function(3, "floor", 1), new Function(4, "from-nearest-specified-value", 0, 1), new Function(5, "from-parent", 0, 1), new Function(6, "from-table-column", 0, 1), new Function(7, "inherited-property-value", 0, 1), new Function(8, "label-end", 0), new Function(9, "max", 2), new Function(10, "merge-property-values", 0, 1), new Function(11, "min", 2), new Function(12, "proportional-column-width", 1), new Function(13, "rgb", 3), new Function(14, "rgb-icc", 6), new Function(15, "round", 1), new Function(16, "system-color", 1), new Function(17, "system-font", 1, 2)};
    private static final Hashtable indexes = new Hashtable();
    public int index;
    public String name;
    public int minArgs;
    public int maxArgs;

    private Function(int n, String string, int n2) {
        this(n, string, n2, n2);
    }

    private Function(int n, String string, int n2, int n3) {
        this.index = n;
        this.name = string;
        this.minArgs = n2;
        this.maxArgs = n3;
    }

    public static int index(String string) {
        Integer n = (Integer)indexes.get(string);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public static Function function(String string) {
        int n = Function.index(string);
        if (n >= 0) {
            return list[n];
        }
        return null;
    }

    public static String name(int n) {
        return Function.list[n].name;
    }

    public static Value evaluate(int n, Value[] valueArray, Property property, Context context) {
        Value value = null;
        Value[] valueArray2 = null;
        String string = null;
        if (valueArray != null) {
            valueArray2 = new Value[valueArray.length];
            for (int i = 0; i < valueArray.length; ++i) {
                switch (valueArray[i].type) {
                    case 28: {
                        Expression expression = valueArray[i].expression();
                        valueArray2[i] = expression.evaluate(property, context);
                        break;
                    }
                    case 23: {
                        valueArray2[i] = Function.evaluate(valueArray[i].function(), valueArray[i].arguments(), property, context);
                        break;
                    }
                    default: {
                        valueArray2[i] = property.compute(valueArray[i], context);
                    }
                }
                if (valueArray2[i] != null) continue;
                return null;
            }
        }
        switch (n) {
            case 0: {
                value = Function.abs(valueArray2[0]);
                break;
            }
            case 2: {
                value = Function.ceiling(valueArray2[0]);
                break;
            }
            case 3: {
                value = Function.floor(valueArray2[0]);
                break;
            }
            case 9: {
                value = Function.max(valueArray2[0], valueArray2[1]);
                break;
            }
            case 11: {
                value = Function.min(valueArray2[0], valueArray2[1]);
                break;
            }
            case 15: {
                value = Function.round(valueArray2[0]);
                break;
            }
            case 1: {
                value = property.bodyStart(context);
                break;
            }
            case 4: {
                if (valueArray2 != null) {
                    string = valueArray2[0].name();
                }
                value = property.fromNearestSpecifiedValue(string, context);
                break;
            }
            case 5: {
                if (valueArray2 != null) {
                    string = valueArray2[0].name();
                }
                value = property.fromParent(string, context);
                break;
            }
            case 6: {
                if (valueArray2 != null) {
                    string = valueArray2[0].name();
                }
                value = property.fromTableColumn(string, context);
                break;
            }
            case 7: {
                if (valueArray2 != null) {
                    string = valueArray2[0].name();
                }
                value = property.inheritedPropertyValue(string, context);
                break;
            }
            case 8: {
                value = property.labelEnd(context);
                break;
            }
            case 12: {
                if (valueArray2[0].type != 3) {
                    return null;
                }
                value = Value.proportionalColumnWidth(valueArray2[0].number());
                break;
            }
        }
        return value;
    }

    private static Value abs(Value value) {
        Value value2 = null;
        switch (value.type) {
            case 3: {
                value2 = Value.number(Math.abs(value.number()));
                break;
            }
            case 4: {
                value2 = Value.length(Math.abs(value.length()), value.unit());
            }
        }
        return value2;
    }

    private static Value ceiling(Value value) {
        Value value2 = null;
        switch (value.type) {
            case 3: {
                value2 = Value.number(Math.ceil(value.number()));
                break;
            }
            case 4: {
                value2 = Value.length(Math.ceil(value.length()), value.unit());
            }
        }
        return value2;
    }

    private static Value floor(Value value) {
        Value value2 = null;
        switch (value.type) {
            case 3: {
                value2 = Value.number(Math.floor(value.number()));
                break;
            }
            case 4: {
                value2 = Value.length(Math.floor(value.length()), value.unit());
            }
        }
        return value2;
    }

    private static Value max(Value value, Value value2) {
        Value value3 = null;
        if (value2.type != value.type) {
            return null;
        }
        switch (value.type) {
            case 3: {
                value3 = Value.number(Math.max(value.number(), value2.number()));
                break;
            }
            case 4: {
                value3 = Value.length(Math.max(value.length(), value2.length()), value.unit());
            }
        }
        return value3;
    }

    private static Value min(Value value, Value value2) {
        Value value3 = null;
        if (value2.type != value.type) {
            return null;
        }
        switch (value.type) {
            case 3: {
                value3 = Value.number(Math.min(value.number(), value2.number()));
                break;
            }
            case 4: {
                value3 = Value.length(Math.min(value.length(), value2.length()), value.unit());
            }
        }
        return value3;
    }

    private static Value round(Value value) {
        Value value2 = null;
        switch (value.type) {
            case 3: {
                value2 = Value.number(Math.rint(value.number()));
                break;
            }
            case 4: {
                value2 = Value.length(Math.rint(value.length()), value.unit());
            }
        }
        return value2;
    }

    static {
        for (int i = 0; i < list.length; ++i) {
            indexes.put(Function.list[i].name, new Integer(i));
        }
    }
}

