/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.util;

import java.io.IOException;
import java.io.Writer;

public final class Base64 {
    private static byte[] fromDigit;
    private static final int DIGIT1 = 0;
    private static final int DIGIT2 = 1;
    private static final int DIGIT3_OR_EQUAL = 2;
    private static final int EQUAL = 3;
    private static final int DIGIT4_OR_EQUAL = 4;
    private static final int END = 5;
    private static final String digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private static final char[] toDigit;

    private Base64() {
    }

    public static byte[] decode(String string) {
        int n = string.length();
        byte[] byArray = new byte[3 * (n / 4) + 2];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        block11: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            byte by = 0;
            switch (n3) {
                case 0: {
                    if (c > '\u00ff' || (by = fromDigit[c]) < 0) {
                        return null;
                    }
                    n3 = 1;
                    break;
                }
                case 1: {
                    if (c > '\u00ff' || (by = fromDigit[c]) < 0) {
                        return null;
                    }
                    n3 = 2;
                    break;
                }
                case 2: {
                    if (c == '=') {
                        n3 = 3;
                        continue block11;
                    }
                    if (c > '\u00ff' || (by = fromDigit[c]) < 0) {
                        return null;
                    }
                    n3 = 4;
                    break;
                }
                case 3: {
                    if (c == '=') {
                        n3 = 5;
                        continue block11;
                    }
                    return null;
                }
                case 4: {
                    if (c == '=') {
                        n3 = 5;
                        continue block11;
                    }
                    if (c > '\u00ff' || (by = fromDigit[c]) < 0) {
                        return null;
                    }
                    n3 = 0;
                    break;
                }
                case 5: {
                    return null;
                }
                default: {
                    throw new RuntimeException("unknown state " + n3);
                }
            }
            n4 <<= 6;
            n4 |= by;
            if ((n5 += 6) < 8) continue;
            byArray[n2++] = (byte)(n4 >> (n5 -= 8) & 0xFF);
        }
        switch (n3) {
            case 0: 
            case 5: {
                break;
            }
            default: {
                return null;
            }
        }
        if (n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        return byArray;
    }

    static {
        int n;
        fromDigit = new byte[256];
        for (n = 0; n < 256; ++n) {
            Base64.fromDigit[n] = -1;
        }
        for (n = 65; n <= 90; ++n) {
            Base64.fromDigit[n] = (byte)(n - 65);
        }
        for (n = 97; n <= 122; ++n) {
            Base64.fromDigit[n] = (byte)(26 + n - 97);
        }
        for (n = 48; n <= 57; ++n) {
            Base64.fromDigit[n] = (byte)(52 + n - 48);
        }
        Base64.fromDigit[43] = 62;
        Base64.fromDigit[47] = 63;
        toDigit = digits.toCharArray();
    }

    public static final class OutputStream
    extends java.io.OutputStream {
        private Writer writer;
        private byte[] bytes;
        private int byteCount;
        private char[] encoded;
        private int encodedSize;
        private int lineLength;

        public OutputStream(Writer writer) {
            this(writer, 4096);
        }

        public OutputStream(Writer writer, int n) {
            this.writer = writer;
            this.bytes = new byte[3];
            this.byteCount = 0;
            this.encoded = new char[n];
            this.lineLength = 0;
            this.encodedSize = 0;
        }

        public void write(int n) throws IOException {
            if (this.byteCount == 3) {
                this.encode();
            }
            this.bytes[this.byteCount++] = (byte)n;
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                if (this.byteCount == 3) {
                    this.encode();
                }
                this.bytes[this.byteCount++] = byArray[n + i];
            }
        }

        public void flush() throws IOException {
            if (this.encodedSize > 0) {
                this.writer.write(this.encoded, 0, this.encodedSize);
                this.encodedSize = 0;
            }
            this.writer.flush();
        }

        public void finish() throws IOException {
            this.encode();
            if (this.lineLength > 0) {
                this.encoded[this.encodedSize++] = 13;
                this.encoded[this.encodedSize++] = 10;
                this.lineLength = 0;
            }
            this.flush();
        }

        public void close() throws IOException {
            this.finish();
            this.writer.close();
        }

        private void encode() throws IOException {
            if (this.byteCount > 0) {
                if (this.encodedSize + 6 >= this.encoded.length) {
                    this.writer.write(this.encoded, 0, this.encodedSize);
                    this.encodedSize = 0;
                }
                boolean bl = false;
                boolean bl2 = false;
                int n = this.bytes[0] & 0xFF;
                n <<= 8;
                if (this.byteCount > 1) {
                    n |= this.bytes[1] & 0xFF;
                    bl2 = true;
                }
                n <<= 8;
                if (this.byteCount > 2) {
                    n |= this.bytes[2] & 0xFF;
                    bl = true;
                }
                this.encoded[this.encodedSize + 3] = toDigit[bl ? n & 0x3F : 64];
                this.encoded[this.encodedSize + 2] = toDigit[bl2 ? (n >>>= 6) & 0x3F : 64];
                this.encoded[this.encodedSize + 1] = toDigit[(n >>>= 6) & 0x3F];
                this.encoded[this.encodedSize] = toDigit[(n >>>= 6) & 0x3F];
                this.encodedSize += 4;
                this.lineLength += 4;
                if (this.lineLength == 76) {
                    this.encoded[this.encodedSize++] = 13;
                    this.encoded[this.encodedSize++] = 10;
                    this.lineLength = 0;
                }
                this.byteCount = 0;
            }
        }
    }
}

