/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Vector;

public final class Encoding {
    private static final Name[] names = new Name[]{new Name("ISO-8859-1", "ISO8859_1", null), new Name("ISO-8859-2", "ISO8859_2", null), new Name("ISO-8859-4", "ISO8859_4", null), new Name("ISO-8859-5", "ISO8859_5", null), new Name("ISO-8859-7", "ISO8859_7", null), new Name("ISO-8859-9", "ISO8859_9", null), new Name("ISO-8859-13", "ISO8859_13", null), new Name("ISO-8859-15", "ISO8859_15", "ISO8859_15_FDIS"), new Name("KOI8-R", "KOI8_R", null), new Name("US-ASCII", "ASCII", null), new Name("UTF-8", "UTF8", null), new Name("UTF-16", "UTF-16", null), new Name("UTF-16BE", "UnicodeBigUnmarked", null), new Name("UTF-16LE", "UnicodeLittleUnmarked", null), new Name("windows-1250", "Cp1250", null), new Name("windows-1251", "Cp1251", null), new Name("windows-1252", "Cp1252", null), new Name("windows-1253", "Cp1253", null), new Name("windows-1254", "Cp1254", null), new Name("windows-1257", "Cp1257", null), new Name(null, "UnicodeBig", null), new Name(null, "UnicodeLittle", null), new Name("Big5", "Big5", null), new Name("Big5-HKSCS", "Big5_HKSCS", null), new Name("EUC-JP", "EUC_JP", null), new Name("EUC-KR", "EUC_KR", null), new Name("GB18030", "GB18030", null), new Name("GB2312", "EUC_CN", null), new Name("GBK", "GBK", null), new Name("IBM-Thai", "Cp838", null), new Name("IBM00858", "Cp858", null), new Name("IBM01140", "Cp1140", null), new Name("IBM01141", "Cp1141", null), new Name("IBM01142", "Cp1142", null), new Name("IBM01143", "Cp1143", null), new Name("IBM01144", "Cp1144", null), new Name("IBM01145", "Cp1145", null), new Name("IBM01146", "Cp1146", null), new Name("IBM01147", "Cp1147", null), new Name("IBM01148", "Cp1148", null), new Name("IBM01149", "Cp1149", null), new Name("IBM037", "Cp037", null), new Name("IBM1026", "Cp1026", null), new Name("IBM1047", "Cp1047", null), new Name("IBM273", "Cp273", null), new Name("IBM277", "Cp277", null), new Name("IBM278", "Cp278", null), new Name("IBM280", "Cp280", null), new Name("IBM284", "Cp284", null), new Name("IBM285", "Cp285", null), new Name("IBM297", "Cp297", null), new Name("IBM297", "Cp297", null), new Name("IBM420", "Cp420", null), new Name("IBM424", "Cp424", null), new Name("IBM437", "Cp437", null), new Name("IBM500", "Cp500", null), new Name("IBM775", "Cp775", null), new Name("IBM850", "Cp850", null), new Name("IBM852", "Cp852", null), new Name("IBM855", "Cp855", null), new Name("IBM857", "Cp857", null), new Name("IBM860", "Cp860", null), new Name("IBM861", "Cp861", null), new Name("IBM862", "Cp862", null), new Name("IBM863", "Cp863", null), new Name("IBM864", "Cp864", null), new Name("IBM865", "Cp865", null), new Name("IBM866", "Cp866", null), new Name("IBM868", "Cp868", null), new Name("IBM869", "Cp869", null), new Name("IBM870", "Cp870", null), new Name("IBM871", "Cp871", null), new Name("IBM918", "Cp918", null), new Name("ISO-2022-CN", "ISO2022CN", null), new Name("ISO-2022-JP", "ISO2022JP", null), new Name("ISO-2022-KR", "ISO2022KR", null), new Name("ISO-8859-3", "ISO8859_3", null), new Name("ISO-8859-6", "ISO8859_6", null), new Name("ISO-8859-8", "ISO8859_8", null), new Name("Shift_JIS", "SJIS", null), new Name("TIS-620", "TIS620", null), new Name("windows-1255", "Cp1255", null), new Name("windows-1256", "Cp1256", null), new Name("windows-1258", "Cp1258", null), new Name("windows-31j", "MS932", null), new Name("x-Big5_Solaris", "Big5_Solaris", null), new Name("x-euc-jp-linux", "EUC_JP_LINUX", null), new Name("x-EUC-TW", "EUC_TW", null), new Name("x-eucJP-Open", "EUC_JP_Solaris", null), new Name("x-IBM1006", "Cp1006", null), new Name("x-IBM1025", "Cp1025", null), new Name("x-IBM1046", "Cp1046", null), new Name("x-IBM1097", "Cp1097", null), new Name("x-IBM1098", "Cp1098", null), new Name("x-IBM1112", "Cp1112", null), new Name("x-IBM1122", "Cp1122", null), new Name("x-IBM1123", "Cp1123", null), new Name("x-IBM1124", "Cp1124", null), new Name("x-IBM1381", "Cp1381", null), new Name("x-IBM1383", "Cp1383", null), new Name("x-IBM33722", "Cp33722", null), new Name("x-IBM737", "Cp737", null), new Name("x-IBM856", "Cp856", null), new Name("x-IBM874", "Cp874", null), new Name("x-IBM875", "Cp875", null), new Name("x-IBM921", "Cp921", null), new Name("x-IBM922", "Cp922", null), new Name("x-IBM930", "Cp930", null), new Name("x-IBM933", "Cp933", null), new Name("x-IBM935", "Cp935", null), new Name("x-IBM937", "Cp937", null), new Name("x-IBM939", "Cp939", null), new Name("x-IBM942", "Cp942", null), new Name("x-IBM942C", "Cp942C", null), new Name("x-IBM943", "Cp943", null), new Name("x-IBM943C", "Cp943C", null), new Name("x-IBM948", "Cp948", null), new Name("x-IBM949", "Cp949", null), new Name("x-IBM949C", "Cp949C", null), new Name("x-IBM950", "Cp950", null), new Name("x-IBM964", "Cp964", null), new Name("x-IBM970", "Cp970", null), new Name("x-ISCII91", "ISCII91", null), new Name("x-ISO2022-CN-CNS", "ISO2022_CN_CNS", null), new Name("x-ISO2022-CN-GB", "ISO2022_CN_GB", null), new Name("x-iso-8859-11", "x-iso-8859-11", null), new Name("x-JISAutoDetect", "JISAutoDetect", null), new Name("x-Johab", "x-Johab", null), new Name("x-MacArabic", "MacArabic", null), new Name("x-MacCentralEurope", "MacCentralEurope", null), new Name("x-MacCroatian", "MacCroatian", null), new Name("x-MacCyrillic", "MacCyrillic", null), new Name("x-MacDingBat", "MacDingBat", null), new Name("x-MacGreek", "MacGreek", null), new Name("x-MacHebrew", "MacHebrew", null), new Name("x-MacIceland", "MacIceland", null), new Name("x-MacRoman", "MacRoman", null), new Name("x-MacRomania", "MacRomania", null), new Name("x-MacSymbol", "MacSymbol", null), new Name("x-MacThai", "MacThai", null), new Name("x-MacTurkish", "MacTurkish", null), new Name("x-MacUkraine", "MacUkraine", null), new Name("x-MS950-HKSCS", "MS950_HKSCS", null), new Name("x-mswin-936", "MS936", null), new Name("x-PCK", "PCK", null), new Name("x-windows-874", "MS874", null), new Name("x-windows-949", "MS949", null), new Name("x-windows-950", "MS950", null)};
    private static Hashtable lookup = new Hashtable();

    public static String officialName(String string) {
        Integer n = (Integer)lookup.get(string.toUpperCase());
        if (n != null) {
            return Encoding.names[n.intValue()].official;
        }
        return null;
    }

    public static String internalName(String string) {
        Integer n = (Integer)lookup.get(string.toUpperCase());
        if (n != null) {
            int n2 = n;
            string = Encoding.names[n2].internal;
            if (Encoding.names[n2].variant != null) {
                String string2 = System.getProperty("java.version");
                if (string.equals("ISO8859_15") && string2 != null && string2.compareTo("1.4") < 0) {
                    string = Encoding.names[n2].variant;
                }
            }
            return string;
        }
        return null;
    }

    public static String[] list() {
        Vector<String> vector = new Vector<String>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < names.length; ++i) {
            OutputStreamWriter outputStreamWriter;
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, Encoding.names[i].internal);
                vector.addElement(Encoding.names[i].internal);
                outputStreamWriter.close();
                continue;
            }
            catch (Throwable throwable) {
                if (Encoding.names[i].variant == null) continue;
                try {
                    outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, Encoding.names[i].variant);
                    vector.addElement(Encoding.names[i].variant);
                    outputStreamWriter.close();
                    continue;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    static {
        for (int i = 0; i < names.length; ++i) {
            Integer n = new Integer(i);
            if (Encoding.names[i].official != null) {
                lookup.put(Encoding.names[i].official.toUpperCase(), n);
            }
            lookup.put(Encoding.names[i].internal.toUpperCase(), n);
            if (Encoding.names[i].variant == null) continue;
            lookup.put(Encoding.names[i].variant.toUpperCase(), n);
        }
    }

    private static final class Name {
        final String official;
        final String internal;
        final String variant;

        Name(String string, String string2, String string3) {
            this.official = string;
            this.internal = string2;
            this.variant = string3;
        }
    }
}

