/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.util;

import com.xmlmind.fo.util.Base64;
import com.xmlmind.fo.util.StringUtil;
import com.xmlmind.fo.util.SystemUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;

public final class URLUtil {
    private static final int[] fromHexDigit = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    private URLUtil() {
    }

    public static String fileToLocation(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        if (string == null) {
            string = file.getPath();
        }
        StringBuffer stringBuffer = new StringBuffer("file:");
        if (!string.startsWith(File.separator)) {
            stringBuffer.append('/');
        }
        String[] stringArray = StringUtil.split(string, File.separatorChar);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (i > 0) {
                stringBuffer.append('/');
            }
            URLUtil.escapePathSegment(string2, "UTF8", stringBuffer);
        }
        if (file.isDirectory() && stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
            stringBuffer.append('/');
        }
        return stringBuffer.toString();
    }

    private static void escapePathSegment(String string, String string2, StringBuffer stringBuffer) {
        char[] cArray = new char[1];
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '!': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case ':': 
                case '=': 
                case '@': 
                case '_': 
                case '~': {
                    stringBuffer.append(c);
                    continue block5;
                }
                default: {
                    byte[] byArray;
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                        stringBuffer.append(c);
                        continue block5;
                    }
                    try {
                        cArray[0] = c;
                        byArray = new String(cArray).getBytes(string2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                        return;
                    }
                    for (int j = 0; j < byArray.length; ++j) {
                        String string3 = Integer.toHexString(byArray[j] & 0xFF);
                        stringBuffer.append('%');
                        if (string3.length() == 1) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string3.toUpperCase());
                    }
                }
            }
        }
    }

    public static URL fileToURL(File file) {
        try {
            return new URL(URLUtil.fileToLocation(file));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static File urlToFile(URL uRL) {
        if (!"file".equals(uRL.getProtocol())) {
            return null;
        }
        return URLUtil.urlToFile(uRL.getHost(), uRL.getFile());
    }

    private static File urlToFile(String string, String string2) {
        String string3;
        int n;
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "/";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = StringUtil.split(string2, '/');
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string4 = stringArray[i];
            if (i > 0) {
                stringBuffer.append(File.separatorChar);
            }
            stringBuffer.append(URLUtil.decode(string4, "UTF8"));
        }
        if (SystemUtil.IS_WINDOWS) {
            if (string != null) {
                stringBuffer.insert(0, URLUtil.decode(string, "UTF8"));
                stringBuffer.insert(0, "\\\\");
            } else {
                if (stringBuffer.length() < 4 || stringBuffer.charAt(0) != File.separatorChar || !URLUtil.isDriveLetter(stringBuffer.charAt(1)) || stringBuffer.charAt(2) != ':' || stringBuffer.charAt(3) == File.separatorChar) {
                    // empty if block
                }
                stringBuffer.deleteCharAt(0);
            }
        }
        if ((n = (string3 = stringBuffer.toString()).length() - 1) > 0 && string3.charAt(n) == File.separatorChar && string3.lastIndexOf(File.separatorChar, n - 1) >= 0) {
            string3 = string3.substring(0, n);
        }
        return new File(string3);
    }

    private static boolean isDriveLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static String decode(String string, String string2) {
        byte[] byArray;
        if (string.indexOf(37) < 0) {
            return string;
        }
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5;
            int n6 = byArray[i];
            if (n6 == 37 && i + 2 < n && (n5 = URLUtil.fromHexDigit(byArray[i + 1])) >= 0 && (n4 = URLUtil.fromHexDigit(byArray[i + 2])) >= 0) {
                n3 = n5 << 4 | n4;
                i += 2;
            } else {
                n3 = n6;
            }
            byArray2[n2++] = (byte)n3;
        }
        try {
            return new String(byArray2, 0, n2, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    private static final int fromHexDigit(int n) {
        if (n < 48 || n > 102) {
            return -1;
        }
        return fromHexDigit[n - 48];
    }

    public static File locationToFile(String string) {
        int n;
        if (!string.startsWith("file:")) {
            return null;
        }
        string = string.substring(5);
        String string2 = null;
        if (string.startsWith("//") && (n = string.indexOf(47, 2)) >= 2) {
            if (n > 2) {
                string2 = string.substring(2, n);
            }
            string = string.substring(n);
        }
        return URLUtil.urlToFile(string2, string);
    }

    public static String locationToFilename(String string) {
        File file = URLUtil.locationToFile(string);
        if (file == null) {
            return null;
        }
        return file.getPath();
    }

    public static URL urlOrFile(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (file.isFile() && file.isAbsolute()) {
                return URLUtil.fileToURL(file);
            }
            return null;
        }
    }

    public static String locationOrFilename(String string) {
        try {
            new URL(string);
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (file.isFile() && file.isAbsolute()) {
                return URLUtil.fileToLocation(file);
            }
            return string;
        }
    }

    public static String normalizeMIMEType(String string) {
        int n = string.indexOf(59);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string.toLowerCase().trim();
    }

    public static InputStream openStream(String string) throws IOException, MalformedURLException {
        if (string.startsWith("data:")) {
            int n = string.indexOf(";base64,", 5);
            if (n < 0) {
                throw new IOException("expects the data of '" + string + "' to be encoded as base64");
            }
            byte[] byArray = Base64.decode(string.substring(n + 8));
            if (byArray == null) {
                throw new IOException("cannot decode the base64-encoded data of '" + string + "'");
            }
            return new ByteArrayInputStream(byArray);
        }
        if (string.startsWith("file:")) {
            return new FileInputStream(URLUtil.locationToFile(string));
        }
        return new URL(string).openStream();
    }
}

