/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import common.DataParser;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class AssertUtils {
    public static boolean Test(boolean bl, String string) {
        if (!bl) {
            return AssertUtils.TestFail(string);
        }
        return true;
    }

    public static boolean TestFail(String string) {
        CommonUtils.print_error("Assertion failed: " + string);
        Thread.currentThread();
        Thread.dumpStack();
        return false;
    }

    public static boolean TestNotNull(Object object, String string) {
        if (object == null) {
            CommonUtils.print_error("Assertion failed: " + string + " is null");
            Thread.currentThread();
            Thread.dumpStack();
            return false;
        }
        return true;
    }

    public static boolean TestIsNumber(String string) {
        if (!CommonUtils.isNumber(string)) {
            CommonUtils.print_error("Assertion failed: '" + string + "' is not a number");
            Thread.currentThread();
            Thread.dumpStack();
            return false;
        }
        return true;
    }

    public static boolean TestUnique(Object object, Collection collection) {
        if (collection.contains(object)) {
            CommonUtils.print_error("Assertion failed: '" + object + "' is not unique in: " + collection);
            Thread.currentThread();
            Thread.dumpStack();
            return false;
        }
        return true;
    }

    public static boolean TestSetValue(String string, String string2) {
        Set set = CommonUtils.toSet(string2);
        if (set.contains(string)) {
            return true;
        }
        CommonUtils.print_error("Assertion failed: '" + string + "' is not in: " + string2);
        Thread.currentThread();
        Thread.dumpStack();
        return false;
    }

    public static boolean TestArch(String string) {
        return AssertUtils.TestSetValue(string, "x86, x64");
    }

    public static boolean TestPID(int n) {
        return AssertUtils.TestRange(n, 0, Integer.MAX_VALUE);
    }

    public static boolean TestPort(int n) {
        return AssertUtils.TestRange(n, 0, 65535);
    }

    public static boolean TestPatchI(byte[] byArray, int n, int n2) {
        try {
            DataParser dataParser = new DataParser(byArray);
            dataParser.jump(n2);
            int n3 = dataParser.readInt();
            if (n3 == n) {
                return true;
            }
            CommonUtils.print_error("Assertion failed: 0x" + CommonUtils.toHex(n3) + " at " + n2 + " is not 0x" + CommonUtils.toHex(n));
            Thread.currentThread();
            Thread.dumpStack();
            return false;
        }
        catch (IOException iOException) {
            CommonUtils.print_error("Assertion failed: jump to " + n2 + " exception: " + iOException.getMessage());
            Thread.currentThread();
            Thread.dumpStack();
            return false;
        }
    }

    public static boolean TestPatchS(byte[] byArray, int n, int n2) {
        try {
            DataParser dataParser = new DataParser(byArray);
            dataParser.jump(n2);
            int n3 = dataParser.readShort();
            if (n3 == n) {
                return true;
            }
            CommonUtils.print_error("Assertion failed: 0x" + CommonUtils.toHex(n3) + " at " + n2 + " is not 0x" + CommonUtils.toHex(n));
            Thread.currentThread();
            Thread.dumpStack();
            return false;
        }
        catch (IOException iOException) {
            CommonUtils.print_error("Assertion failed: jump to " + n2 + " exception: " + iOException.getMessage());
            Thread.currentThread();
            Thread.dumpStack();
            return false;
        }
    }

    public static boolean TestPatch(String string, String string2, int n) {
        String string3 = string.substring(n, n + string2.length());
        if (string3.equals(string2)) {
            return true;
        }
        CommonUtils.print_error("Assertion failed: " + CommonUtils.toHexString(CommonUtils.toBytes(string3)) + " at " + n + " is not " + CommonUtils.toHexString(CommonUtils.toBytes(string2)));
        Thread.currentThread();
        Thread.dumpStack();
        return false;
    }

    public static boolean TestRange(int n, int n2, int n3) {
        if (n >= n2 && n <= n3) {
            return true;
        }
        CommonUtils.print_error("Assertion failed: " + n2 + " <= " + n + " (value) <= " + n3 + " does not hold");
        Thread.currentThread();
        Thread.dumpStack();
        return false;
    }
}

