/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AddressList;
import common.AssertUtils;
import common.BeaconDataStore;
import common.CHECKINSTATE;
import common.CommonHTMLUtils;
import common.CommonUtils;
import common.DataParser;
import common.Loggable;
import common.MudgeSanity;
import common.PivotHint;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class BeaconEntry
implements Serializable,
Loggable {
    public static final int LINK_NONE = 0;
    public static final int LINK_GOOD = 1;
    public static final int LINK_BROKEN = 2;
    protected String id = "";
    protected String pid = "";
    protected String ver = "";
    protected int build = 0;
    protected String intz = "";
    protected String comp = "";
    protected String user = "";
    protected String is64 = "0";
    protected String ext = "";
    protected long last = System.currentTimeMillis();
    protected long diff = 0L;
    protected boolean supportsSleep = true;
    protected long sleep = -1L;
    protected long jitter = -1L;
    protected long sleepFromSleepCommand = -1L;
    protected long jitterFromSleepCommand = -1L;
    protected int state = 0;
    protected int hint = 0;
    protected String pbid = "";
    protected String note = "";
    protected String barch = "";
    protected boolean alive = true;
    protected String port = "";
    protected boolean sane = false;
    protected boolean xssSafe = false;
    protected String chst = null;
    protected String proc = "";
    protected String accent = "";
    protected String lname = "";
    protected byte[] ptr_gmh;
    protected byte[] ptr_gpa;
    protected String impersonated = "";
    protected String impersonatedFromPthCommand = "";
    protected BeaconDataStore dataStore = new BeaconDataStore();
    protected boolean requestingMetadata = false;
    protected static final long serialVersionUID = 1L;
    public static final int METADATA_FLAG_NOTHING = 1;
    public static final int METADATA_FLAG_X64_AGENT = 2;
    public static final int METADATA_FLAG_X64_SYSTEM = 4;
    public static final int METADATA_FLAG_ADMIN = 8;

    public int getBuild() {
        return this.build;
    }

    public String getId() {
        return this.id;
    }

    public boolean sane() {
        return this.sane;
    }

    public boolean xssSafe() {
        return this.xssSafe;
    }

    public String getListenerName() {
        return this.lname;
    }

    public String getPort() {
        return this.port;
    }

    public void die() {
        this.alive = false;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public boolean isActive() {
        if (!this.isAlive()) {
            return false;
        }
        return !this.isLinked() || this.getLinkState() == 1;
    }

    public String getComputer() {
        return this.comp;
    }

    public boolean isEmpty() {
        return this.intz == null || this.intz.length() == 0;
    }

    public String getUser() {
        return this.user;
    }

    public String getInternal() {
        return this.intz;
    }

    public String getExternal() {
        return this.ext;
    }

    public String getPid() {
        if (this.isSSH()) {
            return "";
        }
        return this.pid;
    }

    public PivotHint getPivotHint() {
        return new PivotHint(this.hint);
    }

    public double getVersion() {
        try {
            if (this.isSSH() && this.ver.startsWith("CYGWIN_NT-")) {
                return Double.parseDouble(CommonUtils.strip(this.ver, "CYGWIN_NT-"));
            }
            if (this.isBeacon()) {
                return Double.parseDouble(this.ver);
            }
            return 0.0;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public String getNote() {
        return this.note;
    }

    public String getParentId() {
        return this.pbid;
    }

    public boolean isLinked() {
        return this.pbid.length() > 0;
    }

    public int getLinkState() {
        return this.state;
    }

    public byte[] getFunctionHint(String string) {
        AssertUtils.TestSetValue(string, "GetProcAddress, GetModuleHandleA");
        if ("GetProcAddress".equals(string)) {
            return this.ptr_gpa;
        }
        if ("GetModuleHandleA".equals(string)) {
            return this.ptr_gmh;
        }
        throw new RuntimeException("Unknown function hint '" + string + "'");
    }

    public String getImpersonated() {
        return this.impersonated;
    }

    public String arch() {
        return this.barch;
    }

    public boolean is64() {
        if (!this.is64.equals("1") && !this.is64.equals("0")) {
            CommonUtils.print_warn("is64 is: '" + this.is64 + "'");
        }
        return this.is64.equals("1");
    }

    public boolean isAdmin() {
        return this.getUser().endsWith(" *");
    }

    public void setExternal(String string) {
        if (this.checkExt(string)) {
            this.ext = string;
        } else {
            CommonUtils.print_error("Refused to assign: '" + string + "' [was: '" + this.ext + "'] as external address to Beacon: '" + this.id + "'");
        }
    }

    public void setLastCheckin(long l) {
        this.last = l;
    }

    public void setNote(String string) {
        this.note = string;
    }

    public void setImpersonated(String string) {
        this.impersonated = string;
    }

    public void storeImpersonated(String string) {
        this.impersonatedFromPthCommand = string;
    }

    public String getStoredImpersonated() {
        return this.impersonatedFromPthCommand;
    }

    public void setAccent(String string) {
        this.accent = string;
    }

    public String getAccent() {
        return this.accent;
    }

    public boolean idle(long l) {
        return this.diff >= l;
    }

    public String getLastCheckin() {
        String string = "ms";
        long l = this.diff;
        if (l <= 1000L) {
            return l + string;
        }
        string = "s";
        if ((l /= 1000L) > 60L) {
            l /= 60L;
            string = "m";
        }
        if (l > 60L) {
            l /= 60L;
            string = "h";
        }
        return l + string;
    }

    public long getLast() {
        return this.last;
    }

    private CHECKINSTATE A(long l) {
        if (this.diff > l * 1000L) {
            return CHECKINSTATE.BAD;
        }
        if (this.isLinked() && this.state != 1) {
            return CHECKINSTATE.BAD;
        }
        if (!this.alive) {
            return CHECKINSTATE.BAD;
        }
        return CHECKINSTATE.GOOD;
    }

    public CHECKINSTATE getCheckInStateUsingSleep(long l) {
        long l2 = this.sleep > 0L ? this.sleep * (100L + this.jitter) / 100L : 1L;
        long l3 = l2 * l;
        return this.A(l3);
    }

    public CHECKINSTATE getCheckInStateUsingPeriod(long l) {
        return this.A(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSupportsSleep(boolean bl) {
        BeaconEntry beaconEntry = this;
        synchronized (beaconEntry) {
            this.supportsSleep = bl;
        }
    }

    public boolean getSupportsSleep() {
        return this.supportsSleep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSleepAndJitter(long l, long l2) {
        BeaconEntry beaconEntry = this;
        synchronized (beaconEntry) {
            this.sleep = l;
            this.jitter = l2;
        }
    }

    public long getSleep() {
        return this.sleep;
    }

    public long getJitter() {
        return this.jitter;
    }

    public void clearPendingSleepCommand() {
        this.storeSleepCommand(-1L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSleepCommand(long l, long l2) {
        BeaconEntry beaconEntry = this;
        synchronized (beaconEntry) {
            this.sleepFromSleepCommand = l;
            this.jitterFromSleepCommand = l2;
        }
    }

    public long getSleepFromSleepCommand() {
        return this.sleepFromSleepCommand;
    }

    public long getJitterFromSleepCommand() {
        return this.jitterFromSleepCommand;
    }

    public boolean updateFromSleepCommandPending() {
        return this.sleepFromSleepCommand >= 0L && this.jitterFromSleepCommand >= 0L;
    }

    public boolean isRequestingMetadata() {
        return this.requestingMetadata;
    }

    public void setRequestingMetadata(boolean bl) {
        this.requestingMetadata = bl;
    }

    public BeaconEntry(byte[] byArray, String string, String string2, String string3) {
        boolean bl;
        Object object;
        try {
            object = new DataParser(byArray);
            ((DataParser)object).big();
            ((DataParser)object).consume(20);
            this.id = Long.toString(CommonUtils.toUnsignedInt(((DataParser)object).readInt()));
            this.pid = Long.toString(CommonUtils.toUnsignedInt(((DataParser)object).readInt()));
            this.port = Integer.toString(CommonUtils.toUnsignedShort(((DataParser)object).readShort()));
            byte by = ((DataParser)object).readByte();
            if (CommonUtils.Flag(by, 1)) {
                this.barch = "";
                this.pid = "";
                this.is64 = "";
            } else {
                this.barch = CommonUtils.Flag(by, 2) ? "x64" : "x86";
            }
            this.is64 = CommonUtils.Flag(by, 4) ? "1" : "0";
            bl = CommonUtils.Flag(by, 8);
            byte by2 = ((DataParser)object).readByte();
            byte by3 = ((DataParser)object).readByte();
            this.ver = by2 + "." + by3;
            this.build = ((DataParser)object).readShort();
            byte[] byArray2 = ((DataParser)object).readBytes(4);
            this.ptr_gmh = ((DataParser)object).readBytes(4);
            this.ptr_gpa = ((DataParser)object).readBytes(4);
            if ("x64".equals(this.barch)) {
                this.ptr_gmh = CommonUtils.join(byArray2, this.ptr_gmh);
                this.ptr_gpa = CommonUtils.join(byArray2, this.ptr_gpa);
            }
            this.ptr_gmh = CommonUtils.bswap(this.ptr_gmh);
            this.ptr_gpa = CommonUtils.bswap(this.ptr_gpa);
            ((DataParser)object).little();
            this.intz = AddressList.toIP(CommonUtils.toUnsignedInt(((DataParser)object).readInt()));
            ((DataParser)object).big();
            if ("0.0.0.0".equals(this.intz)) {
                this.intz = "unknown";
            }
        }
        catch (IOException iOException) {
            MudgeSanity.logException("Could not parse metadata!", iOException, false);
            this.sane = false;
            return;
        }
        object = CommonUtils.bString(Arrays.copyOfRange(byArray, 51, byArray.length), string);
        String[] stringArray = ((String)object).split("\t");
        if (stringArray.length > 0) {
            this.comp = stringArray[0];
        }
        if (stringArray.length > 1) {
            this.user = stringArray[1];
        }
        if (stringArray.length > 2) {
            if (this.isSSH()) {
                this.ver = stringArray[2];
            } else {
                this.proc = stringArray[2];
            }
        }
        if (bl) {
            this.user = this.user + " *";
        }
        this.ext = string2;
        this.chst = string;
        this.lname = string3;
        this.sane = this.sanity();
        this.xssSafe = this.xssSafety();
    }

    public String getCharset() {
        return this.chst;
    }

    public boolean sanity() {
        LinkedList linkedList = new LinkedList();
        try {
            return this._sanity(linkedList);
        }
        catch (Exception exception) {
            this.id = "0";
            this.intz = "";
            MudgeSanity.logException("Validator blew up!", exception, false);
            return false;
        }
    }

    public boolean xssSafety() {
        LinkedList linkedList = new LinkedList();
        try {
            return this._XSSSafety(linkedList);
        }
        catch (Exception exception) {
            this.id = "0";
            this.intz = "";
            MudgeSanity.logException("XSS Safety Validator blew up!", exception, false);
            return false;
        }
    }

    public boolean checkExt(String string) {
        if (string == null) {
            return true;
        }
        if ("".equals(string)) {
            return true;
        }
        String string2 = string;
        string2 = string.endsWith(" \u26af \u26af") && string.length() > 5 ? string.substring(0, string.length() - 4) : (string.endsWith(" \u26af\u26af") && string.length() > 4 ? string.substring(0, string.length() - 3) : string);
        return CommonUtils.isIP(string2) || CommonUtils.isIPv6(string2) || "unknown".equals(string2);
    }

    public BeaconDataStore getDataStore() {
        return this.dataStore;
    }

    public String getProcess() {
        return this.proc;
    }

    public boolean _sanity(LinkedList linkedList) {
        if (!CommonUtils.isNumber(this.id)) {
            linkedList.add("id '" + this.id + "' is not a number");
            this.id = "0";
        }
        if (!("".equals(this.intz) || CommonUtils.isIP(this.intz) || CommonUtils.isIPv6(this.intz) || "unknown".equals(this.intz))) {
            linkedList.add("internal address '" + this.intz + "' is not an address");
            this.intz = "";
        }
        if (!this.checkExt(this.ext)) {
            linkedList.add("external address '" + this.ext + "' is not an address");
            this.ext = "";
        }
        if (!"".equals(this.pid) && !CommonUtils.isNumber(this.pid)) {
            linkedList.add("pid '" + this.pid + "' is not a number");
            this.pid = "0";
        }
        if (!"".equals(this.port) && !CommonUtils.isNumber(this.port)) {
            linkedList.add("port '" + this.port + "' is not a number");
            this.port = "";
        }
        if (!"".equals(this.is64) && !CommonUtils.isNumber(this.is64)) {
            linkedList.add("is64 '" + this.is64 + "' is not a number");
            this.is64 = "";
        }
        if (this.ver != null && this.ver.length() > 64) {
            linkedList.add("ver '" + this.ver + "' is too long. Truncating");
            this.ver = this.ver.substring(0, 63);
        }
        if (this.comp != null && this.comp.length() > 64) {
            linkedList.add("comp '" + this.comp + "' is too long. Truncating");
            this.comp = this.comp.substring(0, 63);
        }
        if (this.user != null && this.user.length() > 64) {
            linkedList.add("user '" + this.user + "' is too long. Truncating");
            this.user = this.user.substring(0, 63);
        }
        if (linkedList.size() > 0) {
            Iterator iterator = linkedList.iterator();
            CommonUtils.print_error("Beacon entry did not validate");
            while (iterator.hasNext()) {
                System.out.println("\t" + CommonUtils.scrub(iterator.next() + ""));
            }
            return false;
        }
        return true;
    }

    public boolean _XSSSafety(LinkedList linkedList) {
        if (CommonHTMLUtils.potentialUserNameXSS(this.user)) {
            linkedList.add("User name contains suspect characters: " + this.user);
        }
        if (CommonHTMLUtils.potentialXSS(this.comp)) {
            linkedList.add("Computer name contains suspect characters: " + this.comp);
        }
        if (CommonHTMLUtils.potentialXSS(this.proc)) {
            linkedList.add("Process contains suspect characters: " + this.proc);
        }
        if (CommonHTMLUtils.potentialXSS(this.chst)) {
            linkedList.add("Charset name contains suspect characters: " + this.chst);
        }
        if (CommonHTMLUtils.potentialXSS(this.ext)) {
            linkedList.add("External Address contains suspect characters: " + this.ext);
        }
        if (CommonHTMLUtils.potentialXSS(this.ver)) {
            linkedList.add("Version contains suspect characters: " + this.ver);
        }
        return linkedList.size() <= 0;
    }

    public BeaconEntry(String string) {
        this.id = string;
        this.sane = this.sanity();
        this.xssSafe = this.xssSafety();
    }

    public BeaconEntry() {
    }

    public void touch() {
        this.diff = System.currentTimeMillis() - this.last;
    }

    public BeaconEntry copy() {
        BeaconEntry beaconEntry = new BeaconEntry(this.id);
        beaconEntry.pid = this.pid;
        beaconEntry.ver = this.ver;
        beaconEntry.build = this.build;
        beaconEntry.intz = this.intz;
        beaconEntry.comp = this.comp;
        beaconEntry.user = this.user;
        beaconEntry.is64 = this.is64;
        beaconEntry.ext = this.ext;
        beaconEntry.diff = this.diff;
        beaconEntry.last = this.last;
        beaconEntry.supportsSleep = this.supportsSleep;
        beaconEntry.sleep = this.sleep;
        beaconEntry.jitter = this.jitter;
        beaconEntry.sleepFromSleepCommand = this.sleepFromSleepCommand;
        beaconEntry.jitterFromSleepCommand = this.jitterFromSleepCommand;
        beaconEntry.state = this.state;
        beaconEntry.pbid = this.pbid;
        beaconEntry.note = this.note;
        beaconEntry.alive = this.alive;
        beaconEntry.barch = this.barch;
        beaconEntry.port = this.port;
        beaconEntry.chst = this.chst;
        beaconEntry.hint = this.hint;
        beaconEntry.proc = this.proc;
        beaconEntry.accent = this.accent;
        beaconEntry.lname = this.lname;
        beaconEntry.ptr_gmh = this.ptr_gmh;
        beaconEntry.ptr_gpa = this.ptr_gpa;
        beaconEntry.impersonated = this.impersonated;
        beaconEntry.impersonatedFromPthCommand = this.impersonatedFromPthCommand;
        beaconEntry.dataStore = this.dataStore;
        return beaconEntry;
    }

    public void update(BeaconEntry beaconEntry) {
        this.pid = beaconEntry.pid;
        this.ver = beaconEntry.ver;
        this.build = beaconEntry.build;
        this.intz = beaconEntry.intz;
        this.comp = beaconEntry.comp;
        this.user = beaconEntry.user;
        this.is64 = beaconEntry.is64;
        this.ext = beaconEntry.ext;
        this.last = beaconEntry.last;
        if (this.isLinked()) {
            this.state = 1;
        }
        this.pbid = beaconEntry.pbid;
        this.alive = beaconEntry.alive;
        this.barch = beaconEntry.barch;
        this.port = beaconEntry.port;
        this.chst = beaconEntry.chst;
        this.proc = beaconEntry.proc;
        this.lname = beaconEntry.lname;
        this.ptr_gmh = beaconEntry.ptr_gmh;
        this.ptr_gpa = beaconEntry.ptr_gpa;
    }

    public Map toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("external", this.ext);
        hashMap.put("internal", this.intz);
        hashMap.put("host", this.intz);
        hashMap.put("user", this.user);
        hashMap.put("computer", this.comp);
        hashMap.put("last", this.diff + "");
        hashMap.put("lastf", this.getLastCheckin());
        hashMap.put("sleep", new Object[]{this.sleep, this.jitter, this.supportsSleep});
        hashMap.put("id", this.id);
        hashMap.put("pid", this.getPid());
        hashMap.put("is64", this.is64);
        hashMap.put("pbid", this.pbid);
        hashMap.put("note", this.note);
        hashMap.put("barch", this.barch);
        hashMap.put("arch", this.barch);
        hashMap.put("port", this.getPort());
        hashMap.put("charset", this.getCharset());
        hashMap.put("phint", this.hint + "");
        hashMap.put("process", this.proc);
        hashMap.put("_accent", this.accent);
        hashMap.put("listener", this.lname);
        hashMap.put("build", this.build);
        hashMap.put("impersonated", this.impersonated);
        if (this.alive) {
            hashMap.put("alive", "true");
        } else {
            hashMap.put("alive", "false");
        }
        if (this.state != 0) {
            if (this.state == 1) {
                hashMap.put("state", "good");
            } else if (this.state == 2) {
                hashMap.put("state", "broken");
            }
        }
        hashMap.put("os", this.getOperatingSystem());
        hashMap.put("ver", Double.toString(this.getVersion()));
        if (this.isSSH()) {
            hashMap.put("session", "ssh");
        } else if (this.isBeacon()) {
            hashMap.put("session", "beacon");
        } else {
            hashMap.put("session", "unknown");
        }
        return hashMap;
    }

    public boolean wantsMetadata() {
        return this.user.length() == 0 || this.isRequestingMetadata();
    }

    public String title() {
        if (this.isBeacon()) {
            return this.title("Beacon");
        }
        return "SSH " + this.intz;
    }

    public String title(String string) {
        return string + " " + this.intz + "@" + this.pid;
    }

    public String toString() {
        return this.getId() + " -> " + this.title() + ", " + this.getLastCheckin();
    }

    public Stack eventArguments() {
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getHashWrapper(this.toMap()));
        stack.push(SleepUtils.getScalar(this.id));
        return stack;
    }

    public void link(String string, int n) {
        this.pbid = string;
        this.state = 1;
        this.hint = n;
    }

    public void delink() {
        this.state = 2;
        this.lname = "";
    }

    @Override
    public String getBeaconId() {
        return this.id;
    }

    @Override
    public String getLogFile() {
        if (this.isSSH()) {
            return "ssh_" + this.id + ".log";
        }
        return "beacon_" + this.id + ".log";
    }

    @Override
    public String getLogFolder() {
        return null;
    }

    @Override
    public long getLogLimit() {
        return 0L;
    }

    @Override
    public String getLogEventName() {
        return "Beacon Entry";
    }

    public boolean isBeacon() {
        return !this.isSSH();
    }

    public boolean isSSH() {
        return "session".equals(CommonUtils.session(this.id));
    }

    public String getOperatingSystem() {
        if (this.isBeacon()) {
            return "Windows";
        }
        if ("".equals(this.ver)) {
            return "Unknown";
        }
        if ("Darwin".equals(this.ver)) {
            return "MacOS X";
        }
        if (this.ver.startsWith("CYGWIN_NT-")) {
            return "Windows";
        }
        return this.ver;
    }

    @Override
    public void formatEvent(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBytes(CommonUtils.formatLogDate(System.currentTimeMillis()));
        dataOutputStream.writeBytes(" ");
        dataOutputStream.writeBytes("[metadata] ");
        if (this.isLinked()) {
            dataOutputStream.writeBytes("beacon_" + this.getParentId() + " -> " + this.getInternal() + "; ");
        } else if ("".equals(this.getExternal())) {
            dataOutputStream.writeBytes("unknown <- " + this.getInternal() + "; ");
        } else {
            dataOutputStream.writeBytes(this.getExternal() + " <- " + this.getInternal() + "; ");
        }
        if (this.isSSH()) {
            CommonUtils.writeUTF8(dataOutputStream, "computer: " + this.getComputer() + "; ");
            CommonUtils.writeUTF8(dataOutputStream, "user: " + this.getUser() + "; ");
            dataOutputStream.writeBytes("os: " + this.getOperatingSystem() + "; ");
            dataOutputStream.writeBytes("port: " + this.getPort());
        } else {
            CommonUtils.writeUTF8(dataOutputStream, "computer: " + this.getComputer() + "; ");
            CommonUtils.writeUTF8(dataOutputStream, "user: " + this.getUser() + "; ");
            dataOutputStream.writeBytes("process: " + this.getProcess() + "; ");
            dataOutputStream.writeBytes("pid: " + this.getPid() + "; ");
            dataOutputStream.writeBytes("os: " + this.getOperatingSystem() + "; ");
            dataOutputStream.writeBytes("version: " + this.getVersion() + "; ");
            dataOutputStream.writeBytes("build: " + this.getBuild() + "; ");
            dataOutputStream.writeBytes("beacon arch: " + this.barch);
            if (this.is64()) {
                dataOutputStream.writeBytes(" (x64)");
            }
        }
        dataOutputStream.writeBytes("\n");
    }
}

