/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import java.util.Arrays;

public class ByteIterator {
    protected byte[] buffer;
    protected int index = 0;

    public ByteIterator(byte[] byArray) {
        this.buffer = byArray;
    }

    public boolean hasNext() {
        return this.index < this.buffer.length;
    }

    public byte[] next(long l) {
        int n = (int)l;
        if (this.index >= this.buffer.length) {
            return new byte[0];
        }
        if (this.index + n < this.buffer.length) {
            byte[] byArray = Arrays.copyOfRange(this.buffer, this.index, this.index + n);
            this.index += n;
            return byArray;
        }
        byte[] byArray = Arrays.copyOfRange(this.buffer, this.index, this.buffer.length);
        this.index = this.buffer.length;
        return byArray;
    }

    public void reset() {
        this.index = 0;
    }

    public static void test1() {
        byte[] byArray = CommonUtils.randomData(CommonUtils.rand(0xA00000));
        CommonUtils.print_warn("Garbage is: " + byArray.length);
        String string = CommonUtils.toHex(CommonUtils.MD5(byArray));
        ByteIterator byteIterator = new ByteIterator(byArray);
        byte[] byArray2 = new byte[]{};
        int n = 0;
        while (byteIterator.hasNext()) {
            byte[] byArray3 = byteIterator.next(0x100000L);
            CommonUtils.print_warn("Chunk " + n + ": " + byArray3.length);
            byArray2 = CommonUtils.join(byArray2, byArray3);
            ++n;
        }
        String string2 = CommonUtils.toHex(CommonUtils.MD5(byArray2));
        CommonUtils.print_info("MD5 (before): " + string);
        CommonUtils.print_info("MD5  (after): " + string2);
        if (!string.equals(string2)) {
            CommonUtils.print_error("FAILED!");
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < 8192; ++i) {
            ByteIterator.test1();
        }
        CommonUtils.print_good("PASSED!");
    }
}

