/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import common.HasUUID;
import common.Loggable;
import common.ScriptUtils;
import common.ToScalar;
import common.Transcript;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import sleep.runtime.Scalar;

public class Download
implements Serializable,
Transcript,
ToScalar,
Loggable,
HasUUID {
    protected long date;
    protected String bid;
    protected String name;
    protected String rpath;
    protected String lpath;
    protected long size;
    protected String host;
    protected long rcvd;
    protected int fid;
    protected String uuid;
    protected static final long serialVersionUID = 1L;

    public Download(int n, String string, String string2, String string3, String string4, String string5, long l) {
        this.fid = n;
        this.bid = string;
        this.name = string3;
        this.rpath = string4;
        this.lpath = string5;
        this.size = l;
        this.date = System.currentTimeMillis();
        this.host = string2;
        this.rcvd = new File(string5).length();
        this.uuid = CommonUtils.ID();
    }

    @Override
    public String getBeaconId() {
        return null;
    }

    @Override
    public void formatEvent(DataOutputStream dataOutputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CommonUtils.formatLogDate(this.date));
        stringBuffer.append("\t");
        stringBuffer.append(this.host);
        stringBuffer.append("\t");
        stringBuffer.append(this.bid);
        stringBuffer.append("\t");
        stringBuffer.append(this.size);
        stringBuffer.append("\t");
        stringBuffer.append(this.lpath);
        stringBuffer.append("\t");
        stringBuffer.append(this.name);
        stringBuffer.append("\t");
        stringBuffer.append(this.rpath);
        stringBuffer.append("\n");
        CommonUtils.writeUTF8(dataOutputStream, stringBuffer.toString());
    }

    @Override
    public String getLogFile() {
        return "downloads.log";
    }

    @Override
    public long getLogLimit() {
        return 0L;
    }

    @Override
    public String getLogEventName() {
        return "Download";
    }

    @Override
    public String getLogFolder() {
        return null;
    }

    @Override
    public String ID() {
        return this.uuid;
    }

    public String TSLocalPath() {
        return this.lpath;
    }

    public String toString() {
        return "file download";
    }

    @Override
    public Scalar toScalar() {
        return ScriptUtils.convertAll(this.toMap());
    }

    public Map toMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("host", this.host);
        hashMap.put("name", this.name);
        hashMap.put("date", this.date + "");
        hashMap.put("path", this.rpath);
        hashMap.put("lpath", this.lpath);
        hashMap.put("size", this.size + "");
        hashMap.put("rcvd", this.rcvd + "");
        hashMap.put("fid", this.fid + "");
        hashMap.put("id", this.uuid);
        hashMap.put("bid", this.bid);
        return hashMap;
    }
}

