/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AObject;
import common.Callback;
import common.CommonUtils;
import common.DownloadMessage;
import common.DownloadNotify;
import common.MudgeSanity;
import common.TeamQueue;
import dialog.DialogUtils;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.ProgressMonitor;

public class DownloadFile
extends AObject
implements Callback {
    protected OutputStream out = null;
    protected TeamQueue conn = null;
    protected DownloadNotify listener = null;
    protected String rpath = null;
    protected long total = 0L;
    protected long start = System.currentTimeMillis();
    protected long read = 0L;
    protected long ret = 0L;
    protected long sofar = 0L;
    protected double time = 0.0;
    protected ProgressMonitor progress = null;

    public DownloadFile(TeamQueue teamQueue, String string, OutputStream outputStream, DownloadNotify downloadNotify) {
        this.out = outputStream;
        this.listener = downloadNotify;
        this.conn = teamQueue;
        this.rpath = string;
    }

    @Override
    public void result(String string, Object object) {
        try {
            this._result(string, object);
        }
        catch (IOException iOException) {
            MudgeSanity.logException(string + " " + object, iOException, false);
        }
    }

    public void _result(String string, Object object) throws IOException {
        DownloadMessage downloadMessage = (DownloadMessage)object;
        if (downloadMessage.getType() == 0) {
            this.total = downloadMessage.getSize();
            this.progress = new ProgressMonitor(null, "Download", "Starting download", 0, (int)this.total);
            this.conn.call("download.get", CommonUtils.args(downloadMessage.id()), this);
        } else if (downloadMessage.getType() == 1) {
            this.time = (double)(System.currentTimeMillis() - this.start) / 1000.0;
            this.sofar += (long)downloadMessage.getData().length;
            this.progress.setProgress((int)this.sofar);
            this.progress.setNote("Speed: " + Math.round((double)(this.sofar / 1024L) / this.time) + " KB/s");
            if (this.progress.isCanceled()) {
                this.progress.close();
                if (this.listener != null) {
                    this.listener.cancel();
                }
                return;
            }
            this.out.write(downloadMessage.getData());
            this.conn.call("download.get", CommonUtils.args(downloadMessage.id()), this);
        } else if (downloadMessage.getType() == 2) {
            this.progress.close();
            if (this.listener != null) {
                this.listener.complete("");
            }
        } else if (downloadMessage.getType() == 3) {
            if (this.out != null && this.progress != null) {
                this.progress.setNote(downloadMessage.getError());
                if (this.listener != null) {
                    this.listener.cancel();
                }
            } else {
                DialogUtils.showError(downloadMessage.getError());
            }
        }
    }

    public void start() {
        this.conn.call("download.start", CommonUtils.args(this.rpath), this);
    }

    public void startKeystrokes() {
        this.conn.call("download.keystrokes.start", CommonUtils.args(this.rpath), this);
    }

    public void startScreenshot() {
        this.conn.call("download.screenshot.start", CommonUtils.args(this.rpath), this);
    }
}

