/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AObject;
import common.Callback;
import common.CommonUtils;
import common.DownloadMessage;
import common.DownloadNotify;
import common.MudgeSanity;
import common.TeamQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DownloadFileSimple
extends AObject
implements Callback {
    protected FileOutputStream out = null;
    protected File file = null;
    protected TeamQueue conn = null;
    protected DownloadNotify listener = null;
    protected String rpath = null;

    public DownloadFileSimple(TeamQueue teamQueue, String string, File file, DownloadNotify downloadNotify) {
        this.file = file;
        this.listener = downloadNotify;
        this.conn = teamQueue;
        this.rpath = string;
    }

    @Override
    public void result(String string, Object object) {
        try {
            this._result(string, object);
        }
        catch (IOException iOException) {
            MudgeSanity.logException(string + " " + object, iOException, false);
        }
    }

    public void _result(String string, Object object) throws IOException {
        DownloadMessage downloadMessage = (DownloadMessage)object;
        if (downloadMessage.getType() == 0) {
            this.out = new FileOutputStream(this.file, false);
            this.conn.call("download.get", CommonUtils.args(downloadMessage.id()), this);
        } else if (downloadMessage.getType() == 1) {
            this.out.write(downloadMessage.getData());
            this.conn.call("download.get", CommonUtils.args(downloadMessage.id()), this);
        } else if (downloadMessage.getType() == 2) {
            this.out.close();
            if (this.listener != null) {
                this.listener.complete(this.file.getAbsolutePath());
            }
        } else if (downloadMessage.getType() == 3) {
            if (this.out != null) {
                this.out.close();
                if (this.listener != null) {
                    this.listener.cancel();
                }
            } else {
                CommonUtils.print_error("download sync " + this.rpath + " failed: " + downloadMessage.getError());
            }
        }
    }

    public void start() {
        this.conn.call("download.start", CommonUtils.args(this.rpath), this);
    }
}

