/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import dialog.DialogUtils;
import java.util.HashMap;
import java.util.Map;

public class Guardrails {
    public static final String KEY_GUARDS = "guards";
    public static final String PROP_GUARDS = "props_guards_tabbed";
    public static final String PROP_GUARDS_FORMATTED = "props_guards_formatted";
    public static final String PROP_IP = "props_guardip";
    public static final String PROP_USER = "props_guarduser";
    public static final String PROP_SERVER = "props_guardserver";
    public static final String PROP_DOMAIN = "props_guarddomain";
    public String ipaddress = "";
    public String user = "";
    public String server = "";
    public String domain = "";

    public boolean hasGuardrails() {
        return this.ipaddress.length() > 0 || this.user.length() > 0 || this.server.length() > 0 || this.domain.length() > 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!CommonUtils.isNullOrEmpty(this.ipaddress)) {
            stringBuffer.append(" IP=" + this.ipaddress);
        }
        if (!CommonUtils.isNullOrEmpty(this.user)) {
            stringBuffer.append(" User=" + this.user);
        }
        if (!CommonUtils.isNullOrEmpty(this.server)) {
            stringBuffer.append(" Server=" + this.server);
        }
        if (!CommonUtils.isNullOrEmpty(this.domain)) {
            stringBuffer.append(" Domain=" + this.domain);
        }
        return stringBuffer.toString().trim();
    }

    public String toTabDelString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.ipaddress);
        stringBuffer.append("\t" + this.user);
        stringBuffer.append("\t" + this.server);
        stringBuffer.append("\t" + this.domain);
        return stringBuffer.toString();
    }

    public static Guardrails resolveFromProps(Map map2) {
        Guardrails guardrails = new Guardrails();
        guardrails.ipaddress = DialogUtils.string(map2, PROP_IP);
        guardrails.user = DialogUtils.string(map2, PROP_USER);
        guardrails.server = DialogUtils.string(map2, PROP_SERVER);
        guardrails.domain = DialogUtils.string(map2, PROP_DOMAIN);
        return guardrails;
    }

    public static Guardrails resolveFromModel(Map map2) {
        Guardrails guardrails = Guardrails.parseTabDelString(DialogUtils.string(map2, KEY_GUARDS));
        return guardrails;
    }

    public Map toPropsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PROP_IP, this.ipaddress);
        hashMap.put(PROP_USER, this.user);
        hashMap.put(PROP_SERVER, this.server);
        hashMap.put(PROP_DOMAIN, this.domain);
        return hashMap;
    }

    public static Guardrails parseTabDelString(String string) {
        Guardrails guardrails = new Guardrails();
        if (string != null && string.trim().length() != 0) {
            String[] stringArray = string.split("\t", -1);
            if (stringArray.length > 4) {
                CommonUtils.print_error("Length error parsing guardrail callback: " + stringArray.length);
            } else {
                if (stringArray.length > 0) {
                    guardrails.ipaddress = stringArray[0];
                }
                if (stringArray.length > 1) {
                    guardrails.user = stringArray[1];
                }
                if (stringArray.length > 2) {
                    guardrails.server = stringArray[2];
                }
                if (stringArray.length > 3) {
                    guardrails.domain = stringArray[3];
                }
            }
        }
        return guardrails;
    }
}

