/*
 * Decompiled with CFR 0.152.
 */
package common;

import aggressor.AggressorClient;
import aggressor.DataManager;
import aggressor.DataUtils;
import aggressor.GlobalDataManager;
import common.CommonUtils;
import common.Guardrails;
import common.ScListener;
import dialog.DialogUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ListenerUtils {
    public static boolean checkPort(Map map2, String string, String string2) {
        String string3 = (String)map2.get(string);
        int n = CommonUtils.toNumber(string3, 0);
        if ("".equals(string3) || string3 == null) {
            DialogUtils.showError(string2 + " is a required value.");
            return false;
        }
        if (!CommonUtils.isNumber(string3)) {
            DialogUtils.showError(string2 + " is not a valid number.");
            return false;
        }
        if (n < 0 || n > 65535) {
            DialogUtils.showError(string2 + " is out of range for a port.");
            return false;
        }
        return true;
    }

    public static boolean checkIPAddress(Map map2, String string, String string2) {
        String string3 = (String)map2.get(string);
        String string4 = "(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])";
        String string5 = string4 + "\\." + string4 + "\\." + string4 + "\\." + string4;
        Pattern pattern = Pattern.compile(string5);
        if ("".equals(string3) || string3 == null) {
            return true;
        }
        Matcher matcher = pattern.matcher(string3);
        if (!matcher.matches()) {
            DialogUtils.showError(string2 + " is not a valid IP V4 Address.");
            return false;
        }
        return true;
    }

    public static boolean validate(Map map2) {
        String string = (String)map2.get("name");
        String string2 = (String)map2.get("host");
        String string3 = (String)map2.get("beacons");
        String string4 = (String)map2.get("payload");
        CommonUtils.print_info("Payload is '" + string4 + "' and " + map2);
        if (string == null || "".equals(string)) {
            DialogUtils.showError("Your listener needs a name");
            return false;
        }
        if (string4 == null || "".equals(string4)) {
            DialogUtils.showError("Please select a payload");
            return false;
        }
        if (string4.equals("windows/beacon_bind_tcp")) {
            if (!ListenerUtils.checkPort(map2, "port", "Port (C2)")) {
                return false;
            }
        } else if (string4.equals("windows/beacon_extc2")) {
            if (!ListenerUtils.checkPort(map2, "port", "Port (Bind)")) {
                return false;
            }
        } else if (string4.equals("windows/beacon_bind_pipe")) {
            String string5 = (String)map2.get("port");
            if ("".equals(string5) || string5 == null) {
                DialogUtils.showError("Pipename (C2) need a value");
                return false;
            }
            if (string5.length() > 118) {
                DialogUtils.showError("Pipename (C2) is too long. Max is 118 characters.");
                return false;
            }
        } else if (string4.equals("windows/foreign/reverse_http") || string4.equals("windows/foreign/reverse_https")) {
            if (!ListenerUtils.checkPort(map2, "port", "Port")) {
                return false;
            }
            if (string2 == null || "".equals(string2)) {
                DialogUtils.showError("Host (Stager) value is required for a listener");
                return false;
            }
            if (string2.indexOf(",") > -1 || string2.indexOf(" ") > -1) {
                DialogUtils.showError("Please specify one value in the Host (Stager) field");
                return false;
            }
        } else {
            if (!ListenerUtils.checkPort(map2, "port", "Port")) {
                return false;
            }
            if (!ListenerUtils.checkIPAddress(map2, "dnsresolver", "DNS Resolver")) {
                return false;
            }
            int n = DialogUtils.number(map2, "port");
            if (n == 19 || n == 21 || n == 25 || n == 110 || n == 119 || n == 143 || n == 220 || n == 993 || n == 220 || n == 993) {
                DialogUtils.showError("Port " + n + " is blocked by WinINet to prevent Cross Service/Request Forgery in Internet Explorer.");
                return false;
            }
            if (!"".equals(map2.get("bindto")) && map2.get("bindto") != null && !ListenerUtils.checkPort(map2, "bindto", "Port (Bind)")) {
                return false;
            }
            if (string2 == null || "".equals(string2)) {
                DialogUtils.showError("Host (Stager) value is required for a listener");
                return false;
            }
            if (string2.indexOf(",") > -1 || string2.indexOf(" ") > -1) {
                DialogUtils.showError("Please specify one value in the Host (Stager) field");
                return false;
            }
            if (string3 == null || "".equals(string3)) {
                DialogUtils.showError("Please specify one or more Callback Hosts");
                return false;
            }
        }
        return true;
    }

    public static boolean checkGuardrails(Map map2) {
        String string;
        String string2 = (String)map2.get("props_guardip");
        String string3 = (String)map2.get("props_guarduser");
        String string4 = (String)map2.get("props_guardserver");
        String string5 = (String)map2.get("props_guarddomain");
        if (!CommonUtils.isNullOrEmpty(string2)) {
            string = "IP Address";
            if (ListenerUtils.hasWhiteSpace(string, string2)) {
                return false;
            }
            String string6 = string2;
            if (string6.endsWith(".*.*.*")) {
                string6 = string6.replace(".*.*.*", ".1.1.1");
            } else if (string6.endsWith(".*.*")) {
                string6 = string6.replace(".*.*", ".1.1");
            } else if (string6.endsWith(".*")) {
                string6 = string6.replace(".*", ".1");
            }
            if (!ListenerUtils.validGuardrailIPAddress(string, string6)) {
                DialogUtils.showError(string + " is not a valid IP Address. Valid formats are nnn.nnn.nnn.nnn, nnn.nnn.nnn.*, nnn.nnn.*.*, or nnn.*.*.*");
                return false;
            }
        }
        if (!CommonUtils.isNullOrEmpty(string3)) {
            string = "User Name";
            if (ListenerUtils.hasLORTWhiteSpace(string, string3)) {
                return false;
            }
            if (ListenerUtils.hasBadWildcard(string, string3)) {
                return false;
            }
        }
        if (!CommonUtils.isNullOrEmpty(string4)) {
            string = "Server Name";
            if (ListenerUtils.hasWhiteSpace(string, string4)) {
                return false;
            }
            if (ListenerUtils.hasBadWildcard(string, string4)) {
                return false;
            }
        }
        if (!CommonUtils.isNullOrEmpty(string5)) {
            string = "Domain";
            if (ListenerUtils.hasWhiteSpace(string, string5)) {
                return false;
            }
            if (ListenerUtils.hasBadWildcard(string, string5)) {
                return false;
            }
        }
        return true;
    }

    protected static boolean hasLORTWhiteSpace(String string, String string2) {
        if (string2.matches("\\s.*") || string2.matches(".*\\s")) {
            DialogUtils.showError(string + " contains leading or trailing whitespace.");
            return true;
        }
        return false;
    }

    protected static boolean hasWhiteSpace(String string, String string2) {
        if (string2.matches(".*\\s.*")) {
            DialogUtils.showError(string + " contains whitespace.");
            return true;
        }
        return false;
    }

    protected static boolean hasBadWildcard(String string, String string2) {
        String string3 = string2.trim();
        if (string3.equals("*")) {
            DialogUtils.showError(string + " wildcard format requires 'something*' OR '*something'");
            return true;
        }
        if (string3.length() > 1 && string3.startsWith("*") && string3.endsWith("*")) {
            DialogUtils.showError(string + " wildcard format CANNOT start and end with a wildcard.");
            return true;
        }
        return false;
    }

    public static boolean validGuardrailIPAddress(String string, String string2) {
        String string3 = "(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])";
        String string4 = string3 + "\\." + string3 + "\\." + string3 + "\\." + string3;
        Pattern pattern = Pattern.compile(string4);
        Matcher matcher = pattern.matcher(string2);
        return matcher.matches();
    }

    public static Map dialogToMap(Map map2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = CommonUtils.trim(DialogUtils.string(map2, "name"));
        String string2 = DialogUtils.string(map2, "payload");
        hashMap.put("name", string);
        if (map2.containsKey("_accent")) {
            hashMap.put("_accent", (String)map2.get("_accent"));
        }
        if ("Beacon HTTP".equals(string2)) {
            hashMap.put("payload", "windows/beacon_http/reverse_http");
            hashMap.put("port", DialogUtils.string(map2, "http_port"));
            hashMap.put("host", DialogUtils.string(map2, "http_host"));
            hashMap.put("beacons", DialogUtils.string(map2, "http_hosts"));
            hashMap.put("strategy", DialogUtils.string(map2, "http_strategy"));
            hashMap.put("maxretry", DialogUtils.string(map2, "http_retry"));
            hashMap.put("proxy", DialogUtils.string(map2, "http_proxy"));
            hashMap.put("althost", DialogUtils.string(map2, "http_hosth"));
            hashMap.put("bindto", DialogUtils.string(map2, "http_bind"));
            hashMap.put("profile", DialogUtils.string(map2, "http_profile"));
            hashMap.put("guards", DialogUtils.string(map2, "http_guards"));
        } else if ("Beacon HTTPS".equals(string2)) {
            hashMap.put("payload", "windows/beacon_https/reverse_https");
            hashMap.put("port", DialogUtils.string(map2, "https_port"));
            hashMap.put("host", DialogUtils.string(map2, "https_host"));
            hashMap.put("beacons", DialogUtils.string(map2, "https_hosts"));
            hashMap.put("strategy", DialogUtils.string(map2, "https_strategy"));
            hashMap.put("maxretry", DialogUtils.string(map2, "https_retry"));
            hashMap.put("proxy", DialogUtils.string(map2, "https_proxy"));
            hashMap.put("althost", DialogUtils.string(map2, "https_hosth"));
            hashMap.put("bindto", DialogUtils.string(map2, "https_bind"));
            hashMap.put("profile", DialogUtils.string(map2, "https_profile"));
            hashMap.put("guards", DialogUtils.string(map2, "https_guards"));
        } else if ("External C2".equals(string2)) {
            hashMap.put("payload", "windows/beacon_extc2");
            hashMap.put("localonly", DialogUtils.string(map2, "extc2_local"));
            hashMap.put("port", DialogUtils.string(map2, "extc2_port"));
            if (DialogUtils.bool(map2, "extc2_local")) {
                hashMap.put("beacons", "127.0.0.1");
            } else {
                hashMap.put("beacons", "0.0.0.0");
            }
        } else if ("Foreign HTTP".equals(string2)) {
            hashMap.put("payload", "windows/foreign/reverse_http");
            hashMap.put("port", DialogUtils.string(map2, "http_f_port"));
            hashMap.put("host", DialogUtils.string(map2, "http_f_host"));
        } else if ("Foreign HTTPS".equals(string2)) {
            hashMap.put("payload", "windows/foreign/reverse_https");
            hashMap.put("port", DialogUtils.string(map2, "https_f_port"));
            hashMap.put("host", DialogUtils.string(map2, "https_f_host"));
        } else if ("Beacon DNS".equals(string2)) {
            hashMap.put("payload", "windows/beacon_dns/reverse_dns_txt");
            hashMap.put("beacons", DialogUtils.string(map2, "dns_hosts"));
            hashMap.put("strategy", DialogUtils.string(map2, "dns_strategy"));
            hashMap.put("maxretry", DialogUtils.string(map2, "dns_retry"));
            hashMap.put("host", DialogUtils.string(map2, "dns_host"));
            hashMap.put("bindto", DialogUtils.string(map2, "dns_bind"));
            hashMap.put("port", "53");
            hashMap.put("profile", DialogUtils.string(map2, "dns_profile"));
            hashMap.put("dnsresolver", DialogUtils.string(map2, "dns_resolver"));
            hashMap.put("guards", DialogUtils.string(map2, "dns_guards"));
        } else if ("Beacon SMB".equals(string2)) {
            hashMap.put("payload", "windows/beacon_bind_pipe");
            hashMap.put("port", DialogUtils.string(map2, "smb_pipe"));
            hashMap.put("guards", DialogUtils.string(map2, "smb_guards"));
        } else if ("Beacon TCP".equals(string2)) {
            hashMap.put("payload", "windows/beacon_bind_tcp");
            hashMap.put("localonly", DialogUtils.string(map2, "tcp_local"));
            hashMap.put("port", DialogUtils.string(map2, "tcp_port"));
            if (DialogUtils.bool(map2, "tcp_local")) {
                hashMap.put("beacons", "127.0.0.1");
            } else {
                hashMap.put("beacons", "0.0.0.0");
            }
            hashMap.put("guards", DialogUtils.string(map2, "tcp_guards"));
        }
        return hashMap;
    }

    public static Map ExternalC2Map(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("payload", "windows/beacon_bind_pipe");
        hashMap.put("port", string);
        hashMap.put("localhost", "true");
        hashMap.put("name", "<ExternalC2.Anonymous>");
        return hashMap;
    }

    public static Map mapToDialog(Map map2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = CommonUtils.trim(DialogUtils.string(map2, "name"));
        String string2 = DialogUtils.string(map2, "payload");
        hashMap.put("name", string);
        if (map2.containsKey("_accent")) {
            hashMap.put("_accent", (String)map2.get("_accent"));
        }
        if ("windows/beacon_http/reverse_http".equals(string2)) {
            hashMap.put("payload", "Beacon HTTP");
            hashMap.put("http_port", (String)map2.get("port"));
            hashMap.put("http_host", (String)map2.get("host"));
            hashMap.put("http_hosts", (String)map2.get("beacons"));
            hashMap.put("http_strategy", (String)map2.get("strategy"));
            hashMap.put("http_retry", (String)map2.get("maxretry"));
            hashMap.put("http_proxy", (String)map2.get("proxy"));
            hashMap.put("http_hosth", (String)map2.get("althost"));
            hashMap.put("http_bind", (String)map2.get("bindto"));
            hashMap.put("http_profile", (String)map2.get("profile"));
            Guardrails guardrails = Guardrails.resolveFromModel(map2);
            hashMap.put("http_guards_formatted", guardrails.toString());
            hashMap.put("http_guards", guardrails.toTabDelString());
        } else if ("windows/beacon_https/reverse_https".equals(string2)) {
            hashMap.put("payload", "Beacon HTTPS");
            hashMap.put("https_port", (String)map2.get("port"));
            hashMap.put("https_host", (String)map2.get("host"));
            hashMap.put("https_hosts", (String)map2.get("beacons"));
            hashMap.put("https_strategy", (String)map2.get("strategy"));
            hashMap.put("https_retry", (String)map2.get("maxretry"));
            hashMap.put("https_proxy", (String)map2.get("proxy"));
            hashMap.put("https_hosth", (String)map2.get("althost"));
            hashMap.put("https_bind", (String)map2.get("bindto"));
            hashMap.put("https_profile", (String)map2.get("profile"));
            Guardrails guardrails = Guardrails.resolveFromModel(map2);
            hashMap.put("https_guards_formatted", guardrails.toString());
            hashMap.put("https_guards", guardrails.toTabDelString());
        } else if ("windows/beacon_dns/reverse_dns_txt".equals(string2)) {
            hashMap.put("payload", "Beacon DNS");
            hashMap.put("dns_port", (String)map2.get("port"));
            hashMap.put("dns_host", (String)map2.get("host"));
            hashMap.put("dns_hosts", (String)map2.get("beacons"));
            hashMap.put("dns_strategy", (String)map2.get("strategy"));
            hashMap.put("dns_retry", (String)map2.get("maxretry"));
            hashMap.put("dns_bind", (String)map2.get("bindto"));
            hashMap.put("dns_profile", (String)map2.get("profile"));
            Guardrails guardrails = Guardrails.resolveFromModel(map2);
            hashMap.put("dns_guards_formatted", guardrails.toString());
            hashMap.put("dns_guards", guardrails.toTabDelString());
            hashMap.put("dns_resolver", DialogUtils.string(map2, "dnsresolver"));
        } else if ("windows/beacon_bind_pipe".equals(string2)) {
            hashMap.put("payload", "Beacon SMB");
            hashMap.put("smb_pipe", (String)map2.get("port"));
            Guardrails guardrails = Guardrails.resolveFromModel(map2);
            hashMap.put("smb_guards_formatted", guardrails.toString());
            hashMap.put("smb_guards", guardrails.toTabDelString());
        } else if ("windows/beacon_bind_tcp".equals(string2)) {
            hashMap.put("payload", "Beacon TCP");
            hashMap.put("tcp_port", (String)map2.get("port"));
            hashMap.put("tcp_local", (String)map2.get("localonly"));
            Guardrails guardrails = Guardrails.resolveFromModel(map2);
            hashMap.put("tcp_guards_formatted", guardrails.toString());
            hashMap.put("tcp_guards", guardrails.toTabDelString());
        } else if ("windows/beacon_extc2".equals(string2)) {
            hashMap.put("payload", "External C2");
            hashMap.put("extc2_local", (String)map2.get("localonly"));
            hashMap.put("extc2_port", (String)map2.get("port"));
        } else if ("windows/foreign/reverse_http".equals(string2)) {
            hashMap.put("payload", "Foreign HTTP");
            hashMap.put("http_f_port", (String)map2.get("port"));
            hashMap.put("http_f_host", (String)map2.get("host"));
        } else if ("windows/foreign/reverse_https".equals(string2)) {
            hashMap.put("payload", "Foreign HTTPS");
            hashMap.put("https_f_port", (String)map2.get("port"));
            hashMap.put("https_f_host", (String)map2.get("host"));
        }
        return hashMap;
    }

    public static boolean isVisible(Map map2) {
        String string = DialogUtils.string(map2, "payload");
        return !string.equals("windows/beacon_extc2");
    }

    public static List getListenerNames(AggressorClient aggressorClient) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map map2 : ListenerUtils.getAllListeners(aggressorClient)) {
            if (!ListenerUtils.isVisible(map2)) continue;
            linkedList.add(DialogUtils.string(map2, "name"));
        }
        return linkedList;
    }

    public static boolean isListener(String string) {
        for (Map.Entry entry : GlobalDataManager.getGlobalDataManager().getStore("listeners").entrySet()) {
            Map map2 = (Map)entry.getValue();
            for (Map map3 : map2.values()) {
                String string2 = DialogUtils.string(map3, "name");
                if (!string.equals(string2) || !ListenerUtils.isVisible(map3)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLocalListener(AggressorClient aggressorClient, String string) {
        return DataUtils.getListenerByName(aggressorClient.getData(), string) != null;
    }

    public static ScListener getListener(AggressorClient aggressorClient, String string) {
        Map map2 = DataUtils.getListenerByName(aggressorClient.getData(), string);
        if (map2 != null) {
            return new ScListener(aggressorClient.getData(), map2);
        }
        GlobalDataManager globalDataManager = GlobalDataManager.getGlobalDataManager();
        Map map3 = globalDataManager.getStore("listeners");
        for (Map.Entry entry : map3.entrySet()) {
            DataManager dataManager = (DataManager)entry.getKey();
            Map map4 = (Map)entry.getValue();
            if (!map4.containsKey(string)) continue;
            return new ScListener(dataManager, (Map)map4.get(string));
        }
        return null;
    }

    public static List getListenersLocal(AggressorClient aggressorClient) {
        LinkedList<Map> linkedList = new LinkedList<Map>();
        for (Map map2 : DataUtils.getListeners(aggressorClient.getData()).values()) {
            String string = DialogUtils.string(map2, "name");
            if (!ListenerUtils.isVisible(map2)) continue;
            linkedList.add(map2);
        }
        return linkedList;
    }

    public static List getListenersWithStagers(AggressorClient aggressorClient) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object2 : DataUtils.getListeners(aggressorClient.getData()).values()) {
            String object3 = DialogUtils.string((Map)object2, "name");
            object = new ScListener(aggressorClient.getData(), (Map)object2);
            if (hashSet.contains(object3) || !((ScListener)object).hasStager() || !ListenerUtils.isVisible((Map)object2)) continue;
            linkedList.add(object2);
            hashSet.add(object3);
        }
        for (Map.Entry entry : GlobalDataManager.getGlobalDataManager().getStore("listeners").entrySet()) {
            object = (DataManager)entry.getKey();
            Map map2 = (Map)entry.getValue();
            if (object == aggressorClient.getData()) continue;
            for (Map map3 : map2.values()) {
                String string = DialogUtils.string(map3, "name");
                ScListener scListener = new ScListener((DataManager)object, map3);
                if (hashSet.contains(string) || !scListener.hasStager() || !ListenerUtils.isVisible(map3)) continue;
                linkedList.add(map3);
                hashSet.add(string);
            }
        }
        return linkedList;
    }

    public static List getAllListeners(AggressorClient aggressorClient) {
        HashSet<String> hashSet = new HashSet<String>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object : DataUtils.getListeners(aggressorClient.getData()).values()) {
            String object2 = DialogUtils.string((Map)object, "name");
            if (hashSet.contains(object2) || !ListenerUtils.isVisible((Map)object)) continue;
            linkedList.add(object);
            hashSet.add(object2);
        }
        for (Map.Entry entry : GlobalDataManager.getGlobalDataManager().getStore("listeners").entrySet()) {
            DataManager dataManager = (DataManager)entry.getKey();
            Map map2 = ListenerUtils.filterLocal((Map)entry.getValue());
            if (dataManager == aggressorClient.getData()) continue;
            for (Map map3 : map2.values()) {
                String string = DialogUtils.string(map3, "name");
                if (hashSet.contains(string) || !ListenerUtils.isVisible(map3)) continue;
                linkedList.add(map3);
                hashSet.add(string);
            }
        }
        return linkedList;
    }

    public static Map filterLocal(Map map2) {
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Map map3 = (Map)entry.getValue();
            if ("windows/beacon_bind_pipe".equals(map3.get("payload"))) {
                iterator.remove();
                continue;
            }
            if (!"windows/beacon_bind_tcp".equals(map3.get("payload"))) continue;
            iterator.remove();
        }
        return map2;
    }
}

