/*
 * Decompiled with CFR 0.152.
 */
package common;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import common.CommonUtils;
import common.MudgeSanity;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Packer {
    protected ByteArrayOutputStream out;
    protected DataOutputStream data;
    protected byte[] bdata = new byte[8];
    protected ByteBuffer buffer = null;

    public Packer() {
        this.out = new ByteArrayOutputStream(1024);
        this.data = new DataOutputStream(this.out);
        this.buffer = ByteBuffer.wrap(this.bdata);
    }

    public void little() {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void big() {
        this.buffer.order(ByteOrder.BIG_ENDIAN);
    }

    public void addInteger(int n) {
        this.addInt(n);
    }

    public void addInt(int n) {
        this.buffer.putInt(0, n);
        this.write(this.bdata, 0, 4);
    }

    public void append(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void addIntWithMask(int n, int n2) {
        this.buffer.putInt(0, n);
        ByteOrder byteOrder = this.buffer.order();
        this.big();
        int n3 = this.buffer.getInt(0);
        this.buffer.putInt(0, n3 ^ n2);
        this.write(this.bdata, 0, 4);
        this.buffer.order(byteOrder);
    }

    public void addUnicodeString(String string, int n) {
        try {
            this.addShort(string.length());
            this.addShort(n);
            for (int i = 0; i < string.length(); ++i) {
                this.data.writeChar(string.charAt(i));
            }
        }
        catch (IOException iOException) {
            MudgeSanity.logException("addUnicodeString: " + string, iOException, false);
        }
    }

    public void addByte(int n) {
        try {
            this.data.write((byte)n);
        }
        catch (IOException iOException) {
            MudgeSanity.logException("addByte (int): " + n, iOException, false);
        }
    }

    public void addByte(byte by) {
        try {
            this.data.write(by);
        }
        catch (IOException iOException) {
            MudgeSanity.logException("addByte (byte): " + by, iOException, false);
        }
    }

    public void addBytes(byte[] byArray) {
        try {
            this.data.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            MudgeSanity.logException("addBytes: " + byArray.length + " (length)", iOException, false);
        }
    }

    public void addHex(String string) {
        try {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer("FF");
            for (int i = 0; i < cArray.length; i += 2) {
                stringBuffer.setCharAt(0, cArray[i]);
                stringBuffer.setCharAt(1, cArray[i + 1]);
                this.data.writeByte(Integer.parseInt(stringBuffer.toString(), 16));
            }
        }
        catch (IOException iOException) {
            MudgeSanity.logException("addHex: " + string, iOException, false);
        }
    }

    protected void write(byte[] byArray, int n, int n2) {
        try {
            this.data.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            MudgeSanity.logException("write", iOException, false);
        }
    }

    public void addShort(int n) {
        this.buffer.putShort(0, (short)n);
        this.write(this.bdata, 0, 2);
    }

    public void addString(String string) {
        this.addString(string, string.length());
    }

    public void addString(String string, int n) {
        this.addString(CommonUtils.toBytes(string), n);
    }

    public void pad(char c, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)c;
        }
        this.write(byArray, 0, byArray.length);
    }

    public void padTo(char c, int n) {
        while (this.size() < (long)n) {
            this.addByte(c);
        }
    }

    public void addString(byte[] byArray, int n) {
        this.write(byArray, 0, byArray.length);
        if (byArray.length < n) {
            byte[] byArray2 = new byte[n - byArray.length];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = 0;
            }
            this.write(byArray2, 0, byArray2.length);
        }
    }

    public void addStringUTF8(String string, int n) {
        try {
            this.addString(string.getBytes("UTF-8"), n);
        }
        catch (Exception exception) {
            MudgeSanity.logException("addStringUTF8", exception, false);
        }
    }

    public void addWideString(String string) {
        try {
            this.append(string.getBytes("UTF-16LE"));
        }
        catch (Exception exception) {
            MudgeSanity.logException("addWideString", exception, false);
        }
    }

    public void addWideString(String string, int n) {
        try {
            this.addString(string.getBytes("UTF-16LE"), n);
        }
        catch (Exception exception) {
            MudgeSanity.logException("addWideString", exception, false);
        }
    }

    public byte[] getBytes() {
        byte[] byArray = this.out.toByteArray();
        try {
            this.data.close();
        }
        catch (IOException iOException) {
            MudgeSanity.logException("getBytes", iOException, false);
        }
        return byArray;
    }

    public long size() {
        return this.out.size();
    }

    public void addLengthAndString(String string) {
        this.addLengthAndString(CommonUtils.toBytes(string));
    }

    public void addLengthAndWideStringASCIIZ(String string) {
        this.addLengthAndString(CommonUtils.toBytes(string + '\u0000', "UTF-16LE"));
    }

    public void addLengthAndStringASCIIZ(String string) {
        this.addLengthAndString(string + '\u0000');
    }

    public void addEncodedString(AggressorClient aggressorClient, String string, String string2) {
        this.append(DataUtils.encodeForBeacon(aggressorClient.getData(), string, string2));
    }

    public void addLengthAndEncodedString(AggressorClient aggressorClient, String string, String string2) {
        this.addLengthAndString(DataUtils.encodeForBeacon(aggressorClient.getData(), string, string2));
    }

    public void addLengthAndEncodedStringASCIIZ(AggressorClient aggressorClient, String string, String string2) {
        this.addLengthAndEncodedString(aggressorClient, string, string2 + '\u0000');
    }

    public void addLengthAndString(byte[] byArray) {
        if (byArray.length == 0) {
            this.addInt(0);
        } else {
            this.addInt(byArray.length);
            this.append(byArray);
        }
    }

    public void addShortLengthAndStringASCIIZ(String string) {
        this.addShortLengthAndString(string + '\u0000');
    }

    public void addShortLengthAndString(String string) {
        this.addShortLengthAndString(CommonUtils.toBytes(string));
    }

    public void addShortLengthAndString(byte[] byArray) {
        if (byArray.length == 0) {
            this.addShort(0);
        } else {
            this.addShort(byArray.length);
            this.append(byArray);
        }
    }
}

